/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.model.commands;

import com.archimatetool.model.IFeatures;
import com.archimatetool.model.IFeaturesEList;
import java.util.Objects;
import org.eclipse.gef.commands.Command;

public class FeatureCommand
extends Command {
    private IFeaturesEList features;
    private String name;
    private String value;
    private String oldValue;
    private String defaultValue;

    public FeatureCommand(String label, IFeatures featuresObject, String name, Object value, Object defaultValue) {
        this.setLabel(label);
        this.features = featuresObject.getFeatures();
        this.name = name;
        this.value = value != null ? value.toString() : "";
        this.defaultValue = defaultValue != null ? defaultValue.toString() : "";
        this.oldValue = this.features.getString(name, this.defaultValue);
    }

    public void execute() {
        this.features.putString(this.name, this.value, this.defaultValue);
    }

    public void undo() {
        this.features.putString(this.name, this.oldValue, this.defaultValue);
    }

    public boolean canExecute() {
        return !Objects.equals(this.value, this.oldValue);
    }

    public void dispose() {
        this.features = null;
    }
}

