/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.model.commands;

import java.util.List;
import org.eclipse.gef.commands.Command;

public class RemoveListMemberCommand<E>
extends Command {
    private List<E> list;
    private E object;
    private int index;

    public RemoveListMemberCommand(String label, List<E> list, E object) {
        this.setLabel(label);
        this.list = list;
        this.object = object;
    }

    public RemoveListMemberCommand(List<E> list, E object) {
        this(null, list, object);
    }

    public void execute() {
        this.index = this.list.indexOf(this.object);
        if (this.index != -1) {
            this.list.remove(this.index);
        }
    }

    public void undo() {
        if (this.index != -1) {
            this.list.add(this.index, this.object);
        }
    }

    public void dispose() {
        this.list = null;
        this.object = null;
    }
}

