/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.model.commands;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.model.DiagramModelUtils;
import com.archimatetool.editor.model.commands.AddListMemberCommand;
import com.archimatetool.editor.model.commands.AlwaysExecutingChainedCompoundCommand;
import com.archimatetool.editor.model.commands.Messages;
import com.archimatetool.editor.model.commands.RemoveListMemberCommand;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateFactory;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelArchimateConnection;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IDiagramModelContainer;
import com.archimatetool.model.IFolder;
import com.archimatetool.model.util.ArchimateModelUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.osgi.util.NLS;

public class SetConceptTypeCommandFactory {
    public static CompoundCommand createSetElementTypeCommand(EClass eClass, IArchimateElement element, boolean doAddDocumentationNote) {
        return SetConceptTypeCommandFactory.createSetElementTypeCommand(eClass, Set.of(element), doAddDocumentationNote);
    }

    public static CompoundCommand createSetElementTypeCommand(final EClass eClass, Set<IArchimateElement> elements, final boolean doAddDocumentationNote) {
        final ArrayList<SetConceptTypeCommand> commands = new ArrayList<SetConceptTypeCommand>();
        for (IArchimateElement element : elements) {
            SetConceptTypeCommand cmd = SetConceptTypeCommandFactory.createSetElementTypeCommand(eClass, element);
            if (cmd == null) continue;
            commands.add(cmd);
        }
        if (commands.isEmpty()) {
            return null;
        }
        AlwaysExecutingChainedCompoundCommand command = new AlwaysExecutingChainedCompoundCommand(Messages.SetConceptTypeCommandFactory_0){

            public void execute() {
                for (SetConceptTypeCommand cmd : commands) {
                    this.add((Command)cmd);
                }
                for (SetConceptTypeCommand cmd : commands) {
                    this.add(SetConceptTypeCommandFactory.changeInvalidRelations(eClass, cmd.getNewConcept(), doAddDocumentationNote));
                }
            }
        };
        return command;
    }

    private static SetConceptTypeCommand createSetElementTypeCommand(final EClass eClass, final IArchimateElement element) {
        if (element.getArchimateModel() == null || eClass == element.eClass() || eClass == IArchimatePackage.eINSTANCE.getJunction() || element.eClass() == IArchimatePackage.eINSTANCE.getJunction()) {
            return null;
        }
        SetConceptTypeCommand command = new SetConceptTypeCommand(){
            IArchimateElement newElement;

            public void execute() {
                this.newElement = (IArchimateElement)IArchimateFactory.eINSTANCE.create(eClass);
                this.newElement.setName(element.getName());
                Collection props = EcoreUtil.copyAll((Collection)element.getProperties());
                this.newElement.getProperties().addAll(props);
                Collection features = EcoreUtil.copyAll((Collection)element.getFeatures());
                this.newElement.getFeatures().addAll(features);
                this.newElement.setDocumentation(element.getDocumentation());
                this.add(new AddListMemberCommand<IArchimateElement>((List<IArchimateElement>)SetConceptTypeCommandFactory.getFolderForNewConcept((IArchimateConcept)element, (IArchimateConcept)this.newElement).getElements(), this.newElement));
                this.add((Command)SetConceptTypeCommandFactory.createRelationshipEndsCommand((IArchimateConcept)element, (IArchimateConcept)this.newElement));
                for (IDiagramModel dm : element.getArchimateModel().getDiagramModels()) {
                    for (final IDiagramModelArchimateObject dmo : DiagramModelUtils.findDiagramModelObjectsForElement(dm, element)) {
                        this.add(new Command(){
                            IDiagramModelContainer parent;
                            int index;
                            int oldType;
                            int newType;
                            {
                                this.parent = (IDiagramModelContainer)iDiagramModelArchimateObject.eContainer();
                                this.index = this.parent.getChildren().indexOf((Object)iDiagramModelArchimateObject);
                                this.oldType = iDiagramModelArchimateObject.getType();
                                this.newType = ArchiPlugin.getInstance().getPreferenceStore().getInt("defaultFigure" + var1_1.newElement.eClass().getName());
                            }

                            public void execute() {
                                this.parent.getChildren().remove((Object)dmo);
                                dmo.setArchimateElement(newElement);
                                dmo.setType(this.newType);
                                this.parent.getChildren().add(this.index, (Object)dmo);
                            }

                            public void undo() {
                                this.parent.getChildren().remove((Object)dmo);
                                dmo.setArchimateElement(element);
                                dmo.setType(this.oldType);
                                this.parent.getChildren().add(this.index, (Object)dmo);
                            }

                            public void dispose() {
                                this.parent = null;
                            }
                        });
                    }
                }
                this.add(new RemoveListMemberCommand<IArchimateElement>((List<IArchimateElement>)((IFolder)element.eContainer()).getElements(), element));
            }

            @Override
            public IArchimateConcept getNewConcept() {
                return this.newElement;
            }

            public void dispose() {
                this.newElement = null;
            }
        };
        return command;
    }

    public static CompoundCommand createSetRelationTypeCommand(EClass eClass, IArchimateRelationship relation) {
        return SetConceptTypeCommandFactory.createSetRelationTypeCommand(eClass, relation, false);
    }

    public static CompoundCommand createSetRelationTypeCommand(EClass eClass, Set<IArchimateRelationship> relations) {
        CompoundCommand compoundCommand = new CompoundCommand(Messages.SetConceptTypeCommandFactory_1);
        for (IArchimateRelationship relation : relations) {
            compoundCommand.add((Command)SetConceptTypeCommandFactory.createSetRelationTypeCommand(eClass, relation, false));
        }
        return compoundCommand.isEmpty() ? null : compoundCommand;
    }

    private static SetConceptTypeCommand createSetRelationTypeCommand(final EClass eClass, final IArchimateRelationship relation, final boolean doAddDocumentationNote) {
        if (relation.getArchimateModel() == null || eClass == relation.eClass() || !SetConceptTypeCommandFactory.isValidTypeForRelationship(eClass, relation)) {
            return null;
        }
        SetConceptTypeCommand compoundCmd = new SetConceptTypeCommand(){
            IArchimateRelationship newRelation;

            public void execute() {
                this.newRelation = (IArchimateRelationship)IArchimateFactory.eINSTANCE.create(eClass);
                this.newRelation.setName(relation.getName());
                Collection props = EcoreUtil.copyAll((Collection)relation.getProperties());
                this.newRelation.getProperties().addAll(props);
                Collection features = EcoreUtil.copyAll((Collection)relation.getFeatures());
                this.newRelation.getFeatures().addAll(features);
                String documentation = relation.getDocumentation();
                if (doAddDocumentationNote) {
                    this.newRelation.setDocumentation(NLS.bind((String)(Messages.SetConceptTypeCommandFactory_2 + (StringUtils.isSet(documentation) ? "\n\n" : "")), (Object)ArchiLabelProvider.INSTANCE.getDefaultName(relation.eClass())) + documentation);
                } else {
                    this.newRelation.setDocumentation(documentation);
                }
                this.add(new Command(){
                    IFolder parent;
                    {
                        this.parent = SetConceptTypeCommandFactory.getFolderForNewConcept((IArchimateConcept)iArchimateRelationship, (IArchimateConcept)var1_1.newRelation);
                    }

                    public void execute() {
                        newRelation.connect(relation.getSource(), relation.getTarget());
                        this.parent.getElements().add((Object)newRelation);
                    }

                    public void undo() {
                        newRelation.disconnect();
                        this.parent.getElements().remove((Object)newRelation);
                    }

                    public void redo() {
                        newRelation.reconnect();
                        this.parent.getElements().add((Object)newRelation);
                    }

                    public void dispose() {
                        this.parent = null;
                    }
                });
                this.add((Command)SetConceptTypeCommandFactory.createRelationshipEndsCommand((IArchimateConcept)relation, (IArchimateConcept)this.newRelation));
                for (IDiagramModel dm : relation.getArchimateModel().getDiagramModels()) {
                    for (final IDiagramModelArchimateConnection dmc : DiagramModelUtils.findDiagramModelConnectionsForRelation(dm, relation)) {
                        this.add(new Command(){

                            public void execute() {
                                dmc.disconnect();
                                dmc.setArchimateRelationship(newRelation);
                                dmc.reconnect();
                            }

                            public void undo() {
                                dmc.disconnect();
                                dmc.setArchimateRelationship(relation);
                                dmc.reconnect();
                            }
                        });
                    }
                }
                this.add(new Command(){

                    public void execute() {
                        relation.disconnect();
                    }

                    public void undo() {
                        relation.reconnect();
                    }
                });
                this.add(new RemoveListMemberCommand<IArchimateRelationship>((List<IArchimateRelationship>)((IFolder)relation.eContainer()).getElements(), relation));
                this.add(SetConceptTypeCommandFactory.changeInvalidRelations(eClass, (IArchimateConcept)this.newRelation, doAddDocumentationNote));
            }

            @Override
            public IArchimateConcept getNewConcept() {
                return this.newRelation;
            }

            public void dispose() {
                this.newRelation = null;
            }
        };
        return compoundCmd;
    }

    private static CompoundCommand createRelationshipEndsCommand(IArchimateConcept oldConcept, final IArchimateConcept newConcept) {
        CompoundCommand compoundCommand = new CompoundCommand();
        for (final IArchimateRelationship relation : oldConcept.getSourceRelationships()) {
            compoundCommand.add(new Command(){
                IArchimateConcept oldSource;
                {
                    this.oldSource = iArchimateRelationship.getSource();
                }

                public void execute() {
                    relation.setSource(newConcept);
                }

                public void undo() {
                    relation.setSource(this.oldSource);
                }

                public void dispose() {
                    this.oldSource = null;
                }
            });
        }
        for (final IArchimateRelationship relation : oldConcept.getTargetRelationships()) {
            compoundCommand.add(new Command(){
                IArchimateConcept oldTarget;
                {
                    this.oldTarget = iArchimateRelationship.getTarget();
                }

                public void execute() {
                    relation.setTarget(newConcept);
                }

                public void undo() {
                    relation.setTarget(this.oldTarget);
                }

                public void dispose() {
                    this.oldTarget = null;
                }
            });
        }
        return compoundCommand.isEmpty() ? null : compoundCommand;
    }

    public static boolean isValidTypeForElement(EClass eClass, IArchimateElement element, Set<IArchimateElement> elements) {
        for (IArchimateRelationship relation : element.getSourceRelationships()) {
            EClass targetType;
            EClass eClass2 = targetType = elements.contains(relation.getTarget()) ? eClass : relation.getTarget().eClass();
            if (ArchimateModelUtils.isValidRelationship((EClass)eClass, (EClass)targetType, (EClass)relation.eClass())) continue;
            return false;
        }
        for (IArchimateRelationship relation : element.getTargetRelationships()) {
            EClass sourceType;
            EClass eClass3 = sourceType = elements.contains(relation.getSource()) ? eClass : relation.getSource().eClass();
            if (ArchimateModelUtils.isValidRelationship((EClass)sourceType, (EClass)eClass, (EClass)relation.eClass())) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidTypeForRelationship(EClass eClass, IArchimateRelationship relationship) {
        if (!ArchimateModelUtils.isValidRelationship((IArchimateConcept)relationship.getSource(), (IArchimateConcept)relationship.getTarget(), (EClass)eClass)) {
            return false;
        }
        for (IArchimateRelationship relation : relationship.getSourceRelationships()) {
            if (ArchimateModelUtils.isValidRelationship((EClass)eClass, (EClass)relation.getTarget().eClass(), (EClass)relation.eClass())) continue;
            return false;
        }
        for (IArchimateRelationship relation : relationship.getTargetRelationships()) {
            if (ArchimateModelUtils.isValidRelationship((EClass)relation.getSource().eClass(), (EClass)eClass, (EClass)relation.eClass())) continue;
            return false;
        }
        return true;
    }

    private static Command changeInvalidRelations(EClass eClass, IArchimateConcept concept, boolean doAddDocumentationNote) {
        CompoundCommand compoundCmd = new CompoundCommand();
        HashSet<IArchimateRelationship> relations = new HashSet<IArchimateRelationship>();
        for (IArchimateRelationship relation : concept.getSourceRelationships()) {
            if (ArchimateModelUtils.isValidRelationship((EClass)eClass, (EClass)relation.getTarget().eClass(), (EClass)relation.eClass())) continue;
            relations.add(relation);
        }
        for (IArchimateRelationship relation : concept.getTargetRelationships()) {
            if (ArchimateModelUtils.isValidRelationship((EClass)relation.getSource().eClass(), (EClass)eClass, (EClass)relation.eClass())) continue;
            relations.add(relation);
        }
        for (IArchimateRelationship relation : relations) {
            compoundCmd.add((Command)SetConceptTypeCommandFactory.createSetRelationTypeCommand(IArchimatePackage.eINSTANCE.getAssociationRelationship(), relation, doAddDocumentationNote));
        }
        return compoundCmd.canExecute() ? compoundCmd : null;
    }

    private static IFolder getFolderForNewConcept(IArchimateConcept oldConcept, IArchimateConcept newConcept) {
        IFolder defaultFolder;
        block1: {
            EObject eObject;
            IFolder parent;
            IFolder existingFolder = (IFolder)oldConcept.eContainer();
            defaultFolder = oldConcept.getArchimateModel().getDefaultFolderForObject((EObject)newConcept);
            IArchimateConcept e = oldConcept;
            do {
                e = e.eContainer();
                eObject = e;
                if (!(e instanceof IFolder)) break block1;
            } while ((parent = (IFolder)eObject) != defaultFolder);
            return existingFolder;
        }
        return defaultFolder;
    }

    private static abstract class SetConceptTypeCommand
    extends AlwaysExecutingChainedCompoundCommand {
        private SetConceptTypeCommand() {
        }

        abstract IArchimateConcept getNewConcept();
    }
}

