/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.model.compatibility;

import com.archimatetool.editor.model.compatibility.CompatibilityHandlerException;
import com.archimatetool.editor.model.compatibility.ICompatibilityHandler;
import com.archimatetool.editor.model.compatibility.IncompatibleModelException;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IArchimateModel;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.ClassNotFoundException;
import org.eclipse.emf.ecore.xmi.FeatureNotFoundException;
import org.eclipse.emf.ecore.xmi.PackageNotFoundException;
import org.eclipse.emf.ecore.xmi.UnresolvedReferenceException;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.xml.sax.SAXParseException;

public class ModelCompatibility {
    private Resource fResource;

    public ModelCompatibility(Resource resource) {
        this.fResource = resource;
    }

    public void checkErrors() throws IncompatibleModelException {
        Object exceptionMessage = "";
        for (Resource.Diagnostic diagnostic : this.fResource.getErrors()) {
            if (!this.isCatastrophicException(diagnostic)) continue;
            exceptionMessage = (String)exceptionMessage + diagnostic.getMessage() + "\n";
        }
        if (((String)exceptionMessage).length() > 0) {
            throw new IncompatibleModelException((String)exceptionMessage);
        }
    }

    public boolean isLaterModelVersion(String presentVersion) {
        IArchimateModel model = (IArchimateModel)this.fResource.getContents().get(0);
        String version = model.getVersion();
        return version != null && StringUtils.compareVersionNumbers(version, presentVersion) > 0;
    }

    public List<Resource.Diagnostic> getAcceptableExceptions() {
        ArrayList<Resource.Diagnostic> list = new ArrayList<Resource.Diagnostic>();
        for (Resource.Diagnostic diagnostic : this.fResource.getErrors()) {
            if (!this.isFeatureNotFoundException(diagnostic)) continue;
            list.add(diagnostic);
        }
        return list;
    }

    protected boolean isFeatureNotFoundException(Resource.Diagnostic diagnostic) {
        return diagnostic instanceof FeatureNotFoundException;
    }

    protected boolean isCatastrophicException(Resource.Diagnostic diagnostic) {
        Resource.Diagnostic diagnostic2 = diagnostic;
        Objects.requireNonNull(diagnostic2);
        Resource.Diagnostic diagnostic3 = diagnostic2;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PackageNotFoundException.class, ClassNotFoundException.class, UnresolvedReferenceException.class, XMIException.class}, (Object)diagnostic3, 0)) {
            case 0 -> {
                PackageNotFoundException ex = (PackageNotFoundException)diagnostic3;
                yield true;
            }
            case 1 -> {
                ClassNotFoundException ex = (ClassNotFoundException)diagnostic3;
                yield true;
            }
            case 2 -> {
                UnresolvedReferenceException ex = (UnresolvedReferenceException)diagnostic3;
                yield true;
            }
            case 3 -> {
                XMIException ex = (XMIException)diagnostic3;
                yield ex.getCause() instanceof SAXParseException;
            }
            default -> false;
        };
    }

    public void fixCompatibility() throws CompatibilityHandlerException {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor("com.archimatetool.editor.compatibilityHandler");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                ICompatibilityHandler handler = (ICompatibilityHandler)configurationElement.createExecutableExtension("class");
                if (handler != null) {
                    handler.fixCompatibility(this.fResource);
                }
            }
            catch (CoreException ex) {
                ex.printStackTrace();
            }
            ++n2;
        }
    }
}

