/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.model.compatibility.handlers;

import com.archimatetool.editor.model.compatibility.CompatibilityHandlerException;
import com.archimatetool.editor.model.compatibility.ICompatibilityHandler;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.FolderType;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IFolder;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class Archimate2To3Handler
implements ICompatibilityHandler {
    @Override
    public void fixCompatibility(Resource resource) throws CompatibilityHandlerException {
        IArchimateModel model = (IArchimateModel)resource.getContents().get(0);
        if (!this.isArchimate2Model(model)) {
            return;
        }
        model.setDefaults();
        this.convertFolders(model);
        this.moveElements(model, model.getFolder(FolderType.BUSINESS));
    }

    public boolean isArchimate2Model(IArchimateModel model) {
        String version = model.getVersion();
        return version != null && StringUtils.compareVersionNumbers(version, "4.0.0") < 0;
    }

    private void convertFolders(IArchimateModel model) {
        for (IFolder folder : new ArrayList(model.getFolders())) {
            if ("Connectors".equals(folder.getName())) {
                this.convertConnectorsFolder(model, folder);
                continue;
            }
            if ("Technology".equals(folder.getName())) {
                this.convertTechnologyFolder(folder);
                continue;
            }
            if (!"Derived Relations".equals(folder.getName())) continue;
            this.convertDerivedFolder(model, folder);
        }
    }

    private void convertConnectorsFolder(IArchimateModel model, IFolder connectorsFolder) {
        IFolder otherFolder = model.getFolder(FolderType.OTHER);
        if (otherFolder != null) {
            for (EObject eObject : new ArrayList(connectorsFolder.eContents())) {
                otherFolder.getElements().add((Object)eObject);
            }
        }
        model.getFolders().remove((Object)connectorsFolder);
    }

    private void convertTechnologyFolder(IFolder technologyFolder) {
        technologyFolder.setName("Technology & Physical");
    }

    private void convertDerivedFolder(IArchimateModel model, IFolder derivedFolder) {
        IFolder relationsFolder = model.getFolder(FolderType.RELATIONS);
        if (relationsFolder != null) {
            for (EObject eObject : new ArrayList(derivedFolder.eContents())) {
                relationsFolder.getElements().add((Object)eObject);
            }
        }
        model.getFolders().remove((Object)derivedFolder);
    }

    private void moveElements(IArchimateModel model, IFolder folder) {
        if (folder != null) {
            for (EObject eObject : new ArrayList(folder.eContents())) {
                IFolder motivationFolder;
                IFolder otherFolder;
                if (eObject.eClass() == IArchimatePackage.eINSTANCE.getLocation() && (otherFolder = model.getFolder(FolderType.OTHER)) != null) {
                    otherFolder.getElements().add((Object)eObject);
                }
                if ((eObject.eClass() == IArchimatePackage.eINSTANCE.getMeaning() || eObject.eClass() == IArchimatePackage.eINSTANCE.getValue()) && (motivationFolder = model.getFolder(FolderType.MOTIVATION)) != null) {
                    motivationFolder.getElements().add((Object)eObject);
                }
                if (!(eObject instanceof IFolder)) continue;
                this.moveElements(model, (IFolder)eObject);
            }
        }
    }
}

