/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.model.compatibility.handlers;

import com.archimatetool.editor.model.compatibility.CompatibilityHandlerException;
import com.archimatetool.editor.model.compatibility.ICompatibilityHandler;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IDiagramModelGroup;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IGrouping;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class DefaultTextAlignmentHandler
implements ICompatibilityHandler {
    @Override
    public void fixCompatibility(Resource resource) throws CompatibilityHandlerException {
        IArchimateModel model = (IArchimateModel)resource.getContents().get(0);
        if (this.isVersion(model)) {
            this.convertTextPosition(model);
        }
    }

    public boolean isVersion(IArchimateModel model) {
        String version = model.getVersion();
        return version != null && StringUtils.compareVersionNumbers(version, "4.4.0") < 0;
    }

    private void convertTextPosition(IArchimateModel model) {
        TreeIterator iter = model.eAllContents();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if ((!(eObject instanceof IDiagramModelArchimateObject) || !(((IDiagramModelArchimateObject)eObject).getArchimateConcept() instanceof IGrouping)) && !(eObject instanceof IDiagramModelGroup) || ((IDiagramModelObject)eObject).getTextAlignment() != 2) continue;
            ((IDiagramModelObject)eObject).setTextAlignment(1);
        }
    }
}

