/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.model.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ByteArrayStorage {
    private Map<String, byte[]> fdataTable = new HashMap<String, byte[]>();

    InputStream getInputStream(String entryName) {
        byte[] bytes;
        if (entryName != null && (bytes = this.fdataTable.get(entryName)) != null) {
            return new ByteArrayInputStream(bytes);
        }
        return null;
    }

    String getKey(byte[] bytes) {
        for (Map.Entry<String, byte[]> entry : this.fdataTable.entrySet()) {
            byte[] entryBytes = entry.getValue();
            if (!Arrays.equals(bytes, entryBytes)) continue;
            return entry.getKey();
        }
        return null;
    }

    long getEntrySize(String entryName) {
        byte[] bytes;
        if (entryName != null && (bytes = this.fdataTable.get(entryName)) != null) {
            return bytes.length;
        }
        return -1L;
    }

    Set<Map.Entry<String, byte[]>> getEntrySet() {
        return Set.copyOf(this.fdataTable.entrySet());
    }

    Set<String> getEntryNames() {
        return Set.copyOf(this.fdataTable.keySet());
    }

    boolean hasEntries() {
        return !this.fdataTable.isEmpty();
    }

    boolean hasEntry(String entryName) {
        return this.fdataTable.containsKey(entryName);
    }

    void removeEntry(String entryName) {
        this.fdataTable.remove(entryName);
    }

    byte[] getEntry(String entryName) {
        return this.fdataTable.get(entryName);
    }

    void addFileContentEntry(String entryName, File file) throws IOException {
        this.addStreamEntry(entryName, new FileInputStream(file));
    }

    void addStreamEntry(String entryName, InputStream in) throws IOException {
        byte[] bytes = this.getBytesFromStream(in);
        this.addByteContentEntry(entryName, bytes);
    }

    void addByteContentEntry(String entryName, byte[] bytes) {
        String key = this.getKey(bytes);
        if (key != null) {
            this.fdataTable.put(entryName, this.getEntry(key));
        } else {
            this.fdataTable.put(entryName, bytes);
        }
    }

    byte[] getBytesFromFile(File file) throws IOException {
        if (file != null && file.exists()) {
            FileInputStream in = new FileInputStream(file);
            return this.getBytesFromStream(in);
        }
        return null;
    }

    void dispose() {
        this.fdataTable.clear();
        this.fdataTable = null;
    }

    private byte[] getBytesFromStream(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[8192];
        try {
            int size;
            while ((size = in.read(buf)) != -1) {
                out.write(buf, 0, size);
            }
        }
        finally {
            out.close();
            in.close();
        }
        return out.toByteArray();
    }
}

