/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.p2;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.Logger;
import com.archimatetool.editor.p2.Messages;
import com.archimatetool.editor.utils.FileUtils;
import com.archimatetool.editor.utils.PlatformUtils;
import com.archimatetool.editor.utils.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class DropinsPluginHandler {
    private Shell shell;
    private File userDropinsFolder;
    private File installationDropinsFolder;
    private File configurationDropinsFolder;
    private boolean success;
    static final int CONTINUE = 0;
    static final int RESTART = 1;
    static final String MAGIC_ENTRY = "archi-plugin";
    private static Set<File> filesToDelete;

    public List<Bundle> getInstalledPlugins() throws IOException {
        ArrayList<Bundle> list = new ArrayList<Bundle>();
        Bundle[] bundleArray = ArchiPlugin.getInstance().getBundle().getBundleContext().getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            File file = this.getDropinsBundleFile(bundle);
            if (file != null) {
                list.add(bundle);
            }
            ++n2;
        }
        return list;
    }

    public int install(Shell shell) throws IOException {
        this.shell = shell;
        if (!this.checkCanWriteToFolder(this.getUserInstallationDropinsFolder())) {
            return this.status();
        }
        final List<File> files = this.askOpenFiles();
        if (files.isEmpty()) {
            return this.status();
        }
        final ArrayList stats = new ArrayList();
        final Exception[] exception = new Exception[1];
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                for (File file : files) {
                    try {
                        IStatus status = DropinsPluginHandler.this.installFile(file);
                        stats.add(status);
                    }
                    catch (IOException ex) {
                        exception[0] = ex;
                    }
                }
            }
        });
        if (exception[0] != null) {
            this.displayErrorDialog(exception[0].getMessage());
            return this.status();
        }
        Object resultMessage = "";
        boolean hasError = false;
        int i = 0;
        while (i < stats.size()) {
            IStatus status = (IStatus)stats.get(i);
            if (status.isOK()) {
                this.success = true;
                resultMessage = (String)resultMessage + NLS.bind((String)(Messages.DropinsPluginHandler_2 + "\n"), (Object)files.get(i).getName());
            } else {
                hasError = true;
                resultMessage = status.getCode() == 666 ? (String)resultMessage + NLS.bind((String)(Messages.DropinsPluginHandler_3 + "\n"), (Object)files.get(i).getName()) : (String)resultMessage + NLS.bind((String)(Messages.DropinsPluginHandler_4 + "\n"), (Object)files.get(i).getName());
            }
            ++i;
        }
        if (hasError) {
            MessageDialog.openInformation((Shell)shell, (String)Messages.DropinsPluginHandler_5, (String)resultMessage);
        }
        return this.status();
    }

    private IStatus installFile(File zipFile) throws IOException {
        if (!this.isPluginZipFile(zipFile)) {
            return new Status(4, "com.archimatetool.editor", 666, NLS.bind((String)Messages.DropinsPluginHandler_6, (Object)zipFile.getAbsolutePath()), null);
        }
        Path tmp = Files.createTempDirectory("archi", new FileAttribute[0]);
        File tmpFolder = tmp.toFile();
        try {
            ZipUtils.unpackZip(zipFile, tmpFolder);
            File pluginsFolder = this.getUserInstallationDropinsFolder();
            pluginsFolder.mkdirs();
            File[] fileArray = tmpFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (MAGIC_ENTRY.equalsIgnoreCase(file.getName())) {
                    this.handleMagicFile(file, pluginsFolder);
                } else {
                    this.deleteOlderPluginOnExit(file, pluginsFolder);
                    if (file.isDirectory()) {
                        FileUtils.copyFolder(file, new File(pluginsFolder, file.getName()));
                    } else {
                        FileUtils.copyFile(file, new File(pluginsFolder, file.getName()), false);
                    }
                }
                ++n2;
            }
        }
        finally {
            FileUtils.deleteFolder(tmpFolder);
        }
        return new Status(0, "com.archimatetool.editor", 777, NLS.bind((String)Messages.DropinsPluginHandler_0, (Object)zipFile.getPath()), null);
    }

    public int uninstall(Shell shell, List<Bundle> selected) throws IOException {
        if (selected.isEmpty()) {
            return this.status();
        }
        boolean ok = MessageDialog.openQuestion((Shell)shell, (String)Messages.DropinsPluginHandler_7, (String)Messages.DropinsPluginHandler_8);
        if (!ok) {
            return this.status();
        }
        for (Bundle bundle : selected) {
            File file = this.getDropinsBundleFile(bundle);
            if (file != null) {
                this.addFileToDeleteOnExit(file);
                continue;
            }
            Logger.logError(NLS.bind((String)Messages.DropinsPluginHandler_1, (Object)bundle.getLocation()));
        }
        this.success = true;
        return this.status();
    }

    private int status() {
        if (this.success) {
            return 1;
        }
        return 0;
    }

    private void handleMagicFile(File magicFile, File pluginsFolder) throws IOException {
        for (String line : Files.readAllLines(magicFile.toPath())) {
            if (!line.startsWith("delete:")) continue;
            String pluginName = line.substring(7).strip();
            File[] fileArray = pluginsFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File pluginFile = fileArray[n2];
                String targetPluginName = this.getPluginName(pluginFile.getName());
                if (targetPluginName.equals(pluginName)) {
                    this.addFileToDeleteOnExit(pluginFile);
                }
                ++n2;
            }
        }
    }

    private void deleteOlderPluginOnExit(File newPlugin, File pluginsFolder) {
        File[] fileArray = this.findMatchingPlugins(pluginsFolder, newPlugin);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            this.addFileToDeleteOnExit(file);
            ++n2;
        }
    }

    private File[] findMatchingPlugins(File pluginsFolder, File newPlugin) {
        String pluginName = this.getPluginName(newPlugin.getName());
        return pluginsFolder.listFiles(file2 -> {
            String targetPluginName = this.getPluginName(file2.getName());
            return targetPluginName.equals(pluginName) && !newPlugin.getName().equals(file2.getName());
        });
    }

    String getPluginName(String string) {
        int index = string.indexOf("_");
        if (index != -1) {
            string = string.substring(0, index);
        }
        return string;
    }

    String getPluginVersion(String string) {
        int index = string.lastIndexOf(".jar");
        if (index != -1) {
            string = string.substring(0, index);
        }
        if ((index = string.lastIndexOf("_")) != -1) {
            string = string.substring(index + 1);
        }
        return string;
    }

    private boolean checkCanWriteToFolder(File folder) {
        folder.mkdirs();
        if (!Files.isWritable(folder.toPath())) {
            String message = Messages.DropinsPluginHandler_9 + " ";
            message = PlatformUtils.isWindows() ? message + Messages.DropinsPluginHandler_10 : message + Messages.DropinsPluginHandler_11;
            this.displayErrorDialog(message);
            return false;
        }
        return true;
    }

    boolean isPluginZipFile(File file) throws IOException {
        return ZipUtils.isZipFile(file) && ZipUtils.hasZipEntry(file, MAGIC_ENTRY);
    }

    private File getUserInstallationDropinsFolder() throws IOException {
        File dropinsFolder = this.getUserDropinsFolder();
        if (dropinsFolder == null) {
            dropinsFolder = this.getConfigurationLocationDropinsFolder();
        }
        return dropinsFolder;
    }

    private File getUserDropinsFolder() throws IOException {
        if (this.userDropinsFolder == null) {
            this.userDropinsFolder = ArchiPlugin.getInstance().getUserDropinsFolder();
            if (this.userDropinsFolder != null) {
                this.userDropinsFolder = this.userDropinsFolder.getCanonicalFile();
            }
        }
        return this.userDropinsFolder;
    }

    private File getConfigurationLocationDropinsFolder() throws IOException {
        if (this.configurationDropinsFolder == null) {
            URL url = Platform.getConfigurationLocation().getURL();
            url = FileLocator.resolve((URL)url);
            File parentFolder = new File(url.getPath()).getParentFile();
            this.configurationDropinsFolder = new File(parentFolder, "dropins");
        }
        return this.configurationDropinsFolder;
    }

    private File getInstallLocationDropinsFolder() throws IOException {
        if (this.installationDropinsFolder == null) {
            URL url = Platform.getInstallLocation().getURL();
            url = FileLocator.resolve((URL)url);
            this.installationDropinsFolder = new File(url.getPath(), "dropins");
        }
        return this.installationDropinsFolder;
    }

    File getDropinsBundleFile(Bundle bundle) throws IOException {
        File bundleFile = (File)FileLocator.getBundleFileLocation((Bundle)bundle).orElseThrow(() -> new IOException("Unable to locate the bundle file: " + String.valueOf(bundle)));
        File parentFolder = (bundleFile = bundleFile.getCanonicalFile()).getParentFile();
        return parentFolder.equals(this.getUserDropinsFolder()) || parentFolder.equals(this.getConfigurationLocationDropinsFolder()) || parentFolder.equals(this.getInstallLocationDropinsFolder()) ? bundleFile : null;
    }

    private List<File> askOpenFiles() {
        FileDialog dialog = new FileDialog(this.shell, 4098);
        dialog.setFilterExtensions(new String[]{"*.archiplugin", "*.zip", "*.*"});
        String path = dialog.open();
        ArrayList<File> files = new ArrayList<File>();
        if (path != null) {
            String filterPath = dialog.getFilterPath() + File.separator;
            String[] stringArray = dialog.getFileNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                File file = new File(filterPath, name);
                if (file.exists()) {
                    files.add(file);
                }
                ++n2;
            }
        }
        return files;
    }

    private void displayErrorDialog(String message) {
        MessageDialog.openError((Shell)this.shell, (String)Messages.DropinsPluginHandler_12, (String)message);
    }

    private void addFileToDeleteOnExit(File file) {
        if (filesToDelete == null) {
            filesToDelete = new HashSet<File>();
            if (PlatformUtils.isMac() && PlatformUI.isWorkbenchRunning()) {
                PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

                    public boolean preShutdown(IWorkbench workbench, boolean forced) {
                        return true;
                    }

                    public void postShutdown(IWorkbench workbench) {
                        DropinsPluginHandler.this.deleteFiles();
                    }
                });
            } else {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> this.deleteFiles()));
            }
        }
        filesToDelete.add(file);
    }

    private void deleteFiles() {
        try {
            for (File file : filesToDelete) {
                if (file.isDirectory()) {
                    this.recursiveDelete(file);
                    continue;
                }
                file.delete();
            }
        }
        catch (Exception ex) {
            Logger.logError("Error deleting file", ex);
        }
    }

    private void recursiveDelete(File file) throws IOException {
        Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc != null) {
                    throw exc;
                }
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

