/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.p2;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.p2.P2;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.garbagecollector.GarbageCollector;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.query.UserVisibleRootQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UninstallOperation;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class P2Handler {
    private ProvisioningSession provisioningSession;
    private IProvisioningAgent provisioningAgent;
    private IMetadataRepositoryManager metadataRepositoryManager;
    private IArtifactRepositoryManager artifactRepositoryManager;
    private static P2Handler instance;

    public static P2Handler getInstance() {
        if (instance == null) {
            instance = new P2Handler();
        }
        return instance;
    }

    private P2Handler() {
    }

    public IStatus install(URI uri, IProgressMonitor monitor) throws ProvisionException {
        this.loadRepository(uri, monitor);
        Set<IInstallableUnit> toInstall = this.getGroupInstallableUnits(uri, monitor);
        InstallOperation operation = new InstallOperation(this.getProvisioningSession(), toInstall);
        return this.performOperation((ProfileChangeOperation)operation, monitor);
    }

    public IStatus update(URI uri, IProgressMonitor monitor) throws ProvisionException {
        this.loadRepository(uri, monitor);
        UpdateOperation operation = new UpdateOperation(this.getProvisioningSession());
        return this.performOperation((ProfileChangeOperation)operation, monitor);
    }

    public IStatus uninstall(Collection<IInstallableUnit> toUninstall, IProgressMonitor monitor) throws ProvisionException {
        UninstallOperation operation = new UninstallOperation(this.getProvisioningSession(), toUninstall);
        return this.performOperation((ProfileChangeOperation)operation, monitor);
    }

    public void garbageCollect() throws ProvisionException {
        IProfile profile = this.getDefaultProfile();
        GarbageCollector gc = (GarbageCollector)this.getProvisioningAgent().getService(GarbageCollector.SERVICE_NAME);
        gc.runGC(profile);
    }

    public void cleanProfileRegistry() throws ProvisionException {
        File p2Folder = P2.getP2Location();
        if (p2Folder == null) {
            return;
        }
        IProfile profile = this.getDefaultProfile();
        File profileFolder = new File(p2Folder, "org.eclipse.equinox.p2.engine/profileRegistry/" + profile.getProfileId() + ".profile");
        long[] lArray = this.getProfileRegistry().listProfileTimestamps(profile.getProfileId());
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long ts = lArray[n2];
            if (ts < profile.getTimestamp()) {
                File file = new File(profileFolder, ts + ".profile.gz");
                file.delete();
            }
            ++n2;
        }
    }

    public boolean isInstalled(URI uri, IProgressMonitor monitor) throws ProvisionException, OperationCanceledException {
        for (IInstallableUnit iu : this.getInstalledFeatures()) {
            IQueryResult<IInstallableUnit> result = this.queryRepositoryForInstallableUnit(uri, iu.getId(), monitor);
            if (result.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public List<IInstallableUnit> getInstalledFeatures() throws ProvisionException {
        ArrayList<IInstallableUnit> list = new ArrayList<IInstallableUnit>();
        IProfile profile = this.getDefaultProfile();
        IQuery query = QueryUtil.createIUGroupQuery();
        IQueryResult queryResult = profile.query(query, null);
        for (IInstallableUnit iu : queryResult) {
            if (!UserVisibleRootQuery.isUserVisible((IInstallableUnit)iu, (IProfile)profile) || iu.getProperty("org.eclipse.equinox.p2.type.product") != null) continue;
            list.add(iu);
        }
        return list;
    }

    private Set<IInstallableUnit> getGroupInstallableUnits(URI uri, IProgressMonitor monitor) throws ProvisionException, OperationCanceledException {
        IMetadataRepository metadataRepo = this.getMetadataRepositoryManager().loadRepository(uri, monitor);
        IQuery query = QueryUtil.createIUGroupQuery();
        IQueryResult queryResult = metadataRepo.query(query, monitor);
        return queryResult.toUnmodifiableSet();
    }

    private void addRepository(URI uri) throws ProvisionException {
        this.getMetadataRepositoryManager().addRepository(uri);
        this.getArtifactRepositoryManager().addRepository(uri);
    }

    private void loadRepository(URI uri, IProgressMonitor monitor) throws ProvisionException {
        this.getMetadataRepositoryManager().loadRepository(uri, monitor);
        this.getArtifactRepositoryManager().loadRepository(uri, monitor);
    }

    private IStatus performOperation(ProfileChangeOperation operation, IProgressMonitor monitor) {
        IStatus status = operation.resolveModal(monitor);
        if (status.isOK()) {
            ProvisioningJob provisioningJob = operation.getProvisioningJob(monitor);
            if (provisioningJob == null) {
                System.err.println("Trying to install from the Eclipse IDE? This won't work!");
                return Status.CANCEL_STATUS;
            }
            status = provisioningJob.runModal(monitor);
        }
        if (!status.isOK()) {
            ArchiPlugin.getInstance().getLog().log(status);
        }
        return status;
    }

    private IProvisioningAgent getProvisioningAgent() throws ProvisionException {
        if (this.provisioningAgent == null) {
            BundleContext bundleContext = FrameworkUtil.getBundle(IProvisioningAgent.class).getBundleContext();
            ServiceReference sr = bundleContext.getServiceReference(IProvisioningAgentProvider.SERVICE_NAME);
            IProvisioningAgentProvider agentProvider = (IProvisioningAgentProvider)bundleContext.getService(sr);
            this.provisioningAgent = agentProvider.createAgent(null);
        }
        return this.provisioningAgent;
    }

    private ProvisioningSession getProvisioningSession() throws ProvisionException {
        if (this.provisioningSession == null) {
            this.provisioningSession = new ProvisioningSession(this.getProvisioningAgent());
        }
        return this.provisioningSession;
    }

    private IQueryResult<IInstallableUnit> queryRepositoryForInstallableUnit(URI uri, String installableUnitID, IProgressMonitor monitor) throws ProvisionException, OperationCanceledException {
        IMetadataRepository metadataRepository = this.getMetadataRepositoryManager().loadRepository(uri, monitor);
        if (metadataRepository != null) {
            return metadataRepository.query(QueryUtil.createIUQuery((String)installableUnitID), monitor);
        }
        return null;
    }

    private IMetadataRepositoryManager getMetadataRepositoryManager() throws ProvisionException {
        if (this.metadataRepositoryManager == null) {
            this.metadataRepositoryManager = (IMetadataRepositoryManager)this.getProvisioningAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        }
        return this.metadataRepositoryManager;
    }

    private IArtifactRepositoryManager getArtifactRepositoryManager() throws ProvisionException {
        if (this.artifactRepositoryManager == null) {
            this.artifactRepositoryManager = (IArtifactRepositoryManager)this.getProvisioningAgent().getService(IArtifactRepositoryManager.SERVICE_NAME);
        }
        return this.artifactRepositoryManager;
    }

    private IProfileRegistry getProfileRegistry() throws ProvisionException {
        return (IProfileRegistry)this.getProvisioningAgent().getService(IProfileRegistry.SERVICE_NAME);
    }

    private IProfile getDefaultProfile() throws ProvisionException {
        IProfileRegistry registry = this.getProfileRegistry();
        IProfile profile = registry.getProfile("_SELF_");
        if (profile == null) {
            throw new ProvisionException("Unable to access p2 profile - This is not possible when starting the application from the IDE!");
        }
        return profile;
    }
}

