/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.preferences;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.preferences.IPreferenceConstants;
import com.archimatetool.editor.preferences.Messages;
import com.archimatetool.editor.preferences.PrefUtils;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.ThemeUtils;
import com.archimatetool.editor.ui.components.CustomColorDialog;
import com.archimatetool.editor.ui.factory.model.FolderUIProvider;
import com.archimatetool.editor.utils.PlatformUtils;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.FolderType;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.util.ArchimateModelUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ColoursPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IPreferenceConstants {
    public static String ID = "com.archimatetool.editor.prefsColours";
    public static String HELPID = "com.archimatetool.help.prefsAppearance";
    private Map<Object, Color> fColorsCache = new HashMap<Object, Color>();
    private ImageRegistry fImageRegistry;
    private Button fPersistUserDefaultColors;
    private Button fEditFillColorButton;
    private Button fResetFillColorButton;
    private Button fDeriveElementLineColorsButton;
    private TreeViewer fTreeViewer;
    private IPropertyChangeListener themeChangeListener;
    private static List<String> themeColors = List.of("com.archimatetool.editor.VIEW_BACKGROUND", "com.archimatetool.editor.VISUALISER_BACKGROUND");

    public ColoursPreferencePage() {
        this.setPreferenceStore(ArchiPlugin.getInstance().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELPID);
        this.resetColorsCache(false);
        this.fImageRegistry = new ImageRegistry();
        Composite client = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(client);
        Label label = new Label(client, 0);
        label.setText(Messages.ColoursPreferencePage_0);
        GridDataFactory.create((int)768).span(2, 1).applyTo((Control)label);
        this.fTreeViewer = new TreeViewer(client);
        GridDataFactory.create((int)1808).hint(-1, 200).applyTo((Control)this.fTreeViewer.getTree());
        this.fTreeViewer.addDoubleClickListener(event -> {
            RGB newRGB;
            Object[] selected = this.fTreeViewer.getStructuredSelection().toArray();
            if (this.isValidTreeSelection(selected) && (newRGB = this.openColorDialog(selected[0])) != null) {
                Object[] objectArray = selected;
                int n = selected.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    this.setColor(object, newRGB);
                    ++n2;
                }
            }
        });
        this.fTreeViewer.addSelectionChangedListener(event -> {
            Object[] selected = event.getStructuredSelection().toArray();
            this.fEditFillColorButton.setEnabled(this.isValidTreeSelection(selected));
            this.fResetFillColorButton.setEnabled(this.isValidTreeSelection(selected));
        });
        this.fTreeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return new Object[]{new TreeGrouping(Messages.ColoursPreferencePage_1, ArchimateModelUtils.getStrategyClasses()), new TreeGrouping(Messages.ColoursPreferencePage_2, ArchimateModelUtils.getBusinessClasses()), new TreeGrouping(Messages.ColoursPreferencePage_3, ArchimateModelUtils.getApplicationClasses()), new TreeGrouping(Messages.ColoursPreferencePage_4, ArchimateModelUtils.getTechnologyClasses()), new TreeGrouping(Messages.ColoursPreferencePage_5, ArchimateModelUtils.getPhysicalClasses()), new TreeGrouping(Messages.ColoursPreferencePage_6, ArchimateModelUtils.getMotivationClasses()), new TreeGrouping(Messages.ColoursPreferencePage_7, ArchimateModelUtils.getImplementationMigrationClasses()), new TreeGrouping(Messages.ColoursPreferencePage_8, ArchimateModelUtils.getOtherClasses()), new TreeGrouping(Messages.ColoursPreferencePage_9, new Object[]{IArchimatePackage.eINSTANCE.getDiagramModelNote(), IArchimatePackage.eINSTANCE.getDiagramModelGroup()}), new TreeGrouping(Messages.ColoursPreferencePage_10, new FolderType[]{FolderType.STRATEGY, FolderType.BUSINESS, FolderType.APPLICATION, FolderType.TECHNOLOGY, FolderType.MOTIVATION, FolderType.IMPLEMENTATION_MIGRATION, FolderType.OTHER, FolderType.RELATIONS, FolderType.DIAGRAMS}), new TreeGrouping(Messages.ColoursPreferencePage_25, themeColors.toArray()), "defaultElementLineColor", "defaultConnectionLineColor"};
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof TreeGrouping) {
                    TreeGrouping grouping = (TreeGrouping)parentElement;
                    return grouping.children;
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return element instanceof TreeGrouping;
            }
        });
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                block14: {
                    if (element instanceof EClass) {
                        EClass eClass = (EClass)element;
                        return ArchiLabelProvider.INSTANCE.getDefaultName(eClass);
                    }
                    if (element instanceof TreeGrouping) {
                        TreeGrouping grouping = (TreeGrouping)element;
                        return grouping.title;
                    }
                    if (!(element instanceof String)) break block14;
                    String s = (String)element;
                    if (themeColors.contains(s)) {
                        return ThemeUtils.getColorDefinitionName(s);
                    }
                    switch (s) {
                        case "defaultElementLineColor": {
                            return Messages.ColoursPreferencePage_11;
                        }
                        case "defaultConnectionLineColor": {
                            return Messages.ColoursPreferencePage_12;
                        }
                    }
                    return s;
                }
                if (element instanceof FolderType) {
                    FolderType folderType = (FolderType)element;
                    return folderType.getLabel();
                }
                return null;
            }

            public Image getImage(Object element) {
                if (element == null) {
                    return null;
                }
                if (element instanceof TreeGrouping) {
                    return IArchiImages.ImageFactory.getImage("img/folder-default.png");
                }
                String key = ColoursPreferencePage.this.getColorKey(element);
                Image image = ColoursPreferencePage.this.fImageRegistry.get(key);
                if (image == null) {
                    image = new Image((Device)ColoursPreferencePage.this.getShell().getDisplay(), zoom -> {
                        Image tmp = new Image((Device)ColoursPreferencePage.this.getShell().getDisplay(), 16, 16);
                        GC gc = new GC((Drawable)tmp);
                        Color color = ColoursPreferencePage.this.fColorsCache.get(element);
                        if (color != null) {
                            gc.setBackground(color);
                        }
                        gc.fillRectangle(0, 0, 15, 15);
                        gc.drawRectangle(0, 0, 15, 15);
                        gc.dispose();
                        ImageData imageData = tmp.getImageData(zoom);
                        tmp.dispose();
                        return imageData;
                    });
                    ColoursPreferencePage.this.fImageRegistry.put(key, image);
                }
                return image;
            }
        });
        Composite buttonClient = new Composite(client, 0);
        GridData gd = new GridData(128, 128, false, false);
        buttonClient.setLayoutData((Object)gd);
        buttonClient.setLayout((Layout)new GridLayout());
        this.fEditFillColorButton = new Button(buttonClient, 8);
        this.fEditFillColorButton.setText(Messages.ColoursPreferencePage_13);
        this.setButtonLayoutData(this.fEditFillColorButton);
        this.fEditFillColorButton.setEnabled(false);
        this.fEditFillColorButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            RGB newRGB;
            Object[] selected = this.fTreeViewer.getStructuredSelection().toArray();
            if (this.isValidTreeSelection(selected) && (newRGB = this.openColorDialog(selected[0])) != null) {
                Object[] objectArray = selected;
                int n = selected.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    this.setColor(object, newRGB);
                    ++n2;
                }
            }
        }));
        this.fResetFillColorButton = new Button(buttonClient, 8);
        this.fResetFillColorButton.setText(Messages.ColoursPreferencePage_14);
        this.setButtonLayoutData(this.fResetFillColorButton);
        this.fResetFillColorButton.setEnabled(false);
        this.fResetFillColorButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            Object[] selected = ((IStructuredSelection)this.fTreeViewer.getSelection()).toArray();
            if (this.isValidTreeSelection(selected)) {
                Object[] objectArray = selected;
                int n = selected.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    this.resetColorToInbuiltDefault(object);
                    ++n2;
                }
            }
        }));
        Button importButton = new Button(buttonClient, 8);
        importButton.setText(Messages.ColoursPreferencePage_15);
        this.setButtonLayoutData(importButton);
        importButton.setLayoutData((Object)new GridData(768));
        importButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            try {
                this.importUserColors();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }));
        Button exportButton = new Button(buttonClient, 8);
        exportButton.setText(Messages.ColoursPreferencePage_16);
        this.setButtonLayoutData(exportButton);
        exportButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            try {
                this.exportUserColors();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }));
        this.fDeriveElementLineColorsButton = new Button(client, 32);
        this.fDeriveElementLineColorsButton.setText(Messages.ColoursPreferencePage_18);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fDeriveElementLineColorsButton.setLayoutData((Object)gd);
        this.fDeriveElementLineColorsButton.setSelection(this.getPreferenceStore().getBoolean("deriveElementLineColor"));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fPersistUserDefaultColors = new Button(client, 32);
        this.fPersistUserDefaultColors.setText(Messages.ColoursPreferencePage_21);
        this.fPersistUserDefaultColors.setLayoutData((Object)gd);
        this.fPersistUserDefaultColors.setSelection(this.getPreferenceStore().getBoolean("saveUserDefaultFillColorInFile"));
        this.fTreeViewer.setInput((Object)"");
        return client;
    }

    private String getColorKey(Object object) {
        if (object instanceof String) {
            String s = (String)object;
            return s;
        }
        if (object instanceof EClass) {
            EClass eClass = (EClass)object;
            return eClass.getName();
        }
        if (object instanceof FolderType) {
            FolderType folderType = (FolderType)object;
            return folderType.getName();
        }
        return "x";
    }

    private RGB openColorDialog(Object object) {
        CustomColorDialog colorDialog = new CustomColorDialog(this.getShell());
        colorDialog.setRGB(this.fColorsCache.get(object).getRGB());
        return colorDialog.open();
    }

    private boolean isValidTreeSelection(Object[] selected) {
        if (selected == null || selected.length == 0) {
            return false;
        }
        Object[] objectArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof TreeGrouping) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void resetColorToInbuiltDefault(Object object) {
        RGB defaultRGB = null;
        if (object.equals("defaultElementLineColor")) {
            defaultRGB = ColorFactory.getInbuiltDefaultLineColor(IArchimatePackage.eINSTANCE.getBusinessActor()).getRGB();
        } else if (object.equals("defaultConnectionLineColor")) {
            defaultRGB = ColorFactory.getInbuiltDefaultLineColor(IArchimatePackage.eINSTANCE.getDiagramModelConnection()).getRGB();
        } else if (object instanceof EClass) {
            EClass eClass = (EClass)object;
            defaultRGB = ColorFactory.getInbuiltDefaultFillColor(eClass).getRGB();
        } else if (object instanceof FolderType) {
            FolderType folderType = (FolderType)object;
            defaultRGB = FolderUIProvider.getDefaultFolderColor(folderType).getRGB();
        } else if (object instanceof String) {
            String s = (String)object;
            if (themeColors.contains(object)) {
                defaultRGB = ThemeUtils.getDefaultThemeColor(s);
            }
        }
        this.setColor(object, defaultRGB);
    }

    private void setColor(Object object, RGB rgb) {
        if (object == null || rgb == null) {
            return;
        }
        this.fColorsCache.put(object, new Color(rgb));
        this.fImageRegistry.remove(this.getColorKey(object));
        this.fTreeViewer.update(object, null);
    }

    private void resetColorsCache(boolean useInbuiltDefaults) {
        Color color;
        EClass eClass;
        this.fColorsCache.clear();
        EClass[] eClassArray = ArchimateModelUtils.getAllArchimateClasses();
        int n = eClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            Color color2;
            eClass = eClassArray[n2];
            Color color3 = color2 = useInbuiltDefaults ? ColorFactory.getInbuiltDefaultFillColor(eClass) : ColorFactory.getDefaultFillColor(eClass);
            if (color2 != null) {
                this.fColorsCache.put(eClass, new Color(color2.getRGB()));
            }
            ++n2;
        }
        eClass = IArchimatePackage.eINSTANCE.getDiagramModelNote();
        Color color4 = color = useInbuiltDefaults ? ColorFactory.getInbuiltDefaultFillColor(eClass) : ColorFactory.getDefaultFillColor(eClass);
        if (color != null) {
            this.fColorsCache.put(eClass, new Color(color.getRGB()));
        }
        eClass = IArchimatePackage.eINSTANCE.getDiagramModelGroup();
        Color color5 = color = useInbuiltDefaults ? ColorFactory.getInbuiltDefaultFillColor(eClass) : ColorFactory.getDefaultFillColor(eClass);
        if (color != null) {
            this.fColorsCache.put(eClass, new Color(color.getRGB()));
        }
        eClass = IArchimatePackage.eINSTANCE.getBusinessActor();
        Color color6 = color = useInbuiltDefaults ? ColorFactory.getInbuiltDefaultLineColor(eClass) : ColorFactory.getDefaultLineColor(eClass);
        if (color != null) {
            this.fColorsCache.put("defaultElementLineColor", new Color(color.getRGB()));
        }
        eClass = IArchimatePackage.eINSTANCE.getDiagramModelConnection();
        Color color7 = color = useInbuiltDefaults ? ColorFactory.getInbuiltDefaultLineColor(eClass) : ColorFactory.getDefaultLineColor(eClass);
        if (color != null) {
            this.fColorsCache.put("defaultConnectionLineColor", new Color(color.getRGB()));
        }
        for (FolderType folderType : FolderType.VALUES) {
            if (folderType == FolderType.USER) continue;
            Color color8 = color = useInbuiltDefaults ? FolderUIProvider.getDefaultFolderColor(folderType) : FolderUIProvider.getFolderColor(folderType);
            if (color == null) continue;
            this.fColorsCache.put(folderType, new Color(color.getRGB()));
        }
        for (String colorId : themeColors) {
            RGB rgb;
            RGB rGB = rgb = useInbuiltDefaults ? ThemeUtils.getDefaultThemeColor(colorId) : ThemeUtils.getCurrentThemeColor(colorId);
            if (rgb == null) continue;
            this.fColorsCache.put(colorId, new Color(rgb));
        }
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("deriveElementLineColor", this.fDeriveElementLineColorsButton.getSelection());
        this.getPreferenceStore().setValue("saveUserDefaultFillColorInFile", this.fPersistUserDefaultColors.getSelection());
        this.saveColors(this.getPreferenceStore(), true);
        this.saveThemeColors();
        return true;
    }

    protected void performDefaults() {
        this.fDeriveElementLineColorsButton.setSelection(this.getPreferenceStore().getDefaultBoolean("deriveElementLineColor"));
        this.fPersistUserDefaultColors.setSelection(this.getPreferenceStore().getDefaultBoolean("saveUserDefaultFillColorInFile"));
        this.resetColorsCache(true);
        this.fImageRegistry.dispose();
        this.fImageRegistry = new ImageRegistry();
        for (Map.Entry<Object, Color> entry : this.fColorsCache.entrySet()) {
            this.fTreeViewer.update(entry.getKey(), null);
        }
        super.performDefaults();
    }

    private void importUserColors() throws IOException {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText(Messages.ColoursPreferencePage_22);
        if (!PlatformUtils.isMac()) {
            dialog.setFilterExtensions(new String[]{"ArchiColours.prefs", "*.prefs", "*.*"});
            dialog.setFileName("ArchiColours.prefs");
        } else {
            dialog.setFilterExtensions(new String[]{"*.prefs", "*.*"});
        }
        String path = dialog.open();
        if (path == null) {
            return;
        }
        PreferenceStore store = new PreferenceStore(path);
        store.load();
        for (Map.Entry<Object, Color> entry : this.fColorsCache.entrySet()) {
            String key = "defaultFillColour_" + this.getColorKey(entry.getKey());
            String value = store.getString(key);
            if (StringUtils.isSet(value)) {
                this.setColor(entry.getKey(), ColorFactory.convertStringToRGB(value));
            }
            if (!StringUtils.isSet(value = store.getString(key = "folderColour_" + this.getColorKey(entry.getKey())))) continue;
            this.setColor(entry.getKey(), ColorFactory.convertStringToRGB(value));
        }
        String key = "defaultElementLineColor";
        String value = store.getString(key);
        if (StringUtils.isSet(value)) {
            this.setColor(key, ColorFactory.convertStringToRGB(value));
        }
        if (StringUtils.isSet(value = store.getString(key = "defaultConnectionLineColor"))) {
            this.setColor(key, ColorFactory.convertStringToRGB(value));
        }
    }

    private void exportUserColors() throws IOException {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(Messages.ColoursPreferencePage_23);
        dialog.setFileName("ArchiColours.prefs");
        dialog.setOverwrite(true);
        String path = dialog.open();
        if (path == null) {
            return;
        }
        PreferenceStore store = new PreferenceStore(path);
        this.saveColors((IPreferenceStore)store, false);
        store.save();
    }

    private void saveColors(IPreferenceStore store, boolean useDefaults) {
        for (Map.Entry<Object, Color> entry : this.fColorsCache.entrySet()) {
            Color colorNew = entry.getValue();
            Color colorDefault = null;
            Object key = null;
            if (entry.getKey().equals("defaultElementLineColor")) {
                colorDefault = ColorFactory.getInbuiltDefaultLineColor(IArchimatePackage.eINSTANCE.getBusinessActor());
                key = "defaultElementLineColor";
            } else if (entry.getKey().equals("defaultConnectionLineColor")) {
                colorDefault = ColorFactory.getInbuiltDefaultLineColor(IArchimatePackage.eINSTANCE.getDiagramModelConnection());
                key = "defaultConnectionLineColor";
            } else if (entry.getKey() instanceof FolderType) {
                colorDefault = FolderUIProvider.getDefaultFolderColor((FolderType)entry.getKey());
                key = "folderColour_" + this.getColorKey(entry.getKey());
            } else if (entry.getKey() instanceof EClass) {
                colorDefault = ColorFactory.getInbuiltDefaultFillColor(entry.getKey());
                key = "defaultFillColour_" + this.getColorKey(entry.getKey());
            }
            if (key == null) continue;
            if (useDefaults && colorNew.equals((Object)colorDefault)) {
                store.setToDefault((String)key);
                continue;
            }
            store.setValue((String)key, ColorFactory.convertColorToString(colorNew));
        }
    }

    private void saveThemeColors() {
        try {
            PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.themeChangeListener);
            boolean themeColorChanged = false;
            for (String colorId : themeColors) {
                Color color = this.fColorsCache.get(colorId);
                if (color == null || color.getRGB().equals((Object)ThemeUtils.getCurrentThemeColor(colorId))) continue;
                ThemeUtils.setCurrentThemeColor(colorId, color.getRGB());
                themeColorChanged = true;
            }
            if (themeColorChanged) {
                PrefUtils.savePrefs();
                ThemeUtils.resetCurrentTheme();
            }
        }
        finally {
            PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.themeChangeListener);
        }
    }

    public void init(IWorkbench workbench) {
        this.themeChangeListener = event -> {
            if (themeColors.contains(event.getProperty())) {
                RGB newValue = ThemeUtils.getCurrentThemeColor(event.getProperty());
                this.setColor(event.getProperty(), newValue);
            }
        };
        workbench.getThemeManager().addPropertyChangeListener(this.themeChangeListener);
    }

    public void dispose() {
        super.dispose();
        this.fColorsCache.clear();
        this.fColorsCache = null;
        this.fImageRegistry.dispose();
        this.fImageRegistry = null;
        PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.themeChangeListener);
    }

    private record TreeGrouping(String title, Object[] children) {
    }
}

