/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.preferences;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.preferences.IPreferenceConstants;
import com.archimatetool.model.IArchimatePackage;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;

public class ConnectionPreferences
implements IPreferenceConstants {
    static Map<EClass, Integer> RELATION_KEYMAP = new LinkedHashMap<EClass, Integer>();

    static {
        RELATION_KEYMAP.put(IArchimatePackage.eINSTANCE.getCompositionRelationship(), 512);
        RELATION_KEYMAP.put(IArchimatePackage.eINSTANCE.getAggregationRelationship(), 256);
        RELATION_KEYMAP.put(IArchimatePackage.eINSTANCE.getAccessRelationship(), 2);
        RELATION_KEYMAP.put(IArchimatePackage.eINSTANCE.getAssignmentRelationship(), 128);
        RELATION_KEYMAP.put(IArchimatePackage.eINSTANCE.getRealizationRelationship(), 32);
        RELATION_KEYMAP.put(IArchimatePackage.eINSTANCE.getServingRelationship(), 4);
        RELATION_KEYMAP.put(IArchimatePackage.eINSTANCE.getInfluenceRelationship(), 1024);
        RELATION_KEYMAP.put(IArchimatePackage.eINSTANCE.getSpecializationRelationship(), 64);
        RELATION_KEYMAP.put(IArchimatePackage.eINSTANCE.getAssociationRelationship(), 1);
        RELATION_KEYMAP.put(IArchimatePackage.eINSTANCE.getTriggeringRelationship(), 16);
        RELATION_KEYMAP.put(IArchimatePackage.eINSTANCE.getFlowRelationship(), 8);
    }

    public static boolean useNestedConnections() {
        return ArchiPlugin.getInstance().getPreferenceStore().getBoolean("useNestedConnections");
    }

    public static boolean createRelationWhenAddingNewElement() {
        return ConnectionPreferences.useNestedConnections() && ArchiPlugin.getInstance().getPreferenceStore().getBoolean("createRelationWhenAddingNewElementToContainer");
    }

    public static boolean createRelationWhenAddingModelTreeElement() {
        return ConnectionPreferences.useNestedConnections() && ArchiPlugin.getInstance().getPreferenceStore().getBoolean("createRelationWhenAddingModelTreeElementToContainer");
    }

    public static boolean createRelationWhenMovingElement() {
        return ConnectionPreferences.useNestedConnections() && ArchiPlugin.getInstance().getPreferenceStore().getBoolean("createRelationWhenMovingElementToContainer");
    }

    public static Set<EClass> getRelationsClassesForNewRelations() {
        return ConnectionPreferences.getRelationsClasses("newRelationsTypes");
    }

    public static Set<EClass> getRelationsClassesForNewReverseRelations() {
        return ConnectionPreferences.getRelationsClasses("newReverseRelationsTypes");
    }

    public static Set<EClass> getRelationsClassesForHiding() {
        return ConnectionPreferences.getRelationsClasses("hiddenRelationsTypes");
    }

    private static Set<EClass> getRelationsClasses(String type) {
        int val = ArchiPlugin.getInstance().getPreferenceStore().getInt(type);
        LinkedHashSet<EClass> set = new LinkedHashSet<EClass>();
        for (Map.Entry<EClass, Integer> entry : RELATION_KEYMAP.entrySet()) {
            if ((entry.getValue() & val) == 0) continue;
            set.add(entry.getKey());
        }
        return set;
    }
}

