/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.preferences;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.preferences.IPreferenceConstants;
import com.archimatetool.editor.preferences.Messages;
import com.archimatetool.editor.ui.FigureImagePreviewFactory;
import com.archimatetool.editor.ui.factory.IArchimateElementUIProvider;
import com.archimatetool.editor.ui.factory.IObjectUIProvider;
import com.archimatetool.editor.ui.factory.ObjectUIFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class DiagramFiguresPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IPreferenceConstants {
    private static String HELP_ID = "com.archimatetool.help.prefsDiagram";
    private List<ImageChoice> fChoices = new ArrayList<ImageChoice>();
    private TableViewer fTableViewer;
    private final int itemWidth = 180;
    private final int itemHeight = 72;
    private Color hiliteColor = new Color(78, 178, 255);

    public DiagramFiguresPreferencePage() {
        this.setPreferenceStore(ArchiPlugin.getInstance().getPreferenceStore());
    }

    public Composite createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
        this.loadFigures();
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        client.setLayout((Layout)layout);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        Composite tableClient = new Composite(client, 0);
        tableClient.setLayout((Layout)gridLayout);
        tableClient.setLayoutData((Object)new GridData(1808));
        Label label = new Label(tableClient, 0);
        label.setText(Messages.DiagramFiguresPreferencePage_0);
        Composite client2 = new Composite(tableClient, 0);
        client2.setLayout((Layout)new TableColumnLayout());
        GridDataFactory.create((int)1808).hint(-1, 200).applyTo((Control)client2);
        this.createTable(client2);
        this.fTableViewer.setInput(this.fChoices);
        Display.getCurrent().asyncExec(() -> client2.layout());
        return client;
    }

    private void loadFigures() {
        for (IObjectUIProvider provider : ObjectUIFactory.INSTANCE.getProviders()) {
            if (!(provider instanceof IArchimateElementUIProvider) || !((IArchimateElementUIProvider)provider).hasAlternateFigure()) continue;
            this.fChoices.add(new ImageChoice(provider));
        }
        Collections.sort(this.fChoices, new Comparator<ImageChoice>(){

            @Override
            public int compare(ImageChoice o1, ImageChoice o2) {
                return o1.name.compareTo(o2.name);
            }
        });
    }

    private void createTable(Composite parent) {
        this.fTableViewer = new TableViewer(parent, 67584);
        TableColumnLayout layout = (TableColumnLayout)parent.getLayout();
        TableViewerColumn column = new TableViewerColumn(this.fTableViewer, 0);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, false));
        this.fTableViewer.getTable().addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 72;
            }
        });
        this.fTableViewer.getTable().addListener(42, new Listener(){
            int alpha = 100;

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                if (item == null) {
                    return;
                }
                event.gc.setAntialias(1);
                int row = DiagramFiguresPreferencePage.this.fTableViewer.getTable().indexOf(item);
                ImageChoice ic = DiagramFiguresPreferencePage.this.fChoices.get(row);
                Image image1 = ic.getImage(0);
                int x = 90 - image1.getBounds().width / 2;
                event.gc.setAlpha(ic.chosenType == 0 ? 255 : this.alpha);
                event.gc.drawImage(image1, event.x + x, event.y + (72 - image1.getBounds().height) / 2);
                Image image2 = ic.getImage(1);
                x = 180 + (90 - image2.getBounds().width / 2);
                event.gc.setAlpha(ic.chosenType == 1 ? 255 : this.alpha);
                event.gc.drawImage(image2, event.x + x, event.y + (72 - image2.getBounds().height) / 2);
                int highlight_x = ic.chosenType == 0 ? 20 : 200;
                event.gc.setForeground(DiagramFiguresPreferencePage.this.hiliteColor);
                event.gc.setAlpha(255);
                event.gc.setLineWidth(2);
                event.gc.drawRoundRectangle(event.x + highlight_x, event.y + 2, event.x + 180 - 39, 69, 15, 15);
            }
        });
        this.fTableViewer.getTable().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFFD;
                event.detail &= 0xFFFFFFDF;
            }
        });
        this.fTableViewer.getTable().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = DiagramFiguresPreferencePage.this.fTableViewer.getTable().getItem(new Point(event.x, event.y));
                if (item == null) {
                    return;
                }
                int row = DiagramFiguresPreferencePage.this.fTableViewer.getTable().indexOf(item);
                ImageChoice ic = DiagramFiguresPreferencePage.this.fChoices.get(row);
                ic.chosenType = event.x < 180 ? 0 : 1;
                DiagramFiguresPreferencePage.this.fTableViewer.refresh((Object)ic);
            }
        });
        this.fTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }
        });
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return null;
            }
        });
    }

    public boolean performOk() {
        for (ImageChoice choice : this.fChoices) {
            ArchiPlugin.getInstance().getPreferenceStore().setValue(choice.preferenceKey, choice.chosenType);
        }
        return true;
    }

    protected void performDefaults() {
        for (ImageChoice choice : this.fChoices) {
            choice.chosenType = 0;
        }
        this.fTableViewer.getTable().redraw();
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
    }

    private class ImageChoice {
        String name;
        String preferenceKey;
        int chosenType = 0;
        Image[] images = new Image[2];

        ImageChoice(IObjectUIProvider provider) {
            this.name = provider.getDefaultName();
            this.preferenceKey = "defaultFigure" + provider.providerFor().getName();
            this.images[0] = FigureImagePreviewFactory.getPreviewImage(provider.providerFor(), 0);
            this.images[1] = FigureImagePreviewFactory.getPreviewImage(provider.providerFor(), 1);
            this.chosenType = ArchiPlugin.getInstance().getPreferenceStore().getInt(this.preferenceKey);
        }

        Image getImage(int index) {
            return this.images[index];
        }
    }
}

