/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.preferences;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Spinner;

public class SpinnerFieldEditor
extends FieldEditor {
    private int fMin;
    private int fMax;
    private Spinner fSpinner;

    public SpinnerFieldEditor() {
    }

    public SpinnerFieldEditor(String preferenceName, String labelText, int min, int max, Composite parent) {
        this.fMin = min;
        this.fMax = max;
        this.init(preferenceName, labelText);
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.getSpinnerControl(parent);
    }

    private Spinner getSpinnerControl(Composite parent) {
        if (this.fSpinner == null) {
            this.fSpinner = new Spinner(parent, 2048);
            this.fSpinner.setMinimum(this.fMin);
            this.fSpinner.setMaximum(this.fMax);
        }
        return this.fSpinner;
    }

    protected void doLoad() {
        this.fSpinner.setSelection(this.getPreferenceStore().getInt(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        this.fSpinner.setSelection(this.getPreferenceStore().getDefaultInt(this.getPreferenceName()));
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.fSpinner.getSelection());
    }

    public int getNumberOfControls() {
        return 2;
    }
}

