/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.ui.ThemeUtils;
import com.archimatetool.editor.ui.UIUtils;
import com.archimatetool.editor.ui.components.GlobalActionDisablementHandler;
import com.archimatetool.editor.ui.components.StyledTextControl;
import com.archimatetool.editor.utils.PlatformUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractArchiPropertySection
extends AbstractPropertySection {
    protected TabbedPropertySheetPage fPage;
    protected static int V_SPACING = 10;
    private static Map<Integer, Integer> labelWidths = new HashMap<Integer, Integer>();

    public void setInput(IWorkbenchPart part, ISelection selection) {
        this.handleSelection((IStructuredSelection)selection);
        super.setInput(part, selection);
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.fPage = tabbedPropertySheetPage;
        this.setLayout(parent);
        this.createControls(parent);
    }

    protected void setLayout(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginTop = V_SPACING;
        layout.marginHeight = 0;
        layout.marginLeft = 3;
        layout.marginBottom = 2;
        layout.verticalSpacing = V_SPACING;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(4, 4, true, this.shouldUseExtraSpace()));
    }

    protected abstract void createControls(Composite var1);

    protected abstract void handleSelection(IStructuredSelection var1);

    protected void updatePropertiesLabel() {
        this.fPage.labelProviderChanged(null);
    }

    protected Text createSingleTextControl(Composite parent, int style) {
        Text textControl = this.getWidgetFactory().createText(parent, null, style | 4);
        ThemeUtils.registerCssId((Control)textControl, "SingleTextControl");
        ThemeUtils.setFontIfCssThemingDisabled((Control)textControl, "com.archimatetool.editor.SINGLE_LINE_TEXT_FONT");
        UIUtils.applyNewlineFilter((Control)textControl);
        UIUtils.applyInvalidCharacterFilter((Control)textControl);
        UIUtils.applyMacUndoBugFilter((Control)textControl);
        this.addGlobalActionDisablementListener((Control)textControl);
        GridData gd = new GridData(4, 0, true, false);
        gd.widthHint = 100;
        textControl.setLayoutData((Object)gd);
        return textControl;
    }

    protected StyledTextControl createStyledTextControl(Composite parent, int style) {
        StyledTextControl styledTextControl = new StyledTextControl(parent, style | 0x800 | 2 | 0x200 | 0x40);
        this.addGlobalActionDisablementListener((Control)styledTextControl.getControl());
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 100;
        gd.heightHint = 100;
        styledTextControl.getControl().setLayoutData((Object)gd);
        return styledTextControl;
    }

    protected Composite createComposite(Composite parent, int numColumns) {
        return this.createComposite(parent, numColumns, false);
    }

    protected Composite createComposite(Composite parent, int numColumns, boolean makeColumnsEqualWidth) {
        Composite c = new Composite(parent, 0);
        this.getWidgetFactory().adapt(c);
        GridLayout layout = new GridLayout(numColumns, makeColumnsEqualWidth);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = V_SPACING;
        c.setLayout((Layout)layout);
        c.setLayoutData((Object)new GridData());
        return c;
    }

    protected Label createLabel(Composite parent, String text, int preferredWidth, int verticalPosition) {
        Label label = this.getWidgetFactory().createLabel(parent, text, 64);
        if (parent instanceof Group && PlatformUtils.isMac()) {
            label.setBackground(null);
        }
        GridData gd = new GridData(0, verticalPosition, false, false);
        gd.widthHint = AbstractArchiPropertySection.getLabelWidth(label, preferredWidth);
        label.setLayoutData((Object)gd);
        return label;
    }

    protected Composite createTableComposite(Composite parent, int style) {
        Composite tableComp = new Composite(parent, style);
        GridData gd = new GridData(1808);
        gd.heightHint = 50;
        tableComp.setLayoutData((Object)gd);
        tableComp.setLayout((Layout)new TableColumnLayout());
        return tableComp;
    }

    protected static int getLabelWidth(Label label, int preferredWidth) {
        if (!labelWidths.containsKey(preferredWidth)) {
            GC gc = new GC((Drawable)label);
            labelWidths.put(preferredWidth, Math.max(gc.textExtent((String)"XXXXXXXXXXXXXX").x, preferredWidth));
            gc.dispose();
        }
        return labelWidths.get(preferredWidth);
    }

    protected void addGlobalActionDisablementListener(Control control) {
        int[] eventTypes = new int[]{15, 16, 14};
        TextControlGlobalActionDisablementListener listener = new TextControlGlobalActionDisablementListener();
        int[] nArray = eventTypes;
        int n = eventTypes.length;
        int n2 = 0;
        while (n2 < n) {
            int type = nArray[n2];
            control.addListener(type, (Listener)listener);
            ++n2;
        }
        control.addDisposeListener(event -> {
            int[] nArray2 = eventTypes;
            int n = eventTypes.length;
            int n2 = 0;
            while (n2 < n) {
                int type = nArray2[n2];
                control.removeListener(type, (Listener)listener);
                ++n2;
            }
        });
    }

    private class TextControlGlobalActionDisablementListener
    implements Listener {
        private GlobalActionDisablementHandler propertiesViewGlobalActionHandler;
        private GlobalActionDisablementHandler globalActionHandler;

        private TextControlGlobalActionDisablementListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 15: {
                    event.widget.addListener(24, (Listener)this);
                    break;
                }
                case 24: {
                    if (this.propertiesViewGlobalActionHandler != null) {
                        return;
                    }
                    IActionBars actionBars = AbstractArchiPropertySection.this.fPage.getSite().getActionBars();
                    this.propertiesViewGlobalActionHandler = new GlobalActionDisablementHandler(actionBars);
                    this.propertiesViewGlobalActionHandler.clearGlobalActions();
                    this.globalActionHandler = new GlobalActionDisablementHandler();
                    this.globalActionHandler.update();
                    break;
                }
                case 16: {
                    event.widget.removeListener(24, (Listener)this);
                }
                case 14: {
                    if (this.propertiesViewGlobalActionHandler != null && this.globalActionHandler != null) {
                        this.propertiesViewGlobalActionHandler.restoreGlobalActions();
                        this.globalActionHandler.update();
                    }
                    this.propertiesViewGlobalActionHandler = null;
                    this.globalActionHandler = null;
                    break;
                }
            }
        }
    }
}

