/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.model.commands.EObjectFeatureCommand;
import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.editor.propertysections.IObjectFilter;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.propertysections.ObjectFilter;
import com.archimatetool.editor.propertysections.PropertySectionTextControl;
import com.archimatetool.editor.ui.components.StyledTextControl;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimatePackage;
import java.io.File;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ArchimateModelSection
extends AbstractECorePropertySection {
    private static final String HELP_ID = "com.archimatetool.help.archimateModelSection";
    private PropertySectionTextControl fTextName;
    private Text fTextFile;
    private PropertySectionTextControl fTextPurpose;

    @Override
    protected void createControls(Composite parent) {
        this.fTextName = this.createNameControl(parent, Messages.ArchimateModelSection_0);
        this.createFileControl(parent);
        this.createPurposeControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
    }

    private void createFileControl(Composite parent) {
        this.createLabel(parent, Messages.ArchimateModelSection_1, 85, 0x1000000);
        this.fTextFile = this.createSingleTextControl(parent, 8);
    }

    private void createPurposeControl(Composite parent) {
        this.createLabel(parent, Messages.ArchimateModelSection_2, 85, 0);
        StyledTextControl styledTextControl = this.createStyledTextControl(parent, 0);
        styledTextControl.setMessage(Messages.ArchimateModelSection_4);
        this.fTextPurpose = new PropertySectionTextControl((Control)styledTextControl.getControl(), IArchimatePackage.Literals.ARCHIMATE_MODEL__PURPOSE){

            @Override
            protected void textChanged(String oldText, String newText) {
                EObjectFeatureCommand cmd;
                IArchimateModelObject model = ArchimateModelSection.this.getFirstSelectedObject();
                if (ArchimateModelSection.this.isAlive((EObject)model) && (cmd = new EObjectFeatureCommand(Messages.ArchimateModelSection_3, (EObject)ArchimateModelSection.this.getFirstSelectedObject(), (EStructuralFeature)IArchimatePackage.Literals.ARCHIMATE_MODEL__PURPOSE, newText)).canExecute()) {
                    ArchimateModelSection.this.executeCommand(cmd);
                }
            }
        };
    }

    @Override
    protected void notifyChanged(Notification msg) {
        Object feature = msg.getFeature();
        if (feature == IArchimatePackage.Literals.NAMEABLE__NAME) {
            this.refreshNameField();
            this.updatePropertiesLabel();
        } else if (feature == IArchimatePackage.Literals.ARCHIMATE_MODEL__FILE) {
            this.refreshFileField();
        } else if (feature == IArchimatePackage.Literals.ARCHIMATE_MODEL__PURPOSE) {
            this.refreshPurposeField();
        }
    }

    @Override
    protected void update() {
        this.refreshNameField();
        this.refreshFileField();
        this.refreshPurposeField();
    }

    protected void refreshNameField() {
        if (this.fIsExecutingCommand) {
            return;
        }
        this.fTextName.refresh((EObject)this.getFirstSelectedObject());
    }

    protected void refreshFileField() {
        File file = ((IArchimateModel)this.getFirstSelectedObject()).getFile();
        if (file != null) {
            this.fTextFile.setText(file.getAbsolutePath());
        } else {
            this.fTextFile.setText(Messages.ArchimateModelSection_5);
        }
    }

    protected void refreshPurposeField() {
        if (this.fIsExecutingCommand) {
            return;
        }
        this.fTextPurpose.refresh((EObject)this.getFirstSelectedObject());
    }

    @Override
    protected IObjectFilter getFilter() {
        return new Filter();
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public static class Filter
    extends ObjectFilter {
        @Override
        public boolean isRequiredType(Object object) {
            return object instanceof IArchimateModel;
        }

        @Override
        public Class<?> getAdaptableType() {
            return IArchimateModel.class;
        }
    }
}

