/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.diagram.commands.BorderColorCommand;
import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.editor.propertysections.IObjectFilter;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.propertysections.ObjectFilter;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.ui.components.ColorChooser;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IBorderObject;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BorderColorSection
extends AbstractECorePropertySection {
    private static final String HELP_ID = "com.archimatetool.help.elementPropertySection";
    private IPropertyChangeListener colorListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            RGB rgb = BorderColorSection.this.fColorChooser.getColorValue();
            String newColor = ColorFactory.convertRGBToString(rgb);
            CompoundCommand result = new CompoundCommand();
            for (EObject eObject : BorderColorSection.this.getEObjects()) {
                IBorderObject bo;
                BorderColorCommand cmd;
                if (!BorderColorSection.this.isAlive(eObject) || !(eObject instanceof IBorderObject) || !(cmd = new BorderColorCommand(bo = (IBorderObject)eObject, newColor)).canExecute()) continue;
                result.add((Command)cmd);
            }
            BorderColorSection.this.executeCommand(result.unwrap());
        }
    };
    private ColorChooser fColorChooser;
    private IAction fNoBorderAction;

    @Override
    protected void createControls(Composite parent) {
        this.createColorControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
    }

    private void createColorControl(Composite parent) {
        this.createLabel(parent, Messages.BorderColorSection_0, 115, 0x1000000);
        this.fColorChooser = new ColorChooser(parent, (FormToolkit)this.getWidgetFactory());
        this.fColorChooser.setDoShowDefaultMenuItem(false);
        this.fColorChooser.setDoShowPreferencesMenuItem(false);
        this.fNoBorderAction = new Action(Messages.BorderColorSection_1, 32){

            public void run() {
                CompoundCommand result = new CompoundCommand();
                for (EObject eObject : BorderColorSection.this.getEObjects()) {
                    String color;
                    IBorderObject bo;
                    BorderColorCommand cmd;
                    if (!BorderColorSection.this.isAlive(eObject) || !(eObject instanceof IBorderObject) || !(cmd = new BorderColorCommand(bo = (IBorderObject)eObject, color = this.isChecked() ? null : "#000000")).canExecute()) continue;
                    result.add((Command)cmd);
                }
                BorderColorSection.this.executeCommand(result.unwrap());
            }
        };
        this.fColorChooser.addMenuAction(this.fNoBorderAction);
        this.fColorChooser.addListener(this.colorListener);
    }

    @Override
    protected void notifyChanged(Notification msg) {
        Object feature = msg.getFeature();
        if (feature == IArchimatePackage.Literals.BORDER_OBJECT__BORDER_COLOR || feature == IArchimatePackage.Literals.LOCKABLE__LOCKED) {
            this.update();
        }
    }

    @Override
    protected void update() {
        IBorderObject bo = (IBorderObject)this.getFirstSelectedObject();
        String colorValue = bo.getBorderColor();
        RGB rgb = ColorFactory.convertStringToRGB(colorValue);
        if (rgb == null) {
            rgb = new RGB(0, 0, 0);
        }
        this.fColorChooser.setColorValue(rgb);
        this.fColorChooser.setEnabled(!this.isLocked(bo));
        this.fNoBorderAction.setChecked(colorValue == null);
        this.fColorChooser.setDoShowColorImage(colorValue != null);
    }

    @Override
    protected IObjectFilter getFilter() {
        return new Filter();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fColorChooser != null) {
            this.fColorChooser.removeListener(this.colorListener);
        }
    }

    public static class Filter
    extends ObjectFilter {
        @Override
        public boolean isRequiredType(Object object) {
            return object instanceof IBorderObject;
        }

        @Override
        public Class<?> getAdaptableType() {
            return IBorderObject.class;
        }
    }
}

