/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.model.commands.EObjectFeatureCommand;
import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.editor.propertysections.IObjectFilter;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.propertysections.ObjectFilter;
import com.archimatetool.editor.ui.FigureImagePreviewFactory;
import com.archimatetool.editor.ui.factory.IArchimateElementUIProvider;
import com.archimatetool.editor.ui.factory.ObjectUIFactory;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModelArchimateObject;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class DiagramFigureTypeSection
extends AbstractECorePropertySection {
    private static final String HELP_ID = "com.archimatetool.help.diagramFigureTypeSection";
    private ImageFigure figure1;
    private ImageFigure figure2;

    @Override
    protected void createControls(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
        this.figure1 = new ImageFigure(parent, 0);
        this.figure2 = new ImageFigure(parent, 1);
    }

    @Override
    protected void update() {
        this.figure1.setVisible(false);
        this.figure2.setVisible(false);
        int i = 0;
        while (i < this.getEObjects().size() - 1) {
            IDiagramModelArchimateObject first = (IDiagramModelArchimateObject)this.getEObjects().get(i);
            IDiagramModelArchimateObject next = (IDiagramModelArchimateObject)this.getEObjects().get(i + 1);
            if (first.getArchimateConcept().eClass() != next.getArchimateConcept().eClass()) {
                return;
            }
            ++i;
        }
        this.figure1.setVisible(true);
        this.figure2.setVisible(true);
        IDiagramModelArchimateObject firstSelected = (IDiagramModelArchimateObject)this.getFirstSelectedObject();
        IArchimateElement element = firstSelected.getArchimateElement();
        Image image1 = FigureImagePreviewFactory.getPreviewImage(element.eClass(), 0);
        Image image2 = FigureImagePreviewFactory.getPreviewImage(element.eClass(), 1);
        this.figure1.setImage(image1);
        this.figure2.setImage(image2);
        this.figure1.getParent().layout();
        int type = firstSelected.getType();
        this.figure1.setSelected(type == 0);
        this.figure2.setSelected(type == 1);
    }

    @Override
    protected IObjectFilter getFilter() {
        return new Filter();
    }

    @Override
    protected void notifyChanged(Notification msg) {
        Object feature = msg.getFeature();
        if (feature == IArchimatePackage.Literals.DIAGRAM_MODEL_ARCHIMATE_OBJECT__TYPE) {
            this.update();
        }
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public static class Filter
    extends ObjectFilter {
        @Override
        public boolean isRequiredType(Object object) {
            if (object instanceof IDiagramModelArchimateObject) {
                IArchimateElementUIProvider provider = (IArchimateElementUIProvider)ObjectUIFactory.INSTANCE.getProvider((EObject)((IDiagramModelArchimateObject)object));
                return provider.hasAlternateFigure();
            }
            return false;
        }

        @Override
        public Class<?> getAdaptableType() {
            return IDiagramModelArchimateObject.class;
        }
    }

    private class ImageFigure
    extends Composite {
        boolean selected;
        Label label;

        public ImageFigure(Composite parent, final int value) {
            super(parent, 0);
            this.setBackgroundMode(1);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 3;
            gridLayout.marginHeight = 3;
            this.setLayout((Layout)gridLayout);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    if (ImageFigure.this.selected) {
                        GC graphics = e.gc;
                        graphics.setForeground(ColorConstants.blue);
                        graphics.setLineWidth(2);
                        Rectangle bounds = ImageFigure.this.getBounds();
                        graphics.drawRectangle(1, 1, bounds.width - 2, bounds.height - 2);
                    }
                }
            });
            this.label = new Label((Composite)this, 0);
            DiagramFigureTypeSection.this.getWidgetFactory().adapt((Composite)this);
            this.label.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    CompoundCommand result = new CompoundCommand();
                    for (EObject eObject : DiagramFigureTypeSection.this.getEObjects()) {
                        EObjectFeatureCommand cmd;
                        if (!DiagramFigureTypeSection.this.isAlive(eObject) || DiagramFigureTypeSection.this.isLocked(eObject) || !(cmd = new EObjectFeatureCommand(Messages.DiagramFigureTypeSection_0, eObject, (EStructuralFeature)IArchimatePackage.Literals.DIAGRAM_MODEL_ARCHIMATE_OBJECT__TYPE, value)).canExecute()) continue;
                        result.add((Command)cmd);
                    }
                    DiagramFigureTypeSection.this.executeCommand(result.unwrap());
                }
            });
        }

        void setImage(Image image) {
            this.label.setImage(image);
        }

        void setSelected(boolean set) {
            this.selected = set;
            this.redraw();
        }
    }
}

