/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.diagram.actions.ConnectionRouterAction;
import com.archimatetool.editor.diagram.commands.ConnectionRouterTypeCommand;
import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.editor.propertysections.IObjectFilter;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.propertysections.ObjectFilter;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelReference;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class DiagramModelConnectionSection
extends AbstractECorePropertySection {
    private static final String HELP_ID = "com.archimatetool.help.diagramModelSection";
    private Combo fComboRouterType;
    private String[] comboItems = new String[]{ConnectionRouterAction.CONNECTION_ROUTER_BENDPONT, ConnectionRouterAction.CONNECTION_ROUTER_MANHATTAN};

    @Override
    protected void createControls(Composite parent) {
        this.createRouterTypeControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
    }

    private void createRouterTypeControl(Composite parent) {
        this.createLabel(parent, Messages.DiagramModelConnectionSection_0, 115, 0x1000000);
        this.fComboRouterType = new Combo(parent, 8);
        this.getWidgetFactory().adapt((Control)this.fComboRouterType, true, true);
        this.fComboRouterType.setItems(this.comboItems);
        this.fComboRouterType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompoundCommand result = new CompoundCommand();
                for (EObject eObject : DiagramModelConnectionSection.this.getEObjects()) {
                    ConnectionRouterTypeCommand cmd;
                    if (!DiagramModelConnectionSection.this.isAlive(eObject) || !(cmd = new ConnectionRouterTypeCommand((IDiagramModel)eObject, ConnectionRouterAction.CONNECTION_ROUTER_TYPES.get(DiagramModelConnectionSection.this.fComboRouterType.getSelectionIndex()))).canExecute()) continue;
                    result.add((Command)cmd);
                }
                DiagramModelConnectionSection.this.executeCommand(result.unwrap());
            }
        });
        GridData gd = new GridData(0, 0, true, false);
        gd.minimumWidth = 100;
        this.fComboRouterType.setLayoutData((Object)gd);
    }

    @Override
    protected void notifyChanged(Notification msg) {
        Object feature = msg.getFeature();
        if (feature == IArchimatePackage.Literals.DIAGRAM_MODEL__CONNECTION_ROUTER_TYPE) {
            this.update();
        }
    }

    @Override
    protected void update() {
        if (this.fIsExecutingCommand) {
            return;
        }
        int type = ((IDiagramModel)this.getFirstSelectedObject()).getConnectionRouterType();
        if (ConnectionRouterAction.CONNECTION_ROUTER_TYPES.indexOf(type) == -1) {
            type = 0;
        }
        this.fComboRouterType.select(ConnectionRouterAction.CONNECTION_ROUTER_TYPES.indexOf(type));
    }

    @Override
    protected IObjectFilter getFilter() {
        return new Filter();
    }

    public static class Filter
    extends ObjectFilter {
        @Override
        public boolean select(Object object) {
            if (object instanceof IAdaptable && ((IAdaptable)object).getAdapter(IDiagramModelReference.class) != null) {
                return false;
            }
            return super.select(object);
        }

        @Override
        public boolean isRequiredType(Object object) {
            return object instanceof IDiagramModel;
        }

        @Override
        public Class<?> getAdaptableType() {
            return IDiagramModel.class;
        }
    }
}

