/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.propertysections.AbstractMultiControlSection;
import com.archimatetool.editor.propertysections.FillColorComposite;
import com.archimatetool.editor.propertysections.GradientComposite;
import com.archimatetool.editor.propertysections.IObjectFilter;
import com.archimatetool.editor.propertysections.ObjectFilter;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModelObject;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class FillColorSection
extends AbstractMultiControlSection {
    private static final String HELP_ID = "com.archimatetool.help.elementPropertySection";
    private FillColorComposite fillColorComposite;
    private GradientComposite gradientComposite;

    @Override
    protected void createControls(Composite parent) {
        this.init(parent, 2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
    }

    @Override
    protected void notifyChanged(Notification msg) {
        Object feature = msg.getFeature();
        if (feature == IArchimatePackage.Literals.DIAGRAM_MODEL_OBJECT__FILL_COLOR) {
            this.updateColorControl();
        } else if (this.isFeatureNotification(msg, "gradient")) {
            if (!this.fIsExecutingCommand) {
                this.updateGradientControl();
            }
        } else if (feature == IArchimatePackage.Literals.LOCKABLE__LOCKED) {
            this.update();
        }
    }

    @Override
    protected void update() {
        this.updateColorControl();
        this.updateGradientControl();
    }

    private void updateColorControl() {
        boolean show = this.shouldShowControl(IArchimatePackage.Literals.DIAGRAM_MODEL_OBJECT__FILL_COLOR.getName());
        if (show) {
            if (this.fillColorComposite == null) {
                this.fillColorComposite = new FillColorComposite(this, this.parentComposite);
                if (this.gradientComposite != null) {
                    this.fillColorComposite.getComposite().moveAbove((Control)this.gradientComposite.getComposite());
                    this.layout();
                }
            }
            this.fillColorComposite.updateControl();
        } else if (this.fillColorComposite != null) {
            this.fillColorComposite.dispose();
            this.fillColorComposite = null;
            this.layout();
        }
    }

    private void updateGradientControl() {
        boolean show = this.shouldShowControl("gradient");
        if (show) {
            if (this.gradientComposite == null) {
                this.gradientComposite = new GradientComposite(this, this.parentComposite);
                this.layout();
            }
            this.gradientComposite.updateControl();
        } else if (this.gradientComposite != null) {
            this.gradientComposite.dispose();
            this.gradientComposite = null;
            this.layout();
        }
    }

    @Override
    protected IObjectFilter getFilter() {
        return new Filter();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fillColorComposite != null) {
            this.fillColorComposite.dispose();
            this.fillColorComposite = null;
        }
        if (this.gradientComposite != null) {
            this.gradientComposite.dispose();
            this.gradientComposite = null;
        }
    }

    public static class Filter
    extends ObjectFilter {
        @Override
        public boolean isRequiredType(Object object) {
            IDiagramModelObject dmo;
            return object instanceof IDiagramModelObject && (this.shouldExposeFeature((EObject)(dmo = (IDiagramModelObject)object), IArchimatePackage.Literals.DIAGRAM_MODEL_OBJECT__FILL_COLOR.getName()) || this.shouldExposeFeature((EObject)dmo, "gradient"));
        }

        @Override
        public Class<?> getAdaptableType() {
            return IDiagramModelObject.class;
        }
    }
}

