/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.model.commands.FeatureCommand;
import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.editor.propertysections.IObjectFilter;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.propertysections.ObjectFilter;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.ui.components.ColorChooser;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IFeatures;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class IconColorSection
extends AbstractECorePropertySection {
    private static final String HELP_ID = "com.archimatetool.help.elementPropertySection";
    private ColorChooser fColorChooser;
    private IPropertyChangeListener colorListener = event -> {
        String newColor = "";
        if (event.getProperty() == "colorValue") {
            RGB rgb = this.fColorChooser.getColorValue();
            newColor = ColorFactory.convertRGBToString(rgb);
        }
        CompoundCommand result = new CompoundCommand();
        for (EObject eObject : this.getEObjects()) {
            FeatureCommand cmd;
            if (!this.isAlive(eObject) || !(cmd = new FeatureCommand(Messages.IconColorSection_0, (IFeatures)eObject, "iconColor", newColor, "")).canExecute()) continue;
            result.add((Command)cmd);
        }
        this.executeCommand(result.unwrap());
    };

    @Override
    protected void createControls(Composite parent) {
        this.createColorControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
    }

    private void createColorControl(Composite parent) {
        this.createLabel(parent, Messages.IconColorSection_1, 115, 0x1000000);
        this.fColorChooser = new ColorChooser(parent, (FormToolkit)this.getWidgetFactory());
        this.fColorChooser.setDoShowPreferencesMenuItem(false);
        this.fColorChooser.addListener(this.colorListener);
    }

    @Override
    protected void notifyChanged(Notification msg) {
        Object feature = msg.getFeature();
        if (this.isFeatureNotification(msg, "iconColor") || feature == IArchimatePackage.Literals.LOCKABLE__LOCKED) {
            this.update();
        }
    }

    @Override
    protected void update() {
        IDiagramModelObject firstSelected = (IDiagramModelObject)this.getFirstSelectedObject();
        RGB rgb = ColorFactory.convertStringToRGB(firstSelected.getIconColor());
        this.fColorChooser.setColorValue(rgb != null ? rgb : new RGB(0, 0, 0));
        this.fColorChooser.setEnabled(!this.isLocked(firstSelected));
        boolean isDefaultColor = true;
        for (IArchimateModelObject object : this.getEObjects()) {
            if (!(object instanceof IDiagramModelObject)) continue;
            IDiagramModelObject dmo = (IDiagramModelObject)object;
            isDefaultColor &= "".equals(dmo.getIconColor());
        }
        this.fColorChooser.setIsDefaultColor(isDefaultColor);
    }

    @Override
    protected IObjectFilter getFilter() {
        return new Filter();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fColorChooser != null) {
            this.fColorChooser.removeListener(this.colorListener);
        }
    }

    public static class Filter
    extends ObjectFilter {
        @Override
        public boolean isRequiredType(Object object) {
            return object instanceof IDiagramModelArchimateObject && this.shouldExposeFeature((EObject)object, "iconColor");
        }

        @Override
        public Class<?> getAdaptableType() {
            return IDiagramModelArchimateObject.class;
        }
    }
}

