/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.model.commands.FeatureCommand;
import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.editor.propertysections.IObjectFilter;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.propertysections.ObjectFilter;
import com.archimatetool.editor.ui.factory.IGraphicalObjectUIProvider;
import com.archimatetool.editor.ui.factory.IObjectUIProvider;
import com.archimatetool.editor.ui.factory.ObjectUIFactory;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IFeatures;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class IconVisibleSection
extends AbstractECorePropertySection {
    private static final String HELP_ID = "com.archimatetool.help.elementPropertySection";
    private Combo fIconVisibleCombo;
    private String[] VISIBLE_CHOICES = new String[]{Messages.IconVisibleSection_1, Messages.IconVisibleSection_2, Messages.IconVisibleSection_3};

    @Override
    protected void createControls(Composite parent) {
        this.createLabel(parent, Messages.IconVisibleSection_0 + ":", 115, 0x1000000);
        this.fIconVisibleCombo = new Combo(parent, 8);
        this.getWidgetFactory().adapt((Control)this.fIconVisibleCombo, true, true);
        this.fIconVisibleCombo.setItems(this.VISIBLE_CHOICES);
        this.fIconVisibleCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompoundCommand result = new CompoundCommand();
                for (EObject eObject : IconVisibleSection.this.getEObjects()) {
                    FeatureCommand cmd;
                    if (!IconVisibleSection.this.isAlive(eObject) || !(cmd = new FeatureCommand(Messages.IconVisibleSection_0, (IFeatures)eObject, "iconVisible", IconVisibleSection.this.mapFromComboToValue(), 0)).canExecute()) continue;
                    result.add((Command)cmd);
                }
                IconVisibleSection.this.executeCommand(result.unwrap());
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
    }

    @Override
    protected IObjectFilter getFilter() {
        return new Filter();
    }

    @Override
    protected void notifyChanged(Notification msg) {
        if (this.isFeatureNotification(msg, "iconVisible")) {
            this.refreshButton();
        }
    }

    @Override
    protected void update() {
        this.refreshButton();
    }

    private void refreshButton() {
        if (this.fIsExecutingCommand) {
            return;
        }
        IDiagramModelObject lastSelectedObject = (IDiagramModelObject)this.getFirstSelectedObject();
        this.fIconVisibleCombo.select(this.mapFromValueToCombo(lastSelectedObject.getIconVisibleState()));
        this.fIconVisibleCombo.setEnabled(!this.isLocked(lastSelectedObject));
    }

    private int mapFromComboToValue() {
        switch (this.fIconVisibleCombo.getSelectionIndex()) {
            default: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: 
        }
        return 2;
    }

    private int mapFromValueToCombo(int value) {
        switch (value) {
            default: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: 
        }
        return 2;
    }

    public static class Filter
    extends ObjectFilter {
        @Override
        public boolean isRequiredType(Object object) {
            return object instanceof IDiagramModelObject && this.hasIcon(object);
        }

        @Override
        public Class<?> getAdaptableType() {
            return IDiagramModelObject.class;
        }

        private boolean hasIcon(Object object) {
            IObjectUIProvider provider = ObjectUIFactory.INSTANCE.getProvider((EObject)object);
            return provider instanceof IGraphicalObjectUIProvider && ((IGraphicalObjectUIProvider)provider).hasIcon();
        }
    }
}

