/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.model.commands.FeatureCommand;
import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.editor.propertysections.IObjectFilter;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.propertysections.ObjectFilter;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IFeatures;
import com.archimatetool.model.IJunction;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class JunctionConnectionArrowsSection
extends AbstractECorePropertySection {
    private static final String HELP_ID = "com.archimatetool.help.elementPropertySection";
    private Button buttonHideArrowHeads;

    @Override
    protected void createControls(Composite parent) {
        this.createHideArrowsControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
    }

    private void createHideArrowsControl(Composite parent) {
        this.createLabel(parent, Messages.JunctionConnectionArrowsSection_0 + ":", 115, 0x1000000);
        this.buttonHideArrowHeads = this.getWidgetFactory().createButton(parent, null, 32);
        this.buttonHideArrowHeads.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompoundCommand result = new CompoundCommand();
                for (EObject eObject : JunctionConnectionArrowsSection.this.getEObjects()) {
                    FeatureCommand cmd;
                    if (!JunctionConnectionArrowsSection.this.isAlive(eObject) || !(cmd = new FeatureCommand(Messages.JunctionConnectionArrowsSection_1, (IFeatures)eObject, "hideJunctionArrows", JunctionConnectionArrowsSection.this.buttonHideArrowHeads.getSelection(), false)).canExecute()) continue;
                    result.add((Command)cmd);
                }
                JunctionConnectionArrowsSection.this.executeCommand(result.unwrap());
            }
        });
    }

    @Override
    protected void notifyChanged(Notification msg) {
        if (this.isFeatureNotification(msg, "hideJunctionArrows")) {
            this.refreshButton();
        }
    }

    @Override
    protected void update() {
        this.refreshButton();
    }

    private void refreshButton() {
        if (this.fIsExecutingCommand) {
            return;
        }
        IDiagramModelArchimateObject lastSelected = (IDiagramModelArchimateObject)this.getFirstSelectedObject();
        this.buttonHideArrowHeads.setSelection(lastSelected.getFeatures().getBoolean("hideJunctionArrows", false));
        this.buttonHideArrowHeads.setEnabled(!this.isLocked(lastSelected));
    }

    @Override
    protected IObjectFilter getFilter() {
        return new Filter();
    }

    public static class Filter
    extends ObjectFilter {
        @Override
        public boolean isRequiredType(Object object) {
            return object instanceof IDiagramModelArchimateObject && ((IDiagramModelArchimateObject)object).getArchimateElement() instanceof IJunction;
        }

        @Override
        public Class<?> getAdaptableType() {
            return IDiagramModelArchimateObject.class;
        }
    }
}

