/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.propertysections.AbstractMultiControlSection;
import com.archimatetool.editor.propertysections.IObjectFilter;
import com.archimatetool.editor.propertysections.LineColorComposite;
import com.archimatetool.editor.propertysections.LineWidthComposite;
import com.archimatetool.editor.propertysections.ObjectFilter;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.ILineObject;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class LineSection
extends AbstractMultiControlSection {
    private static final String HELP_ID = "com.archimatetool.help.elementPropertySection";
    private LineColorComposite lineColorComposite;
    private LineWidthComposite lineWidthComposite;

    @Override
    protected void createControls(Composite parent) {
        this.init(parent, 2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
    }

    @Override
    protected void notifyChanged(Notification msg) {
        Object feature = msg.getFeature();
        if (feature == IArchimatePackage.Literals.LINE_OBJECT__LINE_COLOR || this.isFeatureNotification(msg, "deriveElementLineColor")) {
            this.updateColorControl();
        } else if (feature == IArchimatePackage.Literals.LINE_OBJECT__LINE_WIDTH) {
            if (!this.fIsExecutingCommand) {
                this.updateLineWidthControl();
            }
        } else if (feature == IArchimatePackage.Literals.LOCKABLE__LOCKED) {
            this.update();
        }
    }

    @Override
    protected void update() {
        this.updateColorControl();
        this.updateLineWidthControl();
    }

    private void updateColorControl() {
        boolean show = this.shouldShowControl(IArchimatePackage.Literals.LINE_OBJECT__LINE_COLOR.getName());
        if (show) {
            if (this.lineColorComposite == null) {
                this.lineColorComposite = new LineColorComposite(this, this.parentComposite);
                if (this.lineWidthComposite != null) {
                    this.lineColorComposite.getComposite().moveAbove((Control)this.lineWidthComposite.getComposite());
                    this.layout();
                }
            }
            this.lineColorComposite.updateControl();
        } else if (this.lineColorComposite != null) {
            this.lineColorComposite.dispose();
            this.lineColorComposite = null;
            this.layout();
        }
    }

    private void updateLineWidthControl() {
        boolean show = this.shouldShowControl(IArchimatePackage.Literals.LINE_OBJECT__LINE_WIDTH.getName());
        if (show) {
            if (this.lineWidthComposite == null) {
                this.lineWidthComposite = new LineWidthComposite(this, this.parentComposite);
                this.layout();
            }
            this.lineWidthComposite.updateControl();
        } else if (this.lineWidthComposite != null) {
            this.lineWidthComposite.dispose();
            this.lineWidthComposite = null;
            this.layout();
        }
    }

    @Override
    protected IObjectFilter getFilter() {
        return new Filter();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.lineColorComposite != null) {
            this.lineColorComposite.dispose();
            this.lineColorComposite = null;
        }
        if (this.lineWidthComposite != null) {
            this.lineWidthComposite.dispose();
            this.lineWidthComposite = null;
        }
    }

    public static class Filter
    extends ObjectFilter {
        @Override
        public boolean isRequiredType(Object object) {
            ILineObject lo;
            return object instanceof ILineObject && (this.shouldExposeFeature((EObject)(lo = (ILineObject)object), IArchimatePackage.Literals.LINE_OBJECT__LINE_COLOR.getName()) || this.shouldExposeFeature((EObject)lo, IArchimatePackage.Literals.LINE_OBJECT__LINE_WIDTH.getName()));
        }

        @Override
        public Class<?> getAdaptableType() {
            return ILineObject.class;
        }
    }
}

