/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.diagram.sketch.ISketchEditor;
import com.archimatetool.editor.model.commands.EObjectFeatureCommand;
import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.editor.propertysections.IObjectFilter;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.propertysections.ObjectFilter;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModelReference;
import com.archimatetool.model.ISketchModel;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class SketchModelBackgroundSection
extends AbstractECorePropertySection {
    private static final String HELP_ID = "com.archimatetool.help.sketchModelDiagramSection";
    private Combo fComboBackground;

    @Override
    protected void createControls(Composite parent) {
        this.createBackgroundControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
    }

    private void createBackgroundControl(Composite parent) {
        this.createLabel(parent, Messages.SketchModelBackgroundSection_0, 115, 0x1000000);
        this.fComboBackground = new Combo(parent, 8);
        this.fComboBackground.setItems(ISketchEditor.BACKGROUNDS);
        this.getWidgetFactory().adapt((Control)this.fComboBackground, true, true);
        this.fComboBackground.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompoundCommand result = new CompoundCommand();
                for (EObject eObject : SketchModelBackgroundSection.this.getEObjects()) {
                    EObjectFeatureCommand cmd;
                    if (!SketchModelBackgroundSection.this.isAlive(eObject) || !(cmd = new EObjectFeatureCommand(Messages.SketchModelBackgroundSection_1, eObject, (EStructuralFeature)IArchimatePackage.Literals.SKETCH_MODEL__BACKGROUND, SketchModelBackgroundSection.this.fComboBackground.getSelectionIndex())).canExecute()) continue;
                    result.add((Command)cmd);
                }
                SketchModelBackgroundSection.this.executeCommand(result.unwrap());
            }
        });
        GridData gd = new GridData(0, 0, true, false);
        gd.minimumWidth = 100;
        this.fComboBackground.setLayoutData((Object)gd);
    }

    @Override
    protected void notifyChanged(Notification msg) {
        Object feature = msg.getFeature();
        if (feature == IArchimatePackage.Literals.SKETCH_MODEL__BACKGROUND) {
            this.update();
        }
    }

    @Override
    protected void update() {
        if (this.fIsExecutingCommand) {
            return;
        }
        this.fComboBackground.select(((ISketchModel)this.getFirstSelectedObject()).getBackground());
    }

    @Override
    protected IObjectFilter getFilter() {
        return new Filter();
    }

    public static class Filter
    extends ObjectFilter {
        @Override
        public boolean select(Object object) {
            if (object instanceof IAdaptable && ((IAdaptable)object).getAdapter(IDiagramModelReference.class) != null) {
                return false;
            }
            return super.select(object);
        }

        @Override
        public boolean isRequiredType(Object object) {
            return object instanceof ISketchModel;
        }

        @Override
        public Class<?> getAdaptableType() {
            return ISketchModel.class;
        }
    }
}

