/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.model.commands.SetProfileCommand;
import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.editor.propertysections.IObjectFilter;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.propertysections.ObjectFilter;
import com.archimatetool.editor.tools.ProfilesManagerDialog;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateFactory;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IProfile;
import com.archimatetool.model.IProfiles;
import com.archimatetool.model.util.ArchimateModelUtils;
import com.archimatetool.model.util.LightweightEContentAdapter;
import java.text.Collator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class SpecializationSection
extends AbstractECorePropertySection {
    private static final String HELP_ID = "com.archimatetool.help.elementPropertySection";
    private ComboViewer fComboViewer;
    private boolean fIsRefreshing;
    private IProfile NONE_PROFILE;
    private IArchimateModel fModel;
    private LightweightEContentAdapter eAdapter = new LightweightEContentAdapter(this::notifyChanged, new Class[]{IProfile.class});

    @Override
    protected void createControls(Composite parent) {
        this.NONE_PROFILE = IArchimateFactory.eINSTANCE.createProfile();
        this.NONE_PROFILE.setName(Messages.SpecializationSection_0);
        this.createLabel(parent, Messages.SpecializationSection_1, 115, 0x1000000);
        Composite comp = this.createComposite(parent, 2);
        comp.setLayoutData((Object)new GridData(768));
        this.fComboViewer = new ComboViewer(new Combo(comp, 2056));
        this.fComboViewer.getCombo().setVisibleItemCount(12);
        this.fComboViewer.getControl().setLayoutData((Object)new GridData(768));
        this.getWidgetFactory().adapt(this.fComboViewer.getControl(), true, true);
        this.fComboViewer.addSelectionChangedListener(event -> {
            if (this.fIsRefreshing) {
                return;
            }
            IProfile profile = (IProfile)((IStructuredSelection)event.getSelection()).getFirstElement();
            if (profile != null) {
                if (profile == this.NONE_PROFILE) {
                    profile = null;
                }
                CompoundCommand result = new CompoundCommand();
                for (EObject eObject : this.getEObjects()) {
                    SetProfileCommand cmd;
                    if (!this.isAlive(eObject) || !(cmd = new SetProfileCommand((IProfiles)((IArchimateConcept)eObject), profile)).canExecute()) continue;
                    result.add((Command)cmd);
                }
                this.executeCommand(result.unwrap());
            }
        });
        this.fComboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                IArchimateConcept firstSelected = (IArchimateConcept)SpecializationSection.this.getFirstSelectedObject();
                if (firstSelected == null) {
                    return new Object[0];
                }
                List profiles = ArchimateModelUtils.findProfilesForConceptType((IArchimateModel)firstSelected.getArchimateModel(), (EClass)firstSelected.eClass());
                Collator collator = Collator.getInstance();
                profiles.sort((p1, p2) -> collator.compare(p1.getName(), p2.getName()));
                profiles.add(0, SpecializationSection.this.NONE_PROFILE);
                return profiles.toArray();
            }
        });
        this.fComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IProfile)element).getName();
            }
        });
        this.fComboViewer.setInput((Object)"");
        Button button = this.getWidgetFactory().createButton(comp, null, 8);
        button.setText(" ... ");
        button.setToolTipText(Messages.SpecializationSection_2);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IArchimateModelObject selected = SpecializationSection.this.getFirstSelectedObject();
                if (selected != null && selected.getArchimateModel() != null) {
                    ProfilesManagerDialog dialog = new ProfilesManagerDialog(SpecializationSection.this.getPart().getSite().getShell(), selected.getArchimateModel());
                    dialog.setDefaultClass(selected.eClass());
                    dialog.open();
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
    }

    @Override
    protected void notifyChanged(Notification msg) {
        Object feature = msg.getFeature();
        if (feature == IArchimatePackage.Literals.ARCHIMATE_MODEL__PROFILES || feature == IArchimatePackage.Literals.PROFILES__PROFILES || msg.getNotifier() instanceof IProfile) {
            this.update();
        }
    }

    @Override
    protected void update() {
        IArchimateModelObject firstSelected = this.getFirstSelectedObject();
        if (this.fIsExecutingCommand || !this.isAlive((EObject)this.getFirstSelectedObject())) {
            return;
        }
        this.fComboViewer.refresh();
        if (firstSelected instanceof IArchimateConcept) {
            this.fIsRefreshing = true;
            EList profiles = ((IArchimateConcept)firstSelected).getProfiles();
            if (!profiles.isEmpty()) {
                this.fComboViewer.setSelection((ISelection)new StructuredSelection(profiles.get(0)));
            } else {
                this.fComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.NONE_PROFILE));
            }
            this.fIsRefreshing = false;
        }
    }

    @Override
    protected IObjectFilter getFilter() {
        return new Filter();
    }

    @Override
    protected void addAdapter() {
        super.addAdapter();
        IArchimateModelObject selected = this.getFirstSelectedObject();
        if (selected != null && selected.getArchimateModel() != null && !selected.getArchimateModel().eAdapters().contains((Object)this.eAdapter)) {
            this.fModel = selected.getArchimateModel();
            this.fModel.eAdapters().add((Object)this.eAdapter);
        }
    }

    @Override
    protected void removeAdapter() {
        super.removeAdapter();
        if (this.fModel != null) {
            this.fModel.eAdapters().remove((Object)this.eAdapter);
            this.fModel = null;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.eAdapter = null;
        this.fModel = null;
    }

    public static class Filter
    extends ObjectFilter {
        @Override
        public boolean isRequiredType(Object object) {
            return object instanceof IArchimateConcept;
        }

        @Override
        public Class<?> getAdaptableType() {
            return IArchimateConcept.class;
        }
    }
}

