/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.model.commands.NonNotifyingCompoundCommand;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.UIUtils;
import com.archimatetool.editor.ui.components.ExtendedTitleAreaDialog;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IProperties;
import com.archimatetool.model.IProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IIndexableLazyContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class UserPropertiesManagerDialog
extends ExtendedTitleAreaDialog {
    private static String HELP_ID = "com.archimatetool.help.userProperties";
    private TableViewer fTableViewer;
    private IArchimateModel fArchimateModel;
    private Map<String, KeyEntry> fKeysMap = new LinkedHashMap<String, KeyEntry>();
    private Button fButtonDelete;
    private Button fButtonRename;
    private IAction fActionDelete;
    private IAction fActionRename;

    public UserPropertiesManagerDialog(Shell parentShell, IArchimateModel model) {
        super(parentShell, "UserPropertiesManagerDialog");
        this.setTitleImage(IArchiImages.ImageFactory.getImage("img/importpref_wiz.png"));
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fArchimateModel = model;
        this.getAllUniquePropertyKeysForModel();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.UserPropertiesManagerDialog_0);
    }

    protected Control createButtonBar(Composite parent) {
        Control c = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return c;
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
        this.setTitle(Messages.UserPropertiesManagerDialog_1);
        this.setMessage(Messages.UserPropertiesManagerDialog_2);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite client = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        client.setLayout((Layout)layout);
        client.setLayoutData((Object)new GridData(1808));
        this.createTableControl(client);
        this.createButtonPanel(client);
        this.fActionDelete = new Action(Messages.UserPropertiesManagerDialog_3){

            public void run() {
                UserPropertiesManagerDialog.this.deleteSelectedPropertyKeys();
            }

            public String getToolTipText() {
                return this.getText();
            }

            public ImageDescriptor getImageDescriptor() {
                return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE");
            }
        };
        this.fActionDelete.setEnabled(false);
        this.fActionRename = new Action(Messages.UserPropertiesManagerDialog_4){

            public void run() {
                UserPropertiesManagerDialog.this.renameSelectedPropertyKey();
            }

            public String getToolTipText() {
                return Messages.UserPropertiesManagerDialog_5;
            }
        };
        this.fActionRename.setEnabled(false);
        this.hookContextMenu();
        return composite;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PropertiesManagerPopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                UserPropertiesManagerDialog.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fTableViewer.getControl());
        this.fTableViewer.getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add(this.fActionDelete);
        manager.add(this.fActionRename);
    }

    private void createTableControl(Composite parent) {
        Composite tableComp = new Composite(parent, 2048);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)tableLayout);
        tableComp.setLayoutData((Object)new GridData(1808));
        this.fTableViewer = new TableViewer(tableComp, 0x10010002);
        this.fTableViewer.getControl().setLayoutData((Object)new GridData(1808));
        TableViewerEditor.create((TableViewer)this.fTableViewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.fTableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return super.isEditorActivationEvent(event) || event.eventType == 3;
            }
        }, (int)122);
        this.fTableViewer.getTable().setHeaderVisible(true);
        this.fTableViewer.getTable().setLinesVisible(true);
        TableViewerColumn columnOldKey = new TableViewerColumn(this.fTableViewer, 0, 0);
        columnOldKey.getColumn().setText(Messages.UserPropertiesManagerDialog_6);
        tableLayout.setColumnData((Widget)columnOldKey.getColumn(), (ColumnLayoutData)new ColumnWeightData(40, true));
        TableViewerColumn columnNewKey = new TableViewerColumn(this.fTableViewer, 0, 1);
        columnNewKey.getColumn().setText(Messages.UserPropertiesManagerDialog_7);
        tableLayout.setColumnData((Widget)columnNewKey.getColumn(), (ColumnLayoutData)new ColumnWeightData(40, true));
        columnNewKey.setEditingSupport((EditingSupport)new KeyEditingSupport((ColumnViewer)this.fTableViewer));
        TableViewerColumn columnUsedNumber = new TableViewerColumn(this.fTableViewer, 0, 2);
        columnUsedNumber.getColumn().setText("# " + Messages.UserPropertiesManagerDialog_8);
        tableLayout.setColumnData((Widget)columnUsedNumber.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, true));
        this.fTableViewer.setContentProvider((IContentProvider)new IIndexableLazyContentProvider(){
            List<String> keys;

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput != null) {
                    this.keys = new ArrayList<String>(UserPropertiesManagerDialog.this.fKeysMap.keySet());
                    Collections.sort(this.keys, (s1, s2) -> s1.compareToIgnoreCase((String)s2));
                    UserPropertiesManagerDialog.this.fTableViewer.setItemCount(this.keys.size());
                }
            }

            public void dispose() {
            }

            public void updateElement(int index) {
                UserPropertiesManagerDialog.this.fTableViewer.replace((Object)this.keys.get(index), index);
            }

            public int findElement(Object element) {
                return this.keys.indexOf(element);
            }
        });
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new LabelCellProvider());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                UserPropertiesManagerDialog.this.fActionDelete.setEnabled(!event.getSelection().isEmpty());
                UserPropertiesManagerDialog.this.fButtonDelete.setEnabled(!event.getSelection().isEmpty());
                UserPropertiesManagerDialog.this.fActionRename.setEnabled(!event.getSelection().isEmpty());
                UserPropertiesManagerDialog.this.fButtonRename.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.fTableViewer.setInput(this.fKeysMap);
    }

    private void createButtonPanel(Composite parent) {
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        client.setLayout((Layout)layout);
        GridData gd = new GridData(2);
        client.setLayoutData((Object)gd);
        this.fButtonDelete = new Button(client, 8);
        this.fButtonDelete.setText(Messages.UserPropertiesManagerDialog_9);
        gd = new GridData(768);
        this.fButtonDelete.setLayoutData((Object)gd);
        this.fButtonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserPropertiesManagerDialog.this.deleteSelectedPropertyKeys();
            }
        });
        this.fButtonDelete.setEnabled(false);
        this.fButtonRename = new Button(client, 8);
        this.fButtonRename.setText(Messages.UserPropertiesManagerDialog_10);
        gd = new GridData(768);
        this.fButtonRename.setLayoutData((Object)gd);
        this.fButtonRename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserPropertiesManagerDialog.this.renameSelectedPropertyKey();
            }
        });
        this.fButtonRename.setEnabled(false);
    }

    private void deleteSelectedPropertyKeys() {
        this.fTableViewer.applyEditorValue();
        for (Object o : ((IStructuredSelection)this.fTableViewer.getSelection()).toList()) {
            this.fKeysMap.remove(o);
        }
        this.fTableViewer.setInput(this.fKeysMap);
        this.fTableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        this.getButton(0).setEnabled(true);
    }

    private void renameSelectedPropertyKey() {
        Object selected = ((IStructuredSelection)this.fTableViewer.getSelection()).getFirstElement();
        if (selected != null) {
            this.fTableViewer.editElement(selected, 1);
        }
    }

    private void getAllUniquePropertyKeysForModel() {
        TreeIterator iter = this.fArchimateModel.eAllContents();
        while (iter.hasNext()) {
            IProperty p;
            String key;
            EObject element = (EObject)iter.next();
            if (!(element instanceof IProperty) || (key = (p = (IProperty)element).getKey()) == null) continue;
            if (this.fKeysMap.containsKey(key)) {
                ++this.fKeysMap.get((Object)key).usedTimes;
                continue;
            }
            this.fKeysMap.put(key, new KeyEntry(key));
        }
    }

    protected void okPressed() {
        super.okPressed();
        NonNotifyingCompoundCommand compoundCmd = new NonNotifyingCompoundCommand(Messages.UserPropertiesManagerDialog_11){

            @Override
            public void execute() {
                BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        this.doSuperExecute();
                    }
                });
            }

            @Override
            public void undo() {
                BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        this.doSuperUndo();
                    }
                });
            }

            @Override
            public void redo() {
                BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        this.doSuperRedo();
                    }
                });
            }

            void doSuperExecute() {
                super.execute();
            }

            void doSuperUndo() {
                super.undo();
            }

            void doSuperRedo() {
                super.redo();
            }
        };
        this.checkRenames(compoundCmd);
        this.checkDeletions(compoundCmd);
        CommandStack stack = (CommandStack)this.fArchimateModel.getAdapter(CommandStack.class);
        stack.execute(compoundCmd.unwrap());
    }

    private void checkDeletions(CompoundCommand compoundCmd) {
        TreeIterator iter = this.fArchimateModel.eAllContents();
        while (iter.hasNext()) {
            IProperty property;
            String key;
            EObject element = (EObject)iter.next();
            if (!(element instanceof IProperty) || (key = (property = (IProperty)element).getKey()) == null || this.fKeysMap.containsKey(key)) continue;
            DeletePropertyKeyCommand cmd = new DeletePropertyKeyCommand((EList<IProperty>)((IProperties)property.eContainer()).getProperties(), property);
            compoundCmd.add((Command)cmd);
        }
    }

    private void checkRenames(CompoundCommand compoundCmd) {
        for (Map.Entry<String, KeyEntry> entry : this.fKeysMap.entrySet()) {
            String newName;
            String oldName = entry.getKey();
            if (oldName.equals(newName = entry.getValue().newName)) continue;
            this.addKeyNameChangeCommands(compoundCmd, oldName, newName);
        }
    }

    private void addKeyNameChangeCommands(CompoundCommand compoundCmd, String oldName, String newName) {
        TreeIterator iter = this.fArchimateModel.eAllContents();
        while (iter.hasNext()) {
            IProperty property;
            String key;
            EObject element = (EObject)iter.next();
            if (!(element instanceof IProperty) || (key = (property = (IProperty)element).getKey()) == null || !key.equals(oldName)) continue;
            RenamePropertyKeyCommand cmd = new RenamePropertyKeyCommand(property, oldName, newName);
            compoundCmd.add((Command)cmd);
        }
    }

    @Override
    protected Point getDefaultDialogSize() {
        return new Point(500, 350);
    }

    private static class DeletePropertyKeyCommand
    extends Command {
        private EList<IProperty> properties;
        private IProperty property;
        private int index;

        DeletePropertyKeyCommand(EList<IProperty> properties, IProperty property) {
            this.properties = properties;
            this.property = property;
            this.setLabel(Messages.UserPropertiesManagerDialog_13);
        }

        public void execute() {
            this.index = this.properties.indexOf((Object)this.property);
            if (this.index != -1) {
                this.properties.remove((Object)this.property);
            }
        }

        public void undo() {
            if (this.index != -1) {
                this.properties.add(this.index, (Object)this.property);
            }
        }

        public void dispose() {
            this.properties = null;
            this.property = null;
        }
    }

    private class KeyEditingSupport
    extends EditingSupport {
        TextCellEditor cellEditor;

        public KeyEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.cellEditor = new TextCellEditor((Composite)viewer.getControl());
            UIUtils.applyNewlineFilter(this.cellEditor.getControl());
            UIUtils.applyInvalidCharacterFilter(this.cellEditor.getControl());
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            String key = (String)element;
            return UserPropertiesManagerDialog.this.fKeysMap.get((Object)key).newName;
        }

        protected void setValue(Object element, Object value) {
            String key = (String)element;
            KeyEntry entry = UserPropertiesManagerDialog.this.fKeysMap.get(key);
            String newValue = (String)value;
            if (entry != null && !Objects.equals(newValue, entry.newName)) {
                entry.newName = newValue;
                UserPropertiesManagerDialog.this.fTableViewer.update((Object)key, null);
                UserPropertiesManagerDialog.this.getButton(0).setEnabled(true);
            }
        }
    }

    private static class KeyEntry {
        String newName;
        int usedTimes = 1;

        KeyEntry(String name) {
            this.newName = name;
        }
    }

    private class LabelCellProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private LabelCellProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String key = (String)element;
            switch (columnIndex) {
                case 0: {
                    return key;
                }
                case 1: {
                    return UserPropertiesManagerDialog.this.fKeysMap.get((Object)key).newName;
                }
                case 2: {
                    return "" + UserPropertiesManagerDialog.this.fKeysMap.get((Object)key).usedTimes;
                }
            }
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            if (columnIndex == 1) {
                String key = (String)element;
                KeyEntry entry = UserPropertiesManagerDialog.this.fKeysMap.get(key);
                if (!key.equals(entry.newName)) {
                    return ColorConstants.red;
                }
            }
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }
    }

    private static class RenamePropertyKeyCommand
    extends Command {
        private IProperty property;
        private String oldName;
        private String newName;

        RenamePropertyKeyCommand(IProperty property, String oldName, String newName) {
            this.property = property;
            this.oldName = oldName;
            this.newName = newName;
            this.setLabel(Messages.UserPropertiesManagerDialog_12);
        }

        public void execute() {
            this.property.setKey(this.newName);
        }

        public void undo() {
            this.property.setKey(this.oldName);
        }

        public void dispose() {
            this.property = null;
        }
    }
}

