/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.propertysections;

import com.archimatetool.editor.model.commands.EObjectFeatureCommand;
import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.editor.propertysections.IObjectFilter;
import com.archimatetool.editor.propertysections.Messages;
import com.archimatetool.editor.propertysections.ObjectFilter;
import com.archimatetool.model.IArchimateDiagramModel;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModelReference;
import com.archimatetool.model.viewpoints.IViewpoint;
import com.archimatetool.model.viewpoints.ViewpointManager;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class ViewpointSection
extends AbstractECorePropertySection {
    private static final String HELP_ID = "com.archimatetool.help.diagramModelSection";
    private ComboViewer fComboViewer;
    private boolean fIsRefreshing;

    @Override
    protected void createControls(Composite parent) {
        this.createLabel(parent, Messages.ViewpointSection_0, 115, 0x1000000);
        this.fComboViewer = new ComboViewer(new Combo(parent, 2056));
        this.fComboViewer.getCombo().setVisibleItemCount(12);
        this.fComboViewer.getControl().setLayoutData((Object)new GridData(768));
        this.getWidgetFactory().adapt(this.fComboViewer.getControl(), true, true);
        this.fComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (ViewpointSection.this.fIsRefreshing) {
                    return;
                }
                IViewpoint viewPoint = (IViewpoint)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (viewPoint != null) {
                    CompoundCommand result = new CompoundCommand();
                    for (EObject eObject : ViewpointSection.this.getEObjects()) {
                        EObjectFeatureCommand cmd;
                        if (!ViewpointSection.this.isAlive(eObject) || !(cmd = new EObjectFeatureCommand(Messages.ViewpointSection_1, eObject, (EStructuralFeature)IArchimatePackage.Literals.ARCHIMATE_DIAGRAM_MODEL__VIEWPOINT, viewPoint.getID())).canExecute()) continue;
                        result.add((Command)cmd);
                    }
                    ViewpointSection.this.executeCommand(result.unwrap());
                }
            }
        });
        this.fComboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ViewpointManager.INSTANCE.getAllViewpoints().toArray();
            }
        });
        this.fComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IViewpoint)element).getName();
            }
        });
        this.fComboViewer.setInput((Object)"");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
    }

    @Override
    protected void notifyChanged(Notification msg) {
        Object feature = msg.getFeature();
        if (feature == IArchimatePackage.Literals.ARCHIMATE_DIAGRAM_MODEL__VIEWPOINT) {
            this.update();
        }
    }

    @Override
    protected void update() {
        if (this.fIsExecutingCommand) {
            return;
        }
        String id = ((IArchimateDiagramModel)this.getFirstSelectedObject()).getViewpoint();
        IViewpoint viewPoint = ViewpointManager.INSTANCE.getViewpoint(id);
        this.fIsRefreshing = true;
        this.fComboViewer.setSelection((ISelection)new StructuredSelection((Object)viewPoint));
        this.fIsRefreshing = false;
    }

    @Override
    protected IObjectFilter getFilter() {
        return new Filter();
    }

    public static class Filter
    extends ObjectFilter {
        @Override
        public boolean select(Object object) {
            if (object instanceof IAdaptable && ((IAdaptable)object).getAdapter(IDiagramModelReference.class) != null) {
                return false;
            }
            return super.select(object);
        }

        @Override
        public boolean isRequiredType(Object object) {
            return object instanceof IArchimateDiagramModel;
        }

        @Override
        public Class<?> getAdaptableType() {
            return IArchimateDiagramModel.class;
        }
    }
}

