/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.tools;

import com.archimatetool.editor.diagram.ArchimateDiagramModelFactory;
import com.archimatetool.editor.tools.GenerateViewDialog;
import com.archimatetool.editor.tools.Messages;
import com.archimatetool.editor.ui.services.EditorManager;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateDiagramModel;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateFactory;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IConnectable;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelArchimateConnection;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IFolder;
import com.archimatetool.model.viewpoints.IViewpoint;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Shell;

public class GenerateViewCommand
extends Command {
    private List<IArchimateElement> fSelectedElements;
    private List<IArchimateElement> fAddedElements;
    private IFolder fParentFolder;
    private IArchimateDiagramModel fDiagramModel;
    private IViewpoint fViewpoint;
    private boolean fAddAllConnections;
    private String fViewName;

    public GenerateViewCommand(List<IArchimateElement> selectedElements) {
        this.setLabel(Messages.GenerateViewCommand_0);
        this.fSelectedElements = selectedElements;
    }

    public void execute() {
        this.fDiagramModel = this.createDiagramModel();
        EditorManager.openDiagramEditor((IDiagramModel)this.fDiagramModel);
    }

    public void undo() {
        EditorManager.closeDiagramEditor((IDiagramModel)this.fDiagramModel);
        this.fParentFolder.getElements().remove((Object)this.fDiagramModel);
    }

    public void redo() {
        this.fParentFolder.getElements().add((Object)this.fDiagramModel);
        EditorManager.openDiagramEditor((IDiagramModel)this.fDiagramModel);
    }

    public boolean openDialog(Shell parentShell) {
        GenerateViewDialog dialog = new GenerateViewDialog(parentShell, this.fSelectedElements);
        if (dialog.open() == 0) {
            this.fViewpoint = dialog.getSelectedViewpoint();
            this.fAddAllConnections = dialog.isAddAllConnections();
            this.fViewName = dialog.getViewName();
            return true;
        }
        return false;
    }

    private IArchimateDiagramModel createDiagramModel() {
        IDiagramModelArchimateConnection newConnection;
        IArchimateDiagramModel dm = IArchimateFactory.eINSTANCE.createArchimateDiagramModel();
        dm.setName(this.fViewName);
        dm.setViewpoint(this.fViewpoint.getID());
        this.fParentFolder = this.fSelectedElements.get(0).getArchimateModel().getDefaultFolderForObject((EObject)dm);
        this.fParentFolder.getElements().add((Object)dm);
        int x = 20;
        int y = 20;
        this.getElementsToAdd();
        for (IArchimateElement element : this.fSelectedElements) {
            this.createDiagramNode(element, dm, x, y);
            y += 100;
        }
        x = 170;
        y = 20;
        for (IArchimateElement element : this.fAddedElements) {
            if (this.fSelectedElements.contains(element)) continue;
            this.createDiagramNode(element, dm, x, y);
            if ((y += 80) <= 700) continue;
            y = 20;
            x += 150;
        }
        for (IDiagramModelObject dmoSource : dm.getChildren()) {
            IArchimateElement elementSource = ((IDiagramModelArchimateObject)dmoSource).getArchimateElement();
            for (IArchimateRelationship relation : List.copyOf(elementSource.getSourceRelationships())) {
                for (IDiagramModelObject dmoTarget : dm.getChildren()) {
                    IArchimateElement elementTarget = ((IDiagramModelArchimateObject)dmoTarget).getArchimateElement();
                    if (!this.fAddAllConnections && !this.fSelectedElements.contains(elementSource) && !this.fSelectedElements.contains(elementTarget) || relation.getTarget() != elementTarget) continue;
                    newConnection = ArchimateDiagramModelFactory.createDiagramModelArchimateConnection(relation);
                    newConnection.connect((IConnectable)dmoSource, (IConnectable)dmoTarget);
                }
            }
        }
        TreeIterator iter1 = dm.eAllContents();
        while (iter1.hasNext()) {
            EObject eObject1 = (EObject)iter1.next();
            if (!(eObject1 instanceof IDiagramModelArchimateConnection)) continue;
            IDiagramModelArchimateConnection connection = (IDiagramModelArchimateConnection)eObject1;
            for (IDiagramModelObject dmo : dm.getChildren()) {
                IArchimateElement element = ((IDiagramModelArchimateObject)dmo).getArchimateElement();
                for (IArchimateRelationship relation : List.copyOf(connection.getArchimateRelationship().getSourceRelationships())) {
                    if (relation.getTarget() != element) continue;
                    newConnection = ArchimateDiagramModelFactory.createDiagramModelArchimateConnection(relation);
                    newConnection.connect((IConnectable)connection, (IConnectable)dmo);
                }
                for (IArchimateRelationship relation : List.copyOf(connection.getArchimateRelationship().getTargetRelationships())) {
                    if (relation.getSource() != element) continue;
                    newConnection = ArchimateDiagramModelFactory.createDiagramModelArchimateConnection(relation);
                    newConnection.connect((IConnectable)dmo, (IConnectable)connection);
                }
            }
        }
        return dm;
    }

    private void createDiagramNode(IArchimateElement element, IArchimateDiagramModel dm, int x, int y) {
        IDiagramModelArchimateObject dmo = ArchimateDiagramModelFactory.createDiagramModelArchimateObject(element);
        dm.getChildren().add((Object)dmo);
        dmo.getBounds().setLocation(x, y);
    }

    private void getElementsToAdd() {
        this.fAddedElements = new ArrayList<IArchimateElement>();
        for (IArchimateElement element : this.fSelectedElements) {
            this.addElement((IArchimateConcept)element);
            for (IArchimateRelationship relation : element.getSourceRelationships()) {
                this.addElement(relation.getTarget());
            }
            for (IArchimateRelationship relation : element.getTargetRelationships()) {
                this.addElement(relation.getSource());
            }
        }
    }

    private void addElement(IArchimateConcept concept) {
        if (concept instanceof IArchimateElement) {
            if (this.fViewpoint.isAllowedConcept(concept.eClass()) && !this.fAddedElements.contains(concept)) {
                this.fAddedElements.add((IArchimateElement)concept);
            }
        } else if (concept instanceof IArchimateRelationship) {
            IArchimateConcept target;
            IArchimateConcept source = ((IArchimateRelationship)concept).getSource();
            if (source instanceof IArchimateElement) {
                this.addElement(source);
            }
            if ((target = ((IArchimateRelationship)concept).getTarget()) instanceof IArchimateElement) {
                this.addElement(target);
            }
        }
    }
}

