/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.tools;

import com.archimatetool.editor.Logger;
import com.archimatetool.editor.model.IArchiveManager;
import com.archimatetool.editor.model.commands.AddListMemberCommand;
import com.archimatetool.editor.model.commands.RemoveListMemberCommand;
import com.archimatetool.editor.propertysections.ImageManagerDialog;
import com.archimatetool.editor.tools.Messages;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.ImageFactory;
import com.archimatetool.editor.ui.UIUtils;
import com.archimatetool.editor.ui.components.ExtendedTitleAreaDialog;
import com.archimatetool.model.IArchimateFactory;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IProfile;
import com.archimatetool.model.IProfiles;
import com.archimatetool.model.util.ArchimateModelUtils;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class ProfilesManagerDialog
extends ExtendedTitleAreaDialog {
    private static String HELP_ID = "com.archimatetool.help.ProfilesManagerDialog";
    private static final int IMAGE_SIZE = 100;
    private IArchimateModel fArchimateModel;
    private List<IProfile> fProfilesCopy;
    private Map<String, List<IProfiles>> fProfilesUsage;
    private TableViewer fTableViewer;
    private Button fButtonNew;
    private Button fButtonDelete;
    private IAction fActionNew;
    private IAction fActionDelete;
    private IAction fActionChooseImage;
    private IAction fActionClearImage;
    private Button fImageButton;
    private Canvas fImagePreview;
    private Image fPreviewImage;
    private EClass fDefaultClass = IArchimatePackage.eINSTANCE.getBusinessActor();

    public ProfilesManagerDialog(Shell parentShell, IArchimateModel model) {
        super(parentShell, "ProfilesManagerDialog");
        this.setTitleImage(IArchiImages.ImageFactory.getImage("img/new_wiz.png"));
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fArchimateModel = model;
        this.fProfilesCopy = new ArrayList<IProfile>();
        for (IProfile profile : model.getProfiles()) {
            this.fProfilesCopy.add((IProfile)EcoreUtil.copy((EObject)profile));
        }
        this.sortProfiles();
        this.fProfilesUsage = new HashMap<String, List<IProfiles>>();
        for (Map.Entry entry : ArchimateModelUtils.findProfilesUsage((IArchimateModel)model).entrySet()) {
            this.fProfilesUsage.put(((IProfile)entry.getKey()).getId(), (List)entry.getValue());
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.ProfilesManagerDialog_0);
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
        this.setTitle(Messages.ProfilesManagerDialog_1);
        this.setMessage(NLS.bind((String)Messages.ProfilesManagerDialog_2, (Object)ArchiLabelProvider.INSTANCE.getLabel(this.fArchimateModel)));
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite client = new Composite(composite, 0);
        client.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.create((int)1808).applyTo((Control)client);
        this.fActionNew = new Action(Messages.ProfilesManagerDialog_3){

            public void run() {
                ProfilesManagerDialog.this.createNewProfile();
            }

            public String getToolTipText() {
                return this.getText();
            }
        };
        this.fActionDelete = new Action(Messages.ProfilesManagerDialog_4){

            public void run() {
                ProfilesManagerDialog.this.deleteSelectedProfiles();
            }

            public String getToolTipText() {
                return this.getText();
            }

            public ImageDescriptor getImageDescriptor() {
                return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE");
            }
        };
        this.fActionDelete.setEnabled(false);
        this.fActionChooseImage = new Action(Messages.ProfilesManagerDialog_5){

            public void run() {
                ProfilesManagerDialog.this.chooseImage();
            }
        };
        this.fActionChooseImage.setEnabled(false);
        this.fActionClearImage = new Action(Messages.ProfilesManagerDialog_6){

            public void run() {
                ProfilesManagerDialog.this.clearImages();
            }
        };
        this.fActionClearImage.setEnabled(false);
        this.createTableControl(client);
        this.createButtonPanel(client);
        MenuManager menuManager = new MenuManager("#ProfileManagerContextMenu");
        menuManager.add(this.fActionNew);
        menuManager.add(this.fActionDelete);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add(this.fActionChooseImage);
        menuManager.add(this.fActionClearImage);
        Menu menu = menuManager.createContextMenu(this.fTableViewer.getControl());
        this.fTableViewer.getControl().setMenu(menu);
        return composite;
    }

    private void createTableControl(Composite parent) {
        Composite tableComp = new Composite(parent, 2048);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)tableLayout);
        GridDataFactory.create((int)1808).applyTo((Control)tableComp);
        this.fTableViewer = new TableViewer(tableComp, 65538);
        GridDataFactory.create((int)1808).applyTo(this.fTableViewer.getControl());
        TableViewerEditor.create((TableViewer)this.fTableViewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.fTableViewer), (int)122);
        this.fTableViewer.getTable().setHeaderVisible(true);
        this.fTableViewer.getTable().setLinesVisible(true);
        TableViewerColumn columnIcon = new TableViewerColumn(this.fTableViewer, 0, 0);
        tableLayout.setColumnData((Widget)columnIcon.getColumn(), (ColumnLayoutData)new ColumnWeightData(5, true));
        TableViewerColumn columnName = new TableViewerColumn(this.fTableViewer, 0, 1);
        columnName.getColumn().setText(Messages.ProfilesManagerDialog_7);
        tableLayout.setColumnData((Widget)columnName.getColumn(), (ColumnLayoutData)new ColumnWeightData(50, true));
        columnName.setEditingSupport((EditingSupport)new NameEditingSupport((ColumnViewer)this.fTableViewer));
        this.fTableViewer.getTable().setSortColumn(columnName.getColumn());
        this.fTableViewer.getTable().setSortDirection(128);
        columnName.getColumn().addListener(13, event -> {
            this.sortProfiles();
            this.fTableViewer.refresh();
        });
        TableViewerColumn columnConceptType = new TableViewerColumn(this.fTableViewer, 0, 2);
        columnConceptType.getColumn().setText(Messages.ProfilesManagerDialog_8);
        tableLayout.setColumnData((Widget)columnConceptType.getColumn(), (ColumnLayoutData)new ColumnWeightData(35, true));
        columnConceptType.setEditingSupport((EditingSupport)new ConceptTypeEditingSupport((ColumnViewer)this.fTableViewer));
        TableViewerColumn columnUsage = new TableViewerColumn(this.fTableViewer, 0, 3);
        columnUsage.getColumn().setText(Messages.ProfilesManagerDialog_9);
        tableLayout.setColumnData((Widget)columnUsage.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, true));
        this.fTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ProfilesManagerDialog.this.fProfilesCopy.toArray();
            }
        });
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new LabelCellProvider());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = event.getStructuredSelection();
                boolean enabled = !selection.isEmpty();
                ProfilesManagerDialog.this.fActionDelete.setEnabled(enabled);
                ProfilesManagerDialog.this.fButtonDelete.setEnabled(enabled);
                ProfilesManagerDialog.this.fActionChooseImage.setEnabled(enabled);
                ProfilesManagerDialog.this.fActionClearImage.setEnabled(false);
                for (Object o : selection) {
                    IProfile profile = (IProfile)o;
                    if (!ProfilesManagerDialog.this.canHaveImage(profile)) {
                        ProfilesManagerDialog.this.fActionChooseImage.setEnabled(false);
                    }
                    if (profile.getImagePath() == null) continue;
                    ProfilesManagerDialog.this.fActionClearImage.setEnabled(true);
                }
                ProfilesManagerDialog.this.fImageButton.setEnabled(ProfilesManagerDialog.this.fActionChooseImage.isEnabled() || ProfilesManagerDialog.this.fActionClearImage.isEnabled());
                ProfilesManagerDialog.this.updateImagePreview();
            }
        });
        this.fTableViewer.getTable().addListener(8, e -> {
            Point pt = new Point(e.x, e.y);
            TableItem item = this.fTableViewer.getTable().getItem(pt);
            if (item == null) {
                this.createNewProfile();
            }
        });
        this.fTableViewer.setInput((Object)"");
    }

    public void setDefaultClass(EClass eClass) {
        this.fDefaultClass = eClass;
    }

    private void createButtonPanel(Composite parent) {
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        client.setLayout((Layout)layout);
        GridDataFactory.create((int)2).applyTo((Control)client);
        this.fButtonNew = new Button(client, 8);
        this.fButtonNew.setText(Messages.ProfilesManagerDialog_10);
        GridDataFactory.create((int)768).applyTo((Control)this.fButtonNew);
        this.fButtonNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfilesManagerDialog.this.createNewProfile();
            }
        });
        this.fButtonDelete = new Button(client, 8);
        this.fButtonDelete.setText(Messages.ProfilesManagerDialog_11);
        this.fButtonDelete.setEnabled(false);
        GridDataFactory.create((int)768).applyTo((Control)this.fButtonDelete);
        this.fButtonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfilesManagerDialog.this.deleteSelectedProfiles();
            }
        });
        this.fImageButton = new Button(client, 8);
        this.fImageButton.setText(Messages.ProfilesManagerDialog_12);
        this.fImageButton.setEnabled(false);
        GridDataFactory.create((int)768).applyTo((Control)this.fImageButton);
        MenuManager menuManager = new MenuManager();
        menuManager.add(this.fActionChooseImage);
        menuManager.add(this.fActionClearImage);
        final Menu menu = menuManager.createContextMenu((Control)this.fImageButton.getShell());
        this.fImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle buttonBounds = ProfilesManagerDialog.this.fImageButton.getBounds();
                menu.setLocation(ProfilesManagerDialog.this.fImageButton.getParent().toDisplay(buttonBounds.x - 0, buttonBounds.y + buttonBounds.height));
                menu.setVisible(true);
            }
        });
        this.fImagePreview = new Canvas(client, 2048);
        GridDataFactory.create((int)0).hint(100, 100).applyTo((Control)this.fImagePreview);
        this.fImagePreview.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ProfilesManagerDialog.this.fPreviewImage != null) {
                    e.gc.setAntialias(1);
                    e.gc.setInterpolation(2);
                    Rectangle imageBounds = ProfilesManagerDialog.this.fPreviewImage.getBounds();
                    Rectangle newSize = ImageFactory.getScaledImageSize(ProfilesManagerDialog.this.fPreviewImage, 100);
                    int x = (100 - newSize.width) / 2;
                    int y = (100 - newSize.height) / 2;
                    e.gc.drawImage(ProfilesManagerDialog.this.fPreviewImage, 0, 0, imageBounds.width, imageBounds.height, x, y, newSize.width, newSize.height);
                }
            }
        });
        this.fImagePreview.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                if (ProfilesManagerDialog.this.fActionChooseImage.isEnabled()) {
                    ProfilesManagerDialog.this.chooseImage();
                }
            }
        });
        this.fImagePreview.addDisposeListener(e -> this.disposePreviewImage());
    }

    private void createNewProfile() {
        IProfile profile = IArchimateFactory.eINSTANCE.createProfile();
        profile.setConceptType(this.fDefaultClass.getName());
        profile.setName(this.generateNewProfileName(profile.getConceptType()));
        this.fProfilesCopy.add(profile);
        this.fTableViewer.refresh();
        this.fTableViewer.editElement((Object)profile, 1);
    }

    private String generateNewProfileName(String conceptType) {
        String s;
        String name = Messages.ProfilesManagerDialog_13 + " ";
        int newNameIndex = 1;
        while (!this.isValidProfileNameAndType(s = name + newNameIndex++, conceptType)) {
        }
        return s;
    }

    private void deleteSelectedProfiles() {
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.ProfilesManagerDialog_14, (String)Messages.ProfilesManagerDialog_15)) {
            for (Object profile : ((IStructuredSelection)this.fTableViewer.getSelection()).toList()) {
                this.fProfilesCopy.remove(profile);
            }
            this.fTableViewer.refresh();
        }
    }

    private void sortProfiles() {
        Collator collator = Collator.getInstance();
        this.fProfilesCopy.sort((p1, p2) -> collator.compare(p1.getName(), p2.getName()));
    }

    private void updateImagePreview() {
        this.disposePreviewImage();
        IProfile profile = (IProfile)this.fTableViewer.getStructuredSelection().getFirstElement();
        if (profile != null && profile.getImagePath() != null) {
            IArchiveManager archiveManager = (IArchiveManager)this.fArchimateModel.getAdapter(IArchiveManager.class);
            try {
                this.fPreviewImage = archiveManager.createImage(profile.getImagePath());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Logger.logError("Could not create image!", ex);
            }
        }
        this.fImagePreview.redraw();
    }

    private void chooseImage() {
        IStructuredSelection selection = this.fTableViewer.getStructuredSelection();
        if (!selection.isEmpty()) {
            IProfile firstSelected = (IProfile)selection.getFirstElement();
            ImageManagerDialog dialog = new ImageManagerDialog(this.getParentShell());
            dialog.setSelected(this.fArchimateModel, firstSelected.getImagePath());
            if (dialog.open() == 0) {
                try {
                    IArchiveManager archiveManager = (IArchiveManager)this.fArchimateModel.getAdapter(IArchiveManager.class);
                    String path = null;
                    if (dialog.getUserSelectedFile() != null && dialog.getUserSelectedFile().exists()) {
                        path = archiveManager.addImageFromFile(dialog.getUserSelectedFile());
                    } else if (dialog.getUserSelectedImagePath() != null) {
                        if (dialog.getUserSelectedModel() != this.fArchimateModel) {
                            IArchiveManager selectedArchiveManager = (IArchiveManager)dialog.getUserSelectedModel().getAdapter(IArchiveManager.class);
                            path = archiveManager.copyImageBytes(selectedArchiveManager, dialog.getUserSelectedImagePath());
                        } else {
                            path = dialog.getUserSelectedImagePath();
                        }
                    }
                    if (path != null) {
                        for (Object o : selection.toList()) {
                            IProfile profile = (IProfile)o;
                            if (!this.canHaveImage(profile)) continue;
                            profile.setImagePath(path);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Logger.logError("Could not create image!", ex);
                }
                this.fTableViewer.setSelection((ISelection)selection);
            }
        }
    }

    private void clearImages() {
        IStructuredSelection selection = this.fTableViewer.getStructuredSelection();
        for (Object o : selection.toList()) {
            ((IProfile)o).setImagePath(null);
        }
        this.fTableViewer.setSelection((ISelection)selection);
    }

    private void disposePreviewImage() {
        if (this.fPreviewImage != null) {
            this.fPreviewImage.dispose();
            this.fPreviewImage = null;
        }
    }

    private boolean isValidProfileNameAndType(String name, String conceptType) {
        return !name.isBlank() && !ArchimateModelUtils.hasProfileByNameAndType(this.fProfilesCopy, (String)name, (String)conceptType);
    }

    private boolean canHaveImage(IProfile profile) {
        EClass eClass = profile.getConceptClass();
        return !IArchimatePackage.eINSTANCE.getArchimateRelationship().isSuperTypeOf(eClass) && !IArchimatePackage.eINSTANCE.getJunction().isSuperTypeOf(eClass);
    }

    @Override
    protected Point getDefaultDialogSize() {
        return new Point(800, 450);
    }

    protected void okPressed() {
        super.okPressed();
        HashMap<String, IProfile> modelProfilesMap = new HashMap<String, IProfile>();
        for (IProfile profile : this.fArchimateModel.getProfiles()) {
            modelProfilesMap.put(profile.getId(), profile);
        }
        HashMap<String, IProfile> copyProfilesMap = new HashMap<String, IProfile>();
        for (IProfile profile : this.fProfilesCopy) {
            copyProfilesMap.put(profile.getId(), profile);
        }
        CompoundCommand compoundCmd = new CompoundCommand(Messages.ProfilesManagerDialog_16);
        for (IProfile profile : this.fProfilesCopy) {
            if (modelProfilesMap.containsKey(profile.getId())) {
                IProfile profileOriginal = (IProfile)modelProfilesMap.get(profile.getId());
                if (EcoreUtil.equals((EObject)profileOriginal, (EObject)profile)) continue;
                List<IProfiles> usages = this.fProfilesUsage.get(profileOriginal.getId());
                compoundCmd.add((Command)new ChangeProfileCommand(profileOriginal, profile, usages));
                continue;
            }
            compoundCmd.add(new AddListMemberCommand<IProfile>((List<IProfile>)this.fArchimateModel.getProfiles(), profile));
        }
        for (IProfile profile : modelProfilesMap.values()) {
            if (copyProfilesMap.containsKey(profile.getId())) continue;
            List<IProfiles> usages = this.fProfilesUsage.get(profile.getId());
            compoundCmd.add((Command)new DeleteProfileCommand(profile, usages));
        }
        CommandStack stack = (CommandStack)this.fArchimateModel.getAdapter(CommandStack.class);
        stack.execute((Command)compoundCmd);
    }

    private static class ChangeProfileCommand
    extends Command {
        IProfile profileOriginal;
        IProfile profileChanged;
        List<IProfiles> usages;

        ChangeProfileCommand(IProfile profileOriginal, IProfile profileChanged, List<IProfiles> usages) {
            this.profileOriginal = profileOriginal;
            this.profileChanged = profileChanged;
            this.usages = usages;
        }

        public void execute() {
            this.replace(this.profileOriginal, this.profileChanged);
        }

        public void undo() {
            this.replace(this.profileChanged, this.profileOriginal);
        }

        private void replace(IProfile oldProfile, IProfile newProfile) {
            EcoreUtil.replace((EObject)oldProfile, (EObject)newProfile);
            if (this.usages != null) {
                for (IProfiles profilesObject : this.usages) {
                    EcoreUtil.replace((EObject)profilesObject, (EStructuralFeature)IArchimatePackage.Literals.PROFILES__PROFILES, (Object)oldProfile, (Object)newProfile);
                }
            }
        }

        public void dispose() {
            this.profileOriginal = null;
            this.profileChanged = null;
            this.usages = null;
        }
    }

    private class ConceptTypeEditingSupport
    extends EditingSupport {
        ComboBoxViewerCellEditor cellEditor;

        ConceptTypeEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected CellEditor getCellEditor(Object element) {
            if (this.cellEditor == null) {
                EClass eClass;
                final ArrayList<EClass> classList = new ArrayList<EClass>();
                EClass[] eClassArray = ArchimateModelUtils.getAllArchimateClasses();
                int n = eClassArray.length;
                int n2 = 0;
                while (n2 < n) {
                    eClass = eClassArray[n2];
                    classList.add(eClass);
                    ++n2;
                }
                eClassArray = ArchimateModelUtils.getRelationsClasses();
                n = eClassArray.length;
                n2 = 0;
                while (n2 < n) {
                    eClass = eClassArray[n2];
                    classList.add(eClass);
                    ++n2;
                }
                eClassArray = ArchimateModelUtils.getConnectorClasses();
                n = eClassArray.length;
                n2 = 0;
                while (n2 < n) {
                    eClass = eClassArray[n2];
                    classList.add(eClass);
                    ++n2;
                }
                this.cellEditor = new ComboBoxViewerCellEditor((Composite)this.getViewer().getControl(), 8);
                this.cellEditor.setContentProvider(new IStructuredContentProvider(){

                    public Object[] getElements(Object inputElement) {
                        return classList.toArray();
                    }
                });
                this.cellEditor.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        return ArchiLabelProvider.INSTANCE.getDefaultName((EClass)element);
                    }
                });
                this.cellEditor.getViewer().setComparator(new ViewerComparator(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        return ArchiLabelProvider.INSTANCE.getDefaultName((EClass)e1).compareToIgnoreCase(ArchiLabelProvider.INSTANCE.getDefaultName((EClass)e2));
                    }
                });
                this.cellEditor.setInput(classList);
                this.cellEditor.setActivationStyle(9);
            }
            return this.cellEditor;
        }

        protected boolean canEdit(Object element) {
            IProfile profile = (IProfile)element;
            return !ProfilesManagerDialog.this.fProfilesUsage.containsKey(profile.getId());
        }

        protected Object getValue(Object element) {
            IProfile profile = (IProfile)element;
            return profile.getConceptClass();
        }

        protected void setValue(Object element, Object value) {
            if (value == null) {
                return;
            }
            IProfile profile = (IProfile)element;
            EClass eClass = (EClass)value;
            if (ProfilesManagerDialog.this.isValidProfileNameAndType(profile.getName(), eClass.getName())) {
                profile.setConceptType(eClass.getName());
                this.getViewer().update((Object)profile, null);
                if (!ProfilesManagerDialog.this.canHaveImage(profile)) {
                    profile.setImagePath(null);
                    this.getViewer().setSelection((ISelection)new StructuredSelection((Object)profile));
                }
            }
        }
    }

    private static class DeleteProfileCommand
    extends CompoundCommand {
        DeleteProfileCommand(IProfile profile, List<IProfiles> usages) {
            this.add(new RemoveListMemberCommand<IProfile>((List<IProfile>)profile.getArchimateModel().getProfiles(), profile));
            if (usages != null) {
                for (IProfiles owner : usages) {
                    this.add(new RemoveListMemberCommand<IProfile>((List<IProfile>)owner.getProfiles(), profile));
                }
            }
        }
    }

    private class LabelCellProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private LabelCellProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            IProfile profile = (IProfile)element;
            if (columnIndex == 0) {
                return ArchiLabelProvider.INSTANCE.getImage(profile.getConceptClass());
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IProfile profile = (IProfile)element;
            switch (columnIndex) {
                case 1: {
                    return profile.getName();
                }
                case 2: {
                    return ArchiLabelProvider.INSTANCE.getDefaultName(profile.getConceptClass());
                }
                case 3: {
                    return this.getInstanceCount(profile);
                }
            }
            return null;
        }

        private String getInstanceCount(IProfile profile) {
            List<IProfiles> usage = ProfilesManagerDialog.this.fProfilesUsage.get(profile.getId());
            return usage == null ? "" : String.valueOf(usage.size());
        }
    }

    private class NameEditingSupport
    extends EditingSupport {
        TextCellEditor cellEditor;

        NameEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.cellEditor = new TextCellEditor((Composite)viewer.getControl());
            UIUtils.applyNewlineFilter(this.cellEditor.getControl());
            UIUtils.applyInvalidCharacterFilter(this.cellEditor.getControl());
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return ((IProfile)element).getName();
        }

        protected void setValue(Object element, Object value) {
            IProfile profile = (IProfile)element;
            String name = (String)value;
            if (profile.getName().equalsIgnoreCase(name) || ProfilesManagerDialog.this.isValidProfileNameAndType(name, profile.getConceptType())) {
                profile.setName((String)value);
                ProfilesManagerDialog.this.fTableViewer.update(element, null);
            }
        }
    }
}

