/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public class ClipboardImageTransfer
extends ByteArrayTransfer {
    static final String IMAGE_PNG = "image/png";
    static final String IMAGE_BMP = "image/bmp";
    static final int PNG_ID = ClipboardImageTransfer.registerType((String)"image/png");
    static final int BMP_ID = ClipboardImageTransfer.registerType((String)"image/bmp");
    static ClipboardImageTransfer PNGTransfer = new ClipboardImageTransfer("image/png", PNG_ID, 5);
    static ClipboardImageTransfer BMPTransfer = new ClipboardImageTransfer("image/bmp", BMP_ID, 0);
    private String typeName;
    private int type;
    private int swtType;

    public static void copyImageDataToClipboard(ImageData imageData) {
        Clipboard cb = new Clipboard(null);
        try {
            cb.setContents(new Object[]{imageData}, new Transfer[]{ImageTransfer.getInstance()});
        }
        finally {
            cb.dispose();
        }
    }

    private ClipboardImageTransfer(String typeName, int type, int swtType) {
        this.typeName = typeName;
        this.type = type;
        this.swtType = swtType;
    }

    protected String[] getTypeNames() {
        return new String[]{this.typeName};
    }

    protected int[] getTypeIds() {
        return new int[]{this.type};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        if (object == null || !(object instanceof ImageData)) {
            return;
        }
        if (this.isSupportedType(transferData)) {
            ImageData imageData = (ImageData)object;
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    ImageLoader imgLoader = new ImageLoader();
                    imgLoader.data = new ImageData[]{imageData};
                    imgLoader.save((OutputStream)out, this.swtType);
                    super.javaToNative((Object)out.toByteArray(), transferData);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        if (this.isSupportedType(transferData)) {
            byte[] buffer = (byte[])super.nativeToJava(transferData);
            if (buffer == null) {
                return null;
            }
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (ByteArrayInputStream in = new ByteArrayInputStream(buffer);){
                    return new ImageData((InputStream)in);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return null;
    }
}

