/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.utils.PlatformUtils;
import com.archimatetool.editor.utils.StringUtils;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public final class FontFactory {
    private static final String DEFAULT_VIEW_FONT_NAME = "defaultViewFont";
    private static FontRegistry FontRegistry = new FontRegistry();
    public static Font SystemFontBold = JFaceResources.getFontRegistry().getBold("");
    public static Font SystemFontItalic = JFaceResources.getFontRegistry().getItalic("");

    public static Font get(String fontName) {
        if (fontName == null) {
            return FontFactory.getDefaultUserViewFont();
        }
        if (!FontRegistry.hasValueFor(fontName)) {
            try {
                FontData fd = new FontData(fontName);
                FontRegistry.put(fontName, new FontData[]{fd});
            }
            catch (Exception exception) {
                return FontFactory.getDefaultUserViewFont();
            }
        }
        return FontRegistry.get(fontName);
    }

    public static Font getDefaultUserViewFont() {
        if (!FontRegistry.hasValueFor(DEFAULT_VIEW_FONT_NAME)) {
            FontFactory.getDefaultUserViewFontData();
        }
        return FontRegistry.get(DEFAULT_VIEW_FONT_NAME);
    }

    public static FontData getDefaultUserViewFontData() {
        if (!FontRegistry.hasValueFor(DEFAULT_VIEW_FONT_NAME)) {
            String fontDetails = ArchiPlugin.getInstance().getPreferenceStore().getString(DEFAULT_VIEW_FONT_NAME);
            if (StringUtils.isSet(fontDetails)) {
                try {
                    FontData fd = new FontData(fontDetails);
                    FontRegistry.put(DEFAULT_VIEW_FONT_NAME, new FontData[]{fd});
                }
                catch (Exception exception) {
                    FontFactory.setDefaultViewOSFontData();
                }
            } else {
                FontFactory.setDefaultViewOSFontData();
            }
        }
        return FontRegistry.getFontData(DEFAULT_VIEW_FONT_NAME)[0];
    }

    public static void setDefaultUserViewFont(FontData fd) {
        FontRegistry.put(DEFAULT_VIEW_FONT_NAME, new FontData[]{fd});
        ArchiPlugin.getInstance().getPreferenceStore().setValue(DEFAULT_VIEW_FONT_NAME, fd.toString());
    }

    public static FontData getDefaultViewOSFontData() {
        FontData fd = new FontData("Sans", 9, 0);
        if (PlatformUtils.isWindows()) {
            fd = new FontData("Segoe UI", 9, 0);
        } else if (PlatformUtils.isLinux()) {
            fd = new FontData("Sans", 9, 0);
        } else if (PlatformUtils.isMac()) {
            fd = new FontData("Lucida Grande", ArchiPlugin.getInstance().getPreferenceStore().getBoolean("fontScaling") ? 9 : 12, 0);
        }
        return fd;
    }

    private static void setDefaultViewOSFontData() {
        FontData fd = FontFactory.getDefaultViewOSFontData();
        FontRegistry.put(DEFAULT_VIEW_FONT_NAME, new FontData[]{fd});
    }

    public static Font getScaledFont(String fontName) {
        return FontFactory.get(FontFactory.getScaledFontString(fontName));
    }

    public static String getScaledFontString(String fontDataString) {
        if (PlatformUtils.isLinux() || PlatformUtils.isMac() && !ArchiPlugin.getInstance().getPreferenceStore().getBoolean("fontScaling")) {
            return fontDataString;
        }
        int DPI = Display.getCurrent().getDPI().y;
        if (DPI != 96) {
            if (!StringUtils.isSet(fontDataString)) {
                fontDataString = FontFactory.getDefaultUserViewFontData().toString();
            }
            try {
                FontData fd = new FontData(fontDataString);
                float factor = 96.0f / (float)DPI;
                int newHeight = (int)((float)fd.getHeight() * factor);
                fd.setHeight(newHeight);
                fontDataString = fd.toString();
            }
            catch (Exception exception) {}
        }
        return fontDataString;
    }

    public static Font getItalic(Font font) {
        String fontName = font.getFontData()[0].toString();
        FontFactory.get(fontName);
        return FontRegistry.getItalic(fontName);
    }

    public static Font getBold(Font font) {
        String fontName = font.getFontData()[0].toString();
        FontFactory.get(fontName);
        return FontRegistry.getBold(fontName);
    }
}

