/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui.components;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.utils.PlatformUtils;
import java.util.ArrayList;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Shell;

public class CustomColorDialog {
    private static final int CUSTOM_COLOR_COUNT = 16;
    private ColorDialog colorDialog;

    public CustomColorDialog(Shell parent) {
        this(parent, 0);
    }

    public CustomColorDialog(Shell parent, int style) {
        this.colorDialog = new ColorDialog(parent, style);
        if (PlatformUtils.isWindows()) {
            this.colorDialog.setRGBs(this.getColorChooserColorsFromPreferences());
        }
    }

    public void setRGB(RGB rgb) {
        this.colorDialog.setRGB(rgb);
    }

    public void setRGBs(RGB[] rgbs) {
        this.colorDialog.setRGBs(rgbs);
    }

    public RGB getRGB() {
        return this.colorDialog.getRGB();
    }

    public RGB[] getRGBs() {
        return this.colorDialog.getRGBs();
    }

    public RGB open() {
        RGB rgb = this.colorDialog.open();
        if (rgb != null && PlatformUtils.isWindows()) {
            this.saveColorChooserColorsToPreferences();
        }
        return rgb;
    }

    private void saveColorChooserColorsToPreferences() {
        RGB[] rgbs = this.getRGBs();
        if (rgbs != null) {
            int i = 0;
            while (i < rgbs.length) {
                ArchiPlugin.getInstance().getPreferenceStore().setValue("colorChooser_" + i, ColorFactory.convertRGBToString(rgbs[i]));
                ++i;
            }
        }
    }

    private RGB[] getColorChooserColorsFromPreferences() {
        ArrayList<RGB> rgbs = new ArrayList<RGB>();
        int i = 0;
        while (i < 16) {
            String value = ArchiPlugin.getInstance().getPreferenceStore().getString("colorChooser_" + i);
            RGB rgb = ColorFactory.convertStringToRGB(value);
            if (rgb != null) {
                rgbs.add(rgb);
            } else {
                rgbs.add(new RGB(255, 255, 255));
            }
            ++i;
        }
        return rgbs.toArray(new RGB[rgbs.size()]);
    }
}

