/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui.components;

import com.archimatetool.editor.preferences.FontsPreferencePage;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.ui.FontFactory;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.UIUtils;
import com.archimatetool.editor.ui.components.Messages;
import com.archimatetool.model.IFontAttribute;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class FontChooser
extends EventManager {
    public static final String PROP_FONTCHANGE = "fontValue";
    public static final String PROP_FONTDEFAULT = "fontDefault";
    private Composite fComposite;
    private Button fTextButton;
    private Button fMenuButton;
    protected boolean fDoShowDefaultMenuItem = true;
    protected boolean fDoShowPreferencesMenuItem = true;
    private List<IAction> fExtraActionsList = new ArrayList<IAction>();
    private boolean fIsDefaultFont;
    private IFontAttribute fFontObject;
    private FontData fFontData;
    private RGB fFontRGB;

    public FontChooser(Composite parent, FormToolkit toolkit) {
        this(parent);
        toolkit.adapt((Control)this.fTextButton, true, true);
        toolkit.adapt((Control)this.fMenuButton, true, true);
    }

    public FontChooser(Composite parent) {
        this.fComposite = new Composite(parent, 0);
        this.fComposite.setBackgroundMode(2);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        this.fComposite.setLayout((Layout)layout);
        this.fTextButton = new Button(this.fComposite, 0x800000);
        this.fTextButton.setText("Select");
        this.fTextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FontChooser.this.chooseFont();
            }
        });
        GridDataFactory.create((int)0).hint(90, -1).applyTo((Control)this.fTextButton);
        this.fComposite.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = "Font Chooser";
            }
        });
        this.fMenuButton = new Button(this.fComposite, 0x800000);
        this.fMenuButton.setLayoutData((Object)new GridData(1040));
        this.fMenuButton.setImage(IArchiImages.ImageFactory.getImage("img/menu-arrow.png"));
        this.fMenuButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FontChooser.this.showMenu();
            }
        });
    }

    public void setFontObject(IFontAttribute fontObject) {
        this.fFontObject = fontObject;
        this.updateFont();
    }

    public void setIsDefaultFont(boolean set) {
        this.fIsDefaultFont = set;
    }

    public boolean isDefaultFont() {
        return this.fIsDefaultFont;
    }

    public void setDoShowPreferencesMenuItem(boolean set) {
        this.fDoShowPreferencesMenuItem = set;
    }

    public void setDoShowDefaultMenuItem(boolean set) {
        this.fDoShowDefaultMenuItem = set;
    }

    public RGB getFontRGB() {
        return this.fFontRGB;
    }

    public FontData getFontData() {
        return this.fFontData;
    }

    public Control getControl() {
        return this.fComposite;
    }

    public void showMenu() {
        MenuManager menuManager = new MenuManager();
        this.addMenuActions(menuManager);
        Menu menu = menuManager.createContextMenu((Control)this.fMenuButton.getShell());
        Point p = this.fMenuButton.getParent().toDisplay(this.fMenuButton.getBounds().x, this.fMenuButton.getBounds().y);
        menu.setLocation(p);
        menu.setVisible(true);
    }

    public void addMenuAction(IAction action) {
        if (action != null && !this.fExtraActionsList.contains(action)) {
            this.fExtraActionsList.add(action);
        }
    }

    protected void addMenuActions(MenuManager menuManager) {
        if (this.fDoShowDefaultMenuItem) {
            Action defaultFontAction = new Action(Messages.FontChooser_1){

                public void run() {
                    boolean oldValue = FontChooser.this.fIsDefaultFont;
                    FontChooser.this.fIsDefaultFont = !FontChooser.this.fIsDefaultFont;
                    FontChooser.this.fireActionListenerEvent(FontChooser.PROP_FONTDEFAULT, oldValue, FontChooser.this.fIsDefaultFont);
                }
            };
            menuManager.add((IAction)defaultFontAction);
            defaultFontAction.setEnabled(!this.isDefaultFont());
        }
        for (IAction action : this.fExtraActionsList) {
            menuManager.add(action);
        }
        if (this.fDoShowPreferencesMenuItem) {
            menuManager.add((IContributionItem)new Separator());
            Action preferencesAction = new Action(Messages.FontChooser_2){

                public void run() {
                    PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)FontChooser.this.getControl().getShell(), (String)FontsPreferencePage.ID, null, null);
                    if (dialog != null) {
                        dialog.open();
                    }
                }
            };
            menuManager.add((IAction)preferencesAction);
        }
    }

    public void setEnabled(boolean state) {
        this.getControl().setEnabled(state);
        this.fTextButton.setEnabled(state);
        this.fMenuButton.setEnabled(state);
    }

    public void chooseFont() {
        FontDialog dialog = new FontDialog(this.getControl().getShell());
        dialog.setEffectsVisible(false);
        dialog.setText(Messages.FontChooser_3);
        dialog.setFontList(new FontData[]{this.fFontData});
        dialog.setRGB(this.fFontRGB);
        FontData selectedFontData = dialog.open();
        if (selectedFontData != null) {
            FontData oldValue = this.fFontData;
            this.fFontData = selectedFontData;
            this.fFontRGB = dialog.getRGB();
            this.fireActionListenerEvent(PROP_FONTCHANGE, oldValue, this.fFontData);
            this.updateButtonText();
        }
    }

    protected void updateFont() {
        this.fFontData = FontFactory.getDefaultUserViewFontData();
        String fontValue = this.fFontObject.getFont();
        if (fontValue != null) {
            try {
                this.fFontData = new FontData(fontValue);
            }
            catch (Exception exception) {}
        }
        this.fFontRGB = ColorFactory.convertStringToRGB(this.fFontObject.getFontColor());
        if (this.fFontRGB == null) {
            this.fFontRGB = new RGB(0, 0, 0);
        }
        this.updateButtonText();
    }

    protected void updateButtonText() {
        String text = this.fFontData.getName() + " " + this.fFontData.getHeight() + " " + ((this.fFontData.getStyle() & 1) == 1 ? Messages.FontChooser_4 : "") + " " + ((this.fFontData.getStyle() & 2) == 2 ? Messages.FontChooser_7 : "");
        this.fTextButton.getDisplay().asyncExec(() -> {
            if (!this.fTextButton.isDisposed()) {
                this.fTextButton.setText(UIUtils.shortenText(text, (Control)this.fTextButton, 6));
            }
        });
        this.fTextButton.setToolTipText(text);
    }

    public void addListener(IPropertyChangeListener listener) {
        this.addListenerObject(listener);
    }

    public void removeListener(IPropertyChangeListener listener) {
        this.removeListenerObject(listener);
    }

    private void fireActionListenerEvent(String propertyName, Object oldValue, Object newValue) {
        Object[] finalListeners = this.getListeners();
        if (finalListeners.length > 0) {
            PropertyChangeEvent pEvent = new PropertyChangeEvent((Object)this, propertyName, oldValue, newValue);
            int i = 0;
            while (i < finalListeners.length) {
                IPropertyChangeListener listener = (IPropertyChangeListener)finalListeners[i];
                listener.propertyChange(pEvent);
                ++i;
            }
        }
    }
}

