/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui.components;

import com.archimatetool.editor.ui.ThemeUtils;
import com.archimatetool.editor.ui.UIUtils;
import com.archimatetool.editor.ui.components.Messages;
import com.archimatetool.editor.utils.HTMLUtils;
import com.archimatetool.editor.utils.PlatformUtils;
import com.archimatetool.editor.utils.StringUtils;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PartInitException;

public class StyledTextControl {
    private StyledText fStyledText;
    private Cursor fHandCursor;
    private Cursor fCurrentCursor;
    private Color linkColor = new Color(0, 0, 255);
    private Color linkColorDark = new Color(144, 255, 255);
    private List<LinkInfo> fLinkInfos;
    private String originalText = "";
    private String editedText = "";
    private String message;
    private Listener eventListener = this::handleEvent;
    private LineStyleListener lineStyleListener = this::lineGetStyle;
    private VerifyKeyListener verifyKeyListener = this::handleVerifyKey;
    private final int[] eventTypes = new int[]{4, 5, 1, 2, 15, 16, 9, 12};
    private IAction fActionSelectAll = new Action(Messages.StyledTextControl_0){

        public void run() {
            StyledTextControl.this.fStyledText.selectAll();
        }
    };
    private IAction fActionCut = new Action(Messages.StyledTextControl_1){

        public void run() {
            StyledTextControl.this.fStyledText.cut();
        }
    };
    private IAction fActionCopy = new Action(Messages.StyledTextControl_2){

        public void run() {
            StyledTextControl.this.fStyledText.copy();
        }
    };
    private IAction fActionPaste = new Action(Messages.StyledTextControl_3){

        public void run() {
            StyledTextControl.this.fStyledText.paste();
        }
    };
    private IAction fActionDelete = new Action(Messages.StyledTextControl_4){

        public void run() {
            StyledTextControl.this.fStyledText.invokeAction(127);
        }
    };

    public StyledTextControl(Composite parent, int style) {
        this(new StyledText(parent, style));
    }

    public StyledTextControl(StyledText styledText) {
        this.fStyledText = styledText;
        this.fStyledText.setLeftMargin(PlatformUtils.isWindows() ? 4 : 2);
        this.fStyledText.setKeyBinding(262209, 262209);
        this.fHandCursor = new Cursor((Device)styledText.getDisplay(), 21);
        int[] nArray = this.eventTypes;
        int n = this.eventTypes.length;
        int n2 = 0;
        while (n2 < n) {
            int type = nArray[n2];
            this.fStyledText.addListener(type, this.eventListener);
            ++n2;
        }
        this.fStyledText.addLineStyleListener(this.lineStyleListener);
        this.fStyledText.addVerifyKeyListener(this.verifyKeyListener);
        UIUtils.applyInvalidCharacterFilter((Control)this.fStyledText);
        ThemeUtils.registerCssId((Control)this.fStyledText, "StyledTextControl");
        ThemeUtils.setFontIfCssThemingDisabled((Control)this.fStyledText, "com.archimatetool.editor.MULTI_LINE_TEXT_FONT");
        this.hookContextMenu();
    }

    public void setMessage(String message) {
        this.message = message;
    }

    private void lineGetStyle(LineStyleEvent event) {
        this.scanLinks();
        int lineLength = event.lineText.length();
        int lineOffset = event.lineOffset;
        ArrayList<StyleRange> list = new ArrayList<StyleRange>();
        for (LinkInfo info : this.fLinkInfos) {
            if (info.start < lineOffset || info.end > lineOffset + lineLength) continue;
            StyleRange sr = new StyleRange(info.start, info.length, ThemeUtils.isDarkTheme() ? this.linkColorDark : this.linkColor, null);
            sr.underline = true;
            list.add(sr);
        }
        if (!list.isEmpty()) {
            event.styles = list.toArray(new StyleRange[list.size()]);
        }
    }

    private void handleVerifyKey(VerifyEvent event) {
        if (!((event.stateMask & SWT.MODIFIER_MASK) != SWT.MOD1 && (event.stateMask & SWT.MODIFIER_MASK) != 262144 || event.keyCode != 13 && event.keyCode != 0x1000050)) {
            event.doit = false;
            Event e = new Event();
            e.type = 14;
            e.widget = this.fStyledText;
            e.display = this.fStyledText.getDisplay();
            e.time = (int)System.currentTimeMillis();
            this.fStyledText.notifyListeners(14, e);
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu1");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                StyledTextControl.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.fStyledText);
        this.fStyledText.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        int textLength = this.fStyledText.getText().length();
        boolean hasText = textLength > 0;
        boolean hasSelectedText = this.fStyledText.getSelectionText().length() > 0;
        this.fActionCut.setEnabled(hasSelectedText);
        manager.add(this.fActionCut);
        this.fActionCopy.setEnabled(hasSelectedText);
        manager.add(this.fActionCopy);
        Clipboard cb = new Clipboard(null);
        Object content = cb.getContents((Transfer)TextTransfer.getInstance());
        cb.dispose();
        this.fActionPaste.setEnabled(content != null);
        manager.add(this.fActionPaste);
        this.fActionDelete.setEnabled(hasSelectedText);
        manager.add(this.fActionDelete);
        manager.add((IContributionItem)new Separator());
        this.fActionSelectAll.setEnabled(hasText);
        manager.add(this.fActionSelectAll);
    }

    public StyledText getControl() {
        return this.fStyledText;
    }

    private void scanLinks() {
        this.fLinkInfos = new ArrayList<LinkInfo>();
        Matcher matcher = HTMLUtils.HTML_LINK_PATTERN.matcher(this.fStyledText.getText());
        while (matcher.find()) {
            LinkInfo info = new LinkInfo(matcher.group(), matcher.start());
            this.fLinkInfos.add(info);
        }
    }

    private String getLinkAt(int offset) {
        for (LinkInfo info : this.fLinkInfos) {
            if (offset < info.start || offset >= info.end) continue;
            return info.link;
        }
        return null;
    }

    private void handleEvent(Event event) {
        switch (event.type) {
            case 4: {
                this.doMouseUp(event);
                break;
            }
            case 5: {
                this.doMouseMove(event);
                break;
            }
            case 1: {
                this.doKeyDown(event);
                break;
            }
            case 2: {
                this.doKeyUp(event);
                break;
            }
            case 15: {
                this.editedText = this.originalText = this.fStyledText.getText();
            }
            case 16: {
                if (!StringUtils.isSet(this.message) || this.getControl().getContent().getCharCount() != 0) break;
                this.getControl().redraw();
                break;
            }
            case 9: {
                this.doPaint(event);
                break;
            }
            case 12: {
                this.dispose();
            }
        }
    }

    private void doMouseUp(Event e) {
        int offset;
        String link;
        if (this.isModKeyPressed(e) && (link = this.getLinkAt(offset = this.fStyledText.getOffsetAtPoint(new Point(e.x, e.y)))) != null) {
            try {
                HTMLUtils.openLinkInBrowser(link);
            }
            catch (MalformedURLException | PartInitException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void doMouseMove(Event e) {
        if (this.isModKeyPressed(e)) {
            int offset = this.fStyledText.getOffsetAtPoint(new Point(e.x, e.y));
            if (this.getLinkAt(offset) != null) {
                this.setCursor(this.fHandCursor);
            } else {
                this.setCursor(null);
            }
        } else {
            this.setCursor(null);
        }
    }

    private void doKeyDown(Event e) {
        if (e.keyCode == SWT.MOD1) {
            Point pt = this.fStyledText.getDisplay().getCursorLocation();
            int offset = this.fStyledText.getOffsetAtPoint(pt = this.fStyledText.toControl(pt));
            if (this.getLinkAt(offset) != null) {
                this.setCursor(this.fHandCursor);
            }
        }
        if (this.isModKeyPressed(e)) {
            this.checkUndoPressed(e);
        }
    }

    private void checkUndoPressed(Event e) {
        if (e.keyCode == 122) {
            String text = this.fStyledText.getText();
            if (text.equals(this.originalText)) {
                if (!this.originalText.equals(this.editedText)) {
                    this.fStyledText.setText(this.editedText);
                    this.fStyledText.setTopIndex(this.fStyledText.getLineCount() - 1);
                    this.fStyledText.setCaretOffset(this.fStyledText.getText().length());
                }
            } else {
                this.fStyledText.setText(this.originalText);
                this.fStyledText.setTopIndex(this.fStyledText.getLineCount() - 1);
                this.fStyledText.setCaretOffset(this.fStyledText.getText().length());
            }
            this.editedText = text;
        }
    }

    private void doKeyUp(Event e) {
        if (e.keyCode == SWT.MOD1) {
            this.setCursor(null);
        }
    }

    private void doPaint(Event e) {
        if (StringUtils.isSet(this.message) && this.getControl().getContent().getCharCount() == 0 && !this.getControl().isFocusControl()) {
            e.gc.setForeground(this.getControl().getDisplay().getSystemColor(PlatformUtils.isWindows() ? 16 : 15));
            e.gc.drawText(this.message, 3, 1);
        }
    }

    private void setCursor(Cursor cursor) {
        if (this.fCurrentCursor != cursor) {
            this.fStyledText.setCursor(cursor);
            this.fCurrentCursor = cursor;
        }
    }

    private boolean isModKeyPressed(Event e) {
        return (e.stateMask & SWT.MODIFIER_MASK) == SWT.MOD1;
    }

    private void dispose() {
        if (this.fHandCursor != null && !this.fHandCursor.isDisposed()) {
            this.fHandCursor.dispose();
            this.fHandCursor = null;
        }
        int[] nArray = this.eventTypes;
        int n = this.eventTypes.length;
        int n2 = 0;
        while (n2 < n) {
            int type = nArray[n2];
            this.fStyledText.removeListener(type, this.eventListener);
            ++n2;
        }
        this.fStyledText.removeLineStyleListener(this.lineStyleListener);
        this.fStyledText.removeVerifyKeyListener(this.verifyKeyListener);
        this.fCurrentCursor = null;
        this.fLinkInfos = null;
        this.fStyledText = null;
    }

    private class LinkInfo {
        String link;
        int start;
        int length;
        int end;

        LinkInfo(String link, int start) {
            this.link = link;
            this.start = start;
            this.length = link.length();
            this.end = start + this.length;
        }
    }
}

