/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui.dialog;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.actions.CheckForNewVersionAction;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.dialog.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.about.InstallationDialog;
import org.eclipse.ui.services.IServiceLocator;

public class AboutDialog
extends TrayDialog {
    private TabFolder folder;
    private TabItem aboutTabItem;
    private TabItem licenseTabItem;
    private Text licenseText;
    private Button installationDetailsButton;
    private Button checkNewVersionButton;
    private static final int INSTALLATION_DETAILS_ID = 1025;
    private static final int CHECK_UPDATE_ID = 1026;
    private CheckForNewVersionAction checkNewVersionAction;

    public AboutDialog(Shell shell) {
        super(shell);
        this.setHelpAvailable(false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AboutDialog_0);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            new InstallationDialog(this.getShell(), (IServiceLocator)PlatformUI.getWorkbench().getActiveWorkbenchWindow()).open();
        } else if (buttonId == 1026) {
            this.checkNewVersionAction.run();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.folder = new TabFolder(composite, 0);
        this.folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabItem item = (TabItem)e.item;
                if (item == AboutDialog.this.aboutTabItem) {
                    AboutDialog.this.populateAboutTab();
                } else if (item == AboutDialog.this.licenseTabItem) {
                    AboutDialog.this.populateLicenseTab();
                }
            }
        });
        this.folder.setLayoutData((Object)new GridData(1808));
        this.createAboutTab();
        this.createLicenseTab();
        return composite;
    }

    private void createAboutTab() {
        int imageHeight;
        this.aboutTabItem = new TabItem(this.folder, 0);
        this.aboutTabItem.setText(Messages.AboutDialog_1);
        Composite control = new Composite((Composite)this.folder, 0);
        control.setLayout((Layout)new GridLayout());
        this.aboutTabItem.setControl((Control)control);
        Composite imageControl = new Composite(control, 262144);
        GridData gd = new GridData(2, 2, true, true);
        imageControl.setLayoutData((Object)gd);
        Image image = IArchiImages.ImageFactory.getImage("splash.png");
        if (image != null) {
            ImageData id = image.getImageData();
            gd.widthHint = id.width;
            gd.heightHint = id.height;
            imageHeight = id.height;
        } else {
            gd.widthHint = 500;
            gd.heightHint = 300;
            imageHeight = 300;
        }
        String version = Messages.AboutDialog_2 + ArchiPlugin.getInstance().getVersion();
        String build = Messages.AboutDialog_3 + ArchiPlugin.getInstance().getBuild();
        String copyright = ArchiPlugin.getInstance().getResourceString("%aboutCopyright");
        FontData fd = imageControl.getFont().getFontData()[0];
        fd.setHeight(fd.getHeight() - 1);
        Font smallFont = new Font((Device)imageControl.getDisplay(), fd);
        imageControl.addDisposeListener(e -> smallFont.dispose());
        imageControl.addPaintListener(e -> {
            int fontHeight = e.gc.getFontMetrics().getHeight() + 2;
            e.gc.setForeground(new Color(35, 35, 140));
            e.gc.drawImage(image, 0, 0);
            e.gc.drawString(version, 19, 166, true);
            e.gc.drawString(build, 19, 166 + fontHeight, true);
            e.gc.setFont(smallFont);
            fontHeight = e.gc.getFontMetrics().getHeight() + 2;
            e.gc.drawString(copyright, 12, imageHeight - fontHeight - 5, true);
        });
    }

    private void populateAboutTab() {
        this.installationDetailsButton.setVisible(true);
        this.checkNewVersionButton.setVisible(true);
    }

    private void createLicenseTab() {
        this.licenseTabItem = new TabItem(this.folder, 0);
        this.licenseTabItem.setText(Messages.AboutDialog_5);
        Composite control = new Composite((Composite)this.folder, 0);
        control.setLayout((Layout)new GridLayout());
        this.licenseTabItem.setControl((Control)control);
        this.licenseText = new Text(control, 527114);
        this.licenseText.setBackground(control.getDisplay().getSystemColor(25));
        GridData gridData = new GridData(272);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        this.licenseText.setLayoutData((Object)gridData);
        this.licenseText.setFont(JFaceResources.getDialogFont());
    }

    private void populateLicenseTab() {
        URL url;
        this.installationDetailsButton.setVisible(false);
        this.checkNewVersionButton.setVisible(false);
        if (this.licenseText.getText().length() == 0 && (url = ArchiPlugin.getInstance().getBundle().getEntry("LICENSE.txt")) != null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (InputStream in = url.openStream();){
                    String content = new String(in.readAllBytes());
                    this.licenseText.setText(content);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.marginHeight = 0;
        layout.marginBottom = 5;
        this.installationDetailsButton = this.createButton(parent, 1025, Messages.AboutDialog_4, false);
        this.setButtonLayoutData(this.installationDetailsButton);
        this.checkNewVersionAction = new CheckForNewVersionAction();
        this.checkNewVersionButton = this.createButton(parent, 1026, Messages.AboutDialog_7, false);
        this.setButtonLayoutData(this.checkNewVersionButton);
        this.checkNewVersionButton.setEnabled(this.checkNewVersionAction.isEnabled());
        this.createButton(parent, 0, Messages.AboutDialog_6, true);
    }
}

