/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui.dialog;

import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.components.ExtendedTitleAreaDialog;
import com.archimatetool.editor.ui.dialog.Messages;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.util.ArchimateModelUtils;
import com.archimatetool.model.util.RelationshipsMatrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.jface.gridviewer.internal.CellSelection;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RelationshipsMatrixDialog
extends ExtendedTitleAreaDialog {
    private static String HELP_ID = "com.archimatetool.help.RelationshipsMatrixDialog";
    private List<EClass> fAllClasses;

    public RelationshipsMatrixDialog(Shell parentShell) {
        super(parentShell, "RelationshipsMatrixDialog");
        this.setTitleImage(IArchiImages.ImageFactory.getImage("img/new_wiz.png"));
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.RelationshipsMatrixDialog_0);
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
        this.setTitle(Messages.RelationshipsMatrixDialog_0);
        this.setMessage(Messages.RelationshipsMatrixDialog_1);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite client = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        client.setLayout((Layout)layout);
        client.setLayoutData((Object)new GridData(1808));
        GridTableViewer viewer = new GridTableViewer(client);
        GridData gd = new GridData(1808);
        gd.widthHint = 800;
        gd.heightHint = 500;
        viewer.getControl().setLayoutData((Object)gd);
        viewer.getGrid().setHeaderVisible(true);
        viewer.getGrid().setRowsResizeable(true);
        viewer.getGrid().setCellSelectionEnabled(true);
        viewer.setRowHeaderLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(ArchiLabelProvider.INSTANCE.getDefaultName((EClass)cell.getElement()));
                cell.setImage(ArchiLabelProvider.INSTANCE.getImage(cell.getElement()));
            }
        });
        GC gc = new GC((Drawable)viewer.getGrid());
        int columnWidth = gc.textExtent((String)"acfginorstv").x + 8;
        gc.dispose();
        for (EClass eClass : this.getData()) {
            GridColumn column = new GridColumn(viewer.getGrid(), 0);
            column.setWidth(columnWidth);
            column.setImage(ArchiLabelProvider.INSTANCE.getImage(eClass));
            column.setHeaderTooltip(ArchiLabelProvider.INSTANCE.getDefaultName(eClass));
        }
        viewer.getGrid().setRowHeaderVisible(true);
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return RelationshipsMatrixDialog.this.getData().toArray();
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new MyLabelProvider());
        viewer.setInput(this.getData());
        Object text = "";
        for (Map.Entry entry : RelationshipsMatrix.INSTANCE.getRelationshipsValueMap().entrySet()) {
            text = (String)text + String.valueOf(entry.getValue()) + ": " + ArchiLabelProvider.INSTANCE.getDefaultName((EClass)entry.getKey()) + "\n";
        }
        Label label = new Label(client, 0);
        label.setText((String)text);
        label.setLayoutData((Object)new GridData(128, 128, false, true));
        return composite;
    }

    private void hookContextMenu(final GridTableViewer viewer) {
        MenuManager menuMgr = new MenuManager("#GridPopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                final CellSelection selection = (CellSelection)viewer.getSelection();
                if (!selection.isEmpty()) {
                    manager.add((IAction)new Action("Restore to default"){

                        public void run() {
                            Object[] objectArray = selection.toArray();
                            int n = objectArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object element = objectArray[n2];
                                EClass eClassRow = (EClass)element;
                                for (Object o : selection.getIndices(element)) {
                                    int columnIndex = (Integer)o;
                                    EClass eClassColumn = RelationshipsMatrixDialog.this.getData().get(columnIndex);
                                    RelationshipsMatrixDialog.this.restoreDefaultValue(eClassRow, eClassColumn);
                                }
                                ++n2;
                            }
                        }
                    });
                }
            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
    }

    private void restoreDefaultValue(EClass sourceClass, EClass targetClass) {
    }

    private List<EClass> getData() {
        if (this.fAllClasses == null) {
            this.fAllClasses = new ArrayList<EClass>();
            this.fAllClasses.addAll(Arrays.asList(ArchimateModelUtils.getAllArchimateClasses()));
            this.fAllClasses.add(IArchimatePackage.eINSTANCE.getJunction());
        }
        return this.fAllClasses;
    }

    @Override
    protected Point getDefaultDialogSize() {
        return new Point(1000, 700);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.RelationshipsMatrixDialog_2, true);
    }

    private class MyLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private MyLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            EClass eClassRow = (EClass)element;
            EClass eClassColumn = RelationshipsMatrixDialog.this.getData().get(columnIndex);
            Object text = "";
            Map matrixMap = RelationshipsMatrix.INSTANCE.getRelationshipsMatrix();
            Map valueMap = RelationshipsMatrix.INSTANCE.getRelationshipsValueMap();
            List list = (List)matrixMap.get(eClassRow);
            if (list != null) {
                for (RelationshipsMatrix.TargetMatrix targetMatrix : list) {
                    if (targetMatrix.getTargetClass() != eClassColumn) continue;
                    for (EClass relation : targetMatrix.getRelationships()) {
                        text = (String)text + String.valueOf(valueMap.get(relation));
                    }
                }
            }
            return text;
        }
    }
}

