/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui.factory.model;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.factory.AbstractObjectUIProvider;
import com.archimatetool.editor.ui.factory.model.Messages;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.FolderType;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IFolder;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class FolderUIProvider
extends AbstractObjectUIProvider {
    private static Color DEFAULT_COLOR = new Color(255, 199, 63);

    public static Color getFolderColor(FolderType type) {
        String colorValue = ArchiPlugin.getInstance().getPreferenceStore().getString("folderColour_" + type.getName());
        if (StringUtils.isSet(colorValue)) {
            return ColorFactory.get(colorValue);
        }
        return DEFAULT_COLOR;
    }

    public static Color getDefaultFolderColor(FolderType type) {
        String colorValue = ArchiPlugin.getInstance().getPreferenceStore().getDefaultString("folderColour_" + type.getName());
        if (StringUtils.isSet(colorValue)) {
            return ColorFactory.get(colorValue);
        }
        return DEFAULT_COLOR;
    }

    @Override
    public EClass providerFor() {
        return IArchimatePackage.eINSTANCE.getFolder();
    }

    @Override
    public String getDefaultName() {
        return Messages.FolderUIProvider_0;
    }

    @Override
    public Image getImage() {
        Color color;
        if (this.instance instanceof IFolder && !DEFAULT_COLOR.equals((Object)(color = FolderUIProvider.getFolderColor(this.getFolderType((IFolder)this.instance))))) {
            return IArchiImages.ImageFactory.getImageWithRGB("img/folder-default.png", color.getRGB());
        }
        return IArchiImages.ImageFactory.getImage("img/folder-default.png");
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        Color color;
        if (this.instance instanceof IFolder && !DEFAULT_COLOR.equals((Object)(color = FolderUIProvider.getFolderColor(this.getFolderType((IFolder)this.instance))))) {
            return IArchiImages.ImageFactory.getImageDescriptorWithRGB("img/folder-default.png", color.getRGB());
        }
        return IArchiImages.ImageFactory.getImageDescriptor("img/folder-default.png");
    }

    private FolderType getFolderType(IFolder folder) {
        if (folder.getType() != FolderType.USER) {
            return folder.getType();
        }
        IFolder eObject = folder;
        while (eObject.eContainer() instanceof IFolder) {
            eObject = eObject.eContainer();
        }
        return eObject.getType();
    }
}

