/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui.findreplace;

import com.archimatetool.editor.ui.findreplace.IFindReplaceProvider;
import com.archimatetool.editor.utils.StringUtils;
import java.util.regex.Pattern;

public abstract class AbstractFindReplaceProvider
implements IFindReplaceProvider {
    private int parameter = 0;

    @Override
    public boolean canFind(String toFind) {
        return StringUtils.isSet(toFind);
    }

    @Override
    public boolean canFindAll(String toFind) {
        return StringUtils.isSet(toFind);
    }

    @Override
    public boolean canReplace(String toFind, String toReplaceWith) {
        return this.canFind(toFind) && toReplaceWith != null;
    }

    @Override
    public boolean canReplaceAll(String toFind, String toReplaceWith) {
        return this.canReplace(toFind, toReplaceWith);
    }

    @Override
    public int getParameter() {
        return this.parameter;
    }

    @Override
    public void setParameter(int op, boolean value) {
        this.parameter = value ? (this.parameter |= op) : (this.parameter &= ~op);
    }

    @Override
    public void setParameter(int parameter) {
        this.parameter = parameter;
    }

    @Override
    public boolean understandsParameter(int parameter) {
        return true;
    }

    public boolean isAll() {
        return (this.getParameter() & 0x10000) != 0;
    }

    public boolean isForward() {
        return (this.getParameter() & 4) != 0;
    }

    public boolean isCaseSensitive() {
        return (this.getParameter() & 1) != 0;
    }

    public boolean isWholeWord() {
        return (this.getParameter() & 2) != 0;
    }

    protected boolean isAllModels() {
        return (this.getParameter() & 0x20) != 0;
    }

    protected boolean isIncludeFolders() {
        return (this.getParameter() & 0x40) != 0;
    }

    protected boolean isIncludeRelations() {
        return (this.getParameter() & 0x80) != 0;
    }

    protected String getReplacedString(String oldString, String toFind, String toReplaceWith) {
        toFind = Pattern.quote((String)toFind);
        if (!this.isCaseSensitive()) {
            toFind = "(?iu:" + (String)toFind + ")";
        }
        return oldString.replaceAll((String)toFind, toReplaceWith);
    }

    protected String getSearchStringPattern(String searchString) {
        searchString = Pattern.quote((String)searchString);
        if (this.isWholeWord()) {
            searchString = "\\b" + (String)searchString + "\\b";
        }
        searchString = "(?s).*" + (String)searchString + ".*";
        if (!this.isCaseSensitive()) {
            searchString = "(?iu:" + (String)searchString + ")";
        }
        return searchString;
    }
}

