/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui.services;

import com.archimatetool.editor.ui.services.IComponentSelectionListener;
import java.util.concurrent.CopyOnWriteArrayList;

public final class ComponentSelectionManager {
    public static final ComponentSelectionManager INSTANCE = new ComponentSelectionManager();
    private CopyOnWriteArrayList<IComponentSelectionListener> listeners = new CopyOnWriteArrayList();

    public void addSelectionListener(IComponentSelectionListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeSelectionListener(IComponentSelectionListener listener) {
        this.listeners.remove(listener);
    }

    public void fireSelectionEvent(Object source, Object selection) {
        if (selection == null) {
            return;
        }
        for (IComponentSelectionListener listener : this.listeners) {
            listener.componentSelectionChanged(source, selection);
        }
    }
}

