/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui.services;

import com.archimatetool.editor.Logger;
import com.archimatetool.editor.diagram.DiagramEditorFactoryExtensionHandler;
import com.archimatetool.editor.diagram.DiagramEditorInput;
import com.archimatetool.editor.diagram.IDiagramEditorFactory;
import com.archimatetool.editor.diagram.IDiagramModelEditor;
import com.archimatetool.model.IArchimateDiagramModel;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.ISketchModel;
import java.util.ArrayList;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class EditorManager {
    public static IEditorPart openEditor(IEditorInput input, String editorID, boolean activate) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return null;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            return page.openEditor(input, editorID, activate);
        }
        catch (PartInitException ex) {
            Logger.logError("Could not open Editor " + editorID);
            ex.printStackTrace();
            return null;
        }
    }

    public static IEditorPart openEditor(IEditorInput input, String editorID) {
        return EditorManager.openEditor(input, editorID, true);
    }

    public static IDiagramModelEditor openDiagramEditor(IDiagramModel model) {
        return EditorManager.openDiagramEditor(model, true);
    }

    public static IDiagramModelEditor openDiagramEditor(IDiagramModel model, boolean activate) {
        if (model == null || model.eContainer() == null || !PlatformUI.isWorkbenchRunning()) {
            return null;
        }
        String id = null;
        DiagramEditorInput editorInput = null;
        if (model instanceof IArchimateDiagramModel) {
            id = "com.archimatetool.editor.diagramEditor";
            editorInput = new DiagramEditorInput(model);
        } else if (model instanceof ISketchModel) {
            id = "com.archimatetool.editor.sketchEditor";
            editorInput = new DiagramEditorInput(model);
        } else {
            IDiagramEditorFactory factory = DiagramEditorFactoryExtensionHandler.INSTANCE.getFactory(model);
            if (factory != null) {
                id = factory.getEditorID();
                editorInput = factory.createEditorInput(model);
            }
        }
        if (id == null || editorInput == null) {
            throw new RuntimeException("Unsupported model type");
        }
        IEditorPart part = EditorManager.openEditor(editorInput, id, activate);
        return part instanceof IDiagramModelEditor ? (IDiagramModelEditor)part : null;
    }

    public static void closeDiagramEditor(IDiagramModel diagramModel) {
        if (diagramModel == null || !PlatformUI.isWorkbenchRunning()) {
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        page.closeEditors(EditorManager.getDiagramEditorReferences(diagramModel), false);
    }

    public static void closeDiagramEditors(IArchimateModel model) {
        if (model == null || !PlatformUI.isWorkbenchRunning()) {
            return;
        }
        ArrayList<IEditorReference> list = new ArrayList<IEditorReference>();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            try {
                IEditorInput input = ref.getEditorInput();
                if (input instanceof DiagramEditorInput && ((DiagramEditorInput)input).getDiagramModel().getArchimateModel() == model) {
                    list.add(ref);
                }
            }
            catch (PartInitException ex) {
                ex.printStackTrace();
            }
            ++n2;
        }
        if (!list.isEmpty()) {
            IEditorReference[] refs = list.toArray(new IEditorReference[list.size()]);
            page.closeEditors(refs, false);
        }
    }

    public static void activateDiagramEditors(IArchimateModel model) {
        if (model == null || !PlatformUI.isWorkbenchRunning()) {
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            try {
                DiagramEditorInput input;
                IEditorInput iEditorInput = ref.getEditorInput();
                if (iEditorInput instanceof DiagramEditorInput && (input = (DiagramEditorInput)iEditorInput).getDiagramModel().getArchimateModel() == model) {
                    ref.getEditor(true);
                }
            }
            catch (PartInitException ex) {
                ex.printStackTrace();
            }
            ++n2;
        }
    }

    public static IEditorReference[] getDiagramEditorReferences(IDiagramModel diagramModel) {
        ArrayList<IEditorReference> list = new ArrayList<IEditorReference>();
        if (diagramModel != null && PlatformUI.isWorkbenchRunning()) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference ref = iEditorReferenceArray[n2];
                try {
                    IEditorInput input = ref.getEditorInput();
                    if (input instanceof DiagramEditorInput && ((DiagramEditorInput)input).getDiagramModel() == diagramModel) {
                        list.add(ref);
                    }
                }
                catch (PartInitException ex) {
                    ex.printStackTrace();
                }
                ++n2;
            }
        }
        return list.toArray(new IEditorReference[list.size()]);
    }
}

