/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui.services;

import com.archimatetool.editor.ui.services.IUIRequestListener;
import com.archimatetool.editor.ui.services.UIRequest;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.swt.widgets.Display;

public final class UIRequestManager {
    public static final UIRequestManager INSTANCE = new UIRequestManager();
    private CopyOnWriteArrayList<IUIRequestListener> listeners = new CopyOnWriteArrayList();

    public void addListener(IUIRequestListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeListener(IUIRequestListener listener) {
        this.listeners.remove(listener);
    }

    public void fireRequestAsync(UIRequest request) {
        Display.getCurrent().asyncExec(() -> this.fireRequest(request));
    }

    public void fireRequest(UIRequest request) {
        if (request != null) {
            for (IUIRequestListener listener : this.listeners) {
                listener.requestAction(request);
            }
        }
    }
}

