/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui.textrender;

import com.archimatetool.editor.ui.textrender.AbstractTextRenderer;
import com.archimatetool.model.IArchimateModelObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WordWrapRenderer
extends AbstractTextRenderer {
    private static final String LINEBREAK = "\n";
    private static final String startOfExpression = "\\$(mfolder|vfolder|model|view|source|target|parent|(?:connection:|triggering:|access:|specialization:|composition:|assignment:|aggregation:|realization:|serving:|influence:|flow:|association:)(?:source|target))?\\{";
    private static final String notStartOfExpression = "(?!\\$(mfolder|vfolder|model|view|source|target|parent|(?:connection:|triggering:|access:|specialization:|composition:|assignment:|aggregation:|realization:|serving:|influence:|flow:|association:)(?:source|target))?\\{)";
    private static final String acceptedKeyChar = "[^\\}]";
    private static final String textToWrap = "((?!\\$(mfolder|vfolder|model|view|source|target|parent|(?:connection:|triggering:|access:|specialization:|composition:|assignment:|aggregation:|realization:|serving:|influence:|flow:|association:)(?:source|target))?\\{)[^\\}])+";
    private static final Pattern WORD_WRAP_PATTERN = Pattern.compile("\\$\\{wordwrap:([0-9]+):(((?!\\$(mfolder|vfolder|model|view|source|target|parent|(?:connection:|triggering:|access:|specialization:|composition:|assignment:|aggregation:|realization:|serving:|influence:|flow:|association:)(?:source|target))?\\{)[^\\}])+)\\}");

    @Override
    public String render(IArchimateModelObject object, String text) {
        Matcher matcher = WORD_WRAP_PATTERN.matcher(text);
        while (matcher.find()) {
            int wrapLimit;
            String textToWrap = matcher.group(2);
            String s = "";
            try {
                wrapLimit = Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                wrapLimit = 999999;
            }
            s = WordWrapRenderer.wrap(textToWrap, wrapLimit);
            text = text.replace(matcher.group(), s);
        }
        return text;
    }

    public static String wrap(String string, int lineLength) {
        StringBuilder b = new StringBuilder();
        String[] stringArray = string.split("(?<=\n)");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            b.append(WordWrapRenderer.wrapLine(line, lineLength));
            ++n2;
        }
        return b.toString();
    }

    private static String wrapLine(String line, int lineLength) {
        if (line.length() == 0) {
            return "";
        }
        if (line.length() <= lineLength) {
            return line;
        }
        StringBuilder allLines = new StringBuilder();
        StringBuilder trimmedLine = new StringBuilder();
        String[] stringArray = line.split("(?<= )");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (trimmedLine.length() + word.length() <= lineLength) {
                trimmedLine.append(word);
            } else if (trimmedLine.length() + word.trim().length() <= lineLength) {
                trimmedLine.append(word.trim());
            } else {
                if (trimmedLine.length() > 0) {
                    allLines.append((CharSequence)trimmedLine).append(LINEBREAK);
                    trimmedLine = new StringBuilder();
                }
                trimmedLine.append(word);
            }
            ++n2;
        }
        if (trimmedLine.length() > 0) {
            allLines.append((CharSequence)trimmedLine);
        }
        return allLines.toString();
    }
}

