/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.utils;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class HTMLUtils {
    public static final String HTML_LINK_REGEX = "(http|https|ftp|file)://\\S+";
    public static final Pattern HTML_LINK_PATTERN = Pattern.compile("(http|https|ftp|file)://\\S+");
    public static final String HTML_TAG_REGEX = "<[^>]+>";
    public static final Pattern HTML_TAG_REGEX_PATTERN = Pattern.compile("<[^>]+>");

    public static String stripTags(String str) {
        if (str == null || str.indexOf(60) == -1 || str.indexOf(62) == -1) {
            return str;
        }
        str = HTML_TAG_REGEX_PATTERN.matcher(str).replaceAll("");
        return str;
    }

    public static void openLinkInBrowser(String href) throws PartInitException, MalformedURLException {
        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
        IWebBrowser browser = support.getExternalBrowser();
        try {
            browser.openURL(new URI(href.replaceAll(" ", "%20")).toURL());
        }
        catch (URISyntaxException ex) {
            throw new MalformedURLException(ex.toString());
        }
    }
}

