/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class MacOSReflect {
    private static Map<String, Number> fSelectors = new HashMap<String, Number>();
    public static Class OS;
    public static Class NSUInteger;

    static {
        try {
            OS = Class.forName("org.eclipse.swt.internal.cocoa.OS");
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        boolean is64bit = System.getProperty("os.arch").equals("x86_64");
        NSUInteger = is64bit ? Long.TYPE : Integer.TYPE;
    }

    public static long getID(Object id) throws Exception {
        return ((Number)MacOSReflect.getField(id, "id")).longValue();
    }

    public static void objc_msgSend(long target, long sel, long arg) throws Exception {
        MacOSReflect.executeLong((Object)OS, "objc_msgSend", new Class[]{NSUInteger, NSUInteger, NSUInteger}, new Object[]{target, sel, arg});
    }

    public static long selector(String sel) throws Exception {
        Number selector = fSelectors.get(sel);
        if (selector == null) {
            selector = (Number)OS.getMethod("sel_registerName", String.class).invoke(null, sel);
            fSelectors.put(sel, selector);
        }
        return selector.longValue();
    }

    public static Object getNSWindow(Shell shell) throws Exception {
        Field fieldView = Control.class.getDeclaredField("view");
        Object nsView = fieldView.get(shell);
        Method methodWindow = fieldView.getType().getDeclaredMethod("window", new Class[0]);
        return methodWindow.invoke(nsView, new Object[0]);
    }

    public static long executeLong(Object object, String method, Object ... args) throws Exception {
        Class[] types = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            types[i] = args[i].getClass();
            ++i;
        }
        return MacOSReflect.executeLong(object, method, types, args);
    }

    public static long executeLong(Object object, String method, Class[] types, Object ... args) throws Exception {
        Object[] newArgs;
        Class<?> clazz;
        Class<?> clazz2 = clazz = object instanceof Class ? object : object.getClass();
        if (NSUInteger == Long.TYPE) {
            newArgs = args;
        } else {
            newArgs = new Object[args.length];
            int i = 0;
            while (i < args.length) {
                newArgs[i] = ((Number)args[i]).intValue();
                ++i;
            }
        }
        Method m = clazz.getMethod(method, types);
        Number n = (Number)m.invoke(object, newArgs);
        return n == null ? -1L : n.longValue();
    }

    public static Object getField(Object object, String field) throws Exception {
        return (object instanceof Class ? (Class<?>)object : object.getClass()).getField(field).get(object);
    }

    public static Object getPrivateField(Object object, String field) throws Exception {
        Field f = object.getClass().getDeclaredField(field);
        f.setAccessible(true);
        return f.get(object);
    }

    public static Object executeMethod(Object object, String method) throws Exception {
        Class<?> clazz = object instanceof Class ? object : object.getClass();
        Method m = clazz.getDeclaredMethod(method, new Class[0]);
        m.setAccessible(true);
        return m.invoke(object, new Object[0]);
    }
}

