/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.utils;

import com.archimatetool.editor.ui.ImageFactory;
import com.archimatetool.editor.utils.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public final class ZipUtils {
    public static boolean isZipFile(File file) throws IOException {
        byte[] sig = new byte[]{80, 75, 3, 4};
        if (file != null && file.canRead()) {
            byte[] buf = new byte[4];
            try (FileInputStream is = null;){
                is = new FileInputStream(file);
                is.read(buf);
            }
            int i = 0;
            while (i < buf.length) {
                if (buf[i] != sig[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static void addFolderToZip(File srcFolder, ZipOutputStream zOut, File[] exclude, IProgressMonitor progressMonitor) throws IOException {
        if (!srcFolder.isDirectory()) {
            throw new IOException("Not a folder");
        }
        ZipUtils.addFolderToZip(srcFolder, srcFolder, zOut, exclude, progressMonitor);
    }

    private static void addFolderToZip(File rootFolder, File srcFolder, ZipOutputStream zOut, File[] exclude, IProgressMonitor progressMonitor) throws IOException {
        File[] files = srcFolder.listFiles();
        int i = 0;
        while (i < files.length) {
            if (progressMonitor != null) {
                progressMonitor.setTaskName(files[i].getName());
                if (progressMonitor.isCanceled()) {
                    throw new IOException("User cancelled.");
                }
            }
            if (files[i].isDirectory()) {
                ZipUtils.addFolderToZip(rootFolder, files[i], zOut, exclude, progressMonitor);
            } else {
                boolean do_add_file = true;
                if (exclude != null) {
                    File[] fileArray = exclude;
                    int n = exclude.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file_exclude = fileArray[n2];
                        if (file_exclude.equals(files[i])) {
                            do_add_file = false;
                            break;
                        }
                        ++n2;
                    }
                }
                if (do_add_file) {
                    String entryName = FileUtils.getRelativePath(files[i], rootFolder);
                    ZipUtils.addFileToZip(files[i], entryName, zOut);
                }
            }
            ++i;
        }
    }

    public static void addFileToZip(File file, String entryName, ZipOutputStream zOut) throws IOException {
        int bytesRead;
        if (file.isDirectory()) {
            return;
        }
        byte[] buf = new byte[8192];
        ZipEntry zipEntry = new ZipEntry(entryName);
        zipEntry.setTime(file.lastModified());
        try {
            zOut.putNextEntry(zipEntry);
        }
        catch (IOException iOException) {
            return;
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file), 8192);
        while ((bytesRead = in.read(buf)) != -1) {
            zOut.write(buf, 0, bytesRead);
        }
        zOut.closeEntry();
        in.close();
    }

    public static void addImageToZip(Image image, String entryName, ZipOutputStream zOut, int format, IProgressMonitor progressMonitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(entryName);
        try {
            zOut.putNextEntry(zipEntry);
        }
        catch (IOException iOException) {
            return;
        }
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{image.getImageData(ImageFactory.getDeviceZoom())};
        loader.save((OutputStream)zOut, format);
        zOut.closeEntry();
    }

    public static void addStringToZip(String text, String entryName, ZipOutputStream zOut) throws IOException {
        ZipUtils.addStringToZip(text, entryName, zOut, null);
    }

    public static void addStringToZip(String text, String entryName, ZipOutputStream zOut, Charset charset) throws IOException {
        ZipEntry zipEntry = new ZipEntry(entryName);
        zOut.putNextEntry(zipEntry);
        byte[] data = charset != null ? text.getBytes(charset) : text.getBytes();
        zOut.write(data);
        zOut.closeEntry();
    }

    public static boolean hasZipEntry(File zipFile, String entryName) throws IOException {
        ZipEntry zipEntry;
        boolean foundEntry = false;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipFile));
        ZipInputStream zIn = new ZipInputStream(in);
        while ((zipEntry = zIn.getNextEntry()) != null) {
            String zipEntryName = zipEntry.getName();
            if (zipEntryName.equalsIgnoreCase(entryName)) {
                foundEntry = true;
                break;
            }
            zIn.closeEntry();
        }
        zIn.close();
        return foundEntry;
    }

    public static String extractZipEntry(File zipFile, String entryName) throws IOException {
        return ZipUtils.extractZipEntry(zipFile, entryName, null);
    }

    public static String extractZipEntry(File zipFile, String entryName, Charset charset) throws IOException {
        ZipEntry zipEntry;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipFile));
        ZipInputStream zIn = charset != null ? new ZipInputStream((InputStream)in, charset) : new ZipInputStream(in);
        while ((zipEntry = zIn.getNextEntry()) != null) {
            String zipEntryName = zipEntry.getName();
            if (zipEntryName.equalsIgnoreCase(entryName)) break;
            zIn.closeEntry();
        }
        if (zipEntry == null) {
            try {
                zIn.close();
            }
            catch (IOException iOException) {}
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int read = 0;
        while ((read = zIn.read(buffer, 0, buffer.length)) > 0) {
            baos.write(buffer, 0, read);
        }
        String content = charset != null ? baos.toString(charset.name()) : baos.toString();
        baos.close();
        zIn.close();
        return content;
    }

    public static InputStream getZipEntryStream(File zipFile, String entryName) throws IOException {
        ZipEntry zipEntry;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipFile));
        ZipInputStream zIn = new ZipInputStream(in);
        while ((zipEntry = zIn.getNextEntry()) != null) {
            String zipEntryName = zipEntry.getName();
            if (zipEntryName.equalsIgnoreCase(entryName)) break;
            zIn.closeEntry();
        }
        if (zipEntry == null) {
            try {
                zIn.close();
            }
            catch (IOException iOException) {}
            return null;
        }
        return zIn;
    }

    public static File extractZipEntry(File zipFile, String entryName, File outFile) throws IOException {
        int bytesRead;
        ZipEntry zipEntry;
        byte[] buf = new byte[8192];
        if (!outFile.getParentFile().exists()) {
            outFile.getParentFile().mkdirs();
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipFile), 8192);
        ZipInputStream zIn = new ZipInputStream(in);
        while ((zipEntry = zIn.getNextEntry()) != null) {
            String zipEntryName = zipEntry.getName();
            if (zipEntryName.equalsIgnoreCase(entryName)) break;
            zIn.closeEntry();
        }
        if (zipEntry == null) {
            zIn.close();
            return null;
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile), 8192);
        while ((bytesRead = zIn.read(buf)) != -1) {
            out.write(buf, 0, bytesRead);
        }
        out.flush();
        out.close();
        zIn.close();
        outFile.setLastModified(zipEntry.getTime());
        return outFile;
    }

    public static List<String> getZipFileEntryNames(File zipFile) throws IOException {
        ArrayList<String> fileList = new ArrayList<String>();
        if (zipFile == null || !zipFile.canRead()) {
            return fileList;
        }
        ZipInputStream zIn = null;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipFile), 16384);
        zIn = new ZipInputStream(in);
        try {
            try {
                ZipEntry zipEntry;
                while ((zipEntry = zIn.getNextEntry()) != null) {
                    if (!zipEntry.isDirectory()) {
                        String zipEntryName = zipEntry.getName();
                        fileList.add(zipEntryName);
                    }
                    zIn.closeEntry();
                }
            }
            catch (IOException ex) {
                zIn.close();
                throw ex;
            }
        }
        finally {
            zIn.close();
        }
        return fileList;
    }

    public static void unpackZip(File zipFile, File targetFolder) throws IOException {
        ZipUtils.unpackZip(zipFile, targetFolder, null);
    }

    public static void unpackZip(File zipFile, File targetFolder, IProgressMonitor progressMonitor) throws IOException {
        targetFolder.mkdirs();
        BufferedOutputStream out = null;
        byte[] buf = new byte[1024];
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipFile), 1024);
        ZipInputStream zIn = new ZipInputStream(in);
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zIn.getNextEntry()) != null) {
                if (!zipEntry.isDirectory()) {
                    int bytesRead;
                    File outFile = new File(targetFolder, zipEntry.getName());
                    if (!outFile.toPath().normalize().startsWith(targetFolder.toPath())) {
                        zIn.close();
                        throw new IOException("Attempt to write file outside of folder: " + String.valueOf(outFile));
                    }
                    if (!outFile.getParentFile().exists()) {
                        outFile.getParentFile().mkdirs();
                    }
                    out = new BufferedOutputStream(new FileOutputStream(outFile), 1024);
                    if (progressMonitor != null) {
                        progressMonitor.setTaskName(zipEntry.getName());
                    }
                    int sleep_count = 0;
                    while ((bytesRead = zIn.read(buf)) != -1) {
                        out.write(buf, 0, bytesRead);
                        if (sleep_count >= 40) {
                            try {
                                Thread.sleep(2L);
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                            }
                            sleep_count = 0;
                        }
                        ++sleep_count;
                        if (progressMonitor == null || !progressMonitor.isCanceled()) continue;
                        out.flush();
                        out.close();
                        zIn.close();
                        throw new IOException("User Cancelled");
                    }
                    outFile.setLastModified(zipEntry.getTime());
                    out.flush();
                    out.close();
                }
                zIn.closeEntry();
            }
            zIn.close();
        }
        catch (IOException ex) {
            zIn.close();
            if (out != null) {
                out.flush();
                out.close();
            }
            throw ex;
        }
    }
}

