/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.tree;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.actions.ArchiActionFactory;
import com.archimatetool.editor.actions.NewArchimateModelAction;
import com.archimatetool.editor.actions.OpenModelAction;
import com.archimatetool.editor.model.IEditorModelManager;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.ThemeUtils;
import com.archimatetool.editor.ui.findreplace.IFindReplaceProvider;
import com.archimatetool.editor.ui.services.EditorManager;
import com.archimatetool.editor.ui.services.IUIRequestListener;
import com.archimatetool.editor.ui.services.UIRequest;
import com.archimatetool.editor.ui.services.UIRequestManager;
import com.archimatetool.editor.ui.services.ViewManager;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.editor.views.AbstractModelView;
import com.archimatetool.editor.views.tree.ITreeModelView;
import com.archimatetool.editor.views.tree.Messages;
import com.archimatetool.editor.views.tree.TreeEditElementRequest;
import com.archimatetool.editor.views.tree.TreeModelCutAndPaste;
import com.archimatetool.editor.views.tree.TreeModelViewer;
import com.archimatetool.editor.views.tree.TreeModelViewerDragDropHandler;
import com.archimatetool.editor.views.tree.TreeModelViewerFindReplaceProvider;
import com.archimatetool.editor.views.tree.TreeSelectionRequest;
import com.archimatetool.editor.views.tree.TreeSelectionSynchroniser;
import com.archimatetool.editor.views.tree.TreeStateHelper;
import com.archimatetool.editor.views.tree.actions.CloseModelAction;
import com.archimatetool.editor.views.tree.actions.CutAction;
import com.archimatetool.editor.views.tree.actions.DeleteAction;
import com.archimatetool.editor.views.tree.actions.DuplicateAction;
import com.archimatetool.editor.views.tree.actions.FindReplaceAction;
import com.archimatetool.editor.views.tree.actions.GenerateViewAction;
import com.archimatetool.editor.views.tree.actions.IViewerAction;
import com.archimatetool.editor.views.tree.actions.LinkToEditorAction;
import com.archimatetool.editor.views.tree.actions.OpenDiagramAction;
import com.archimatetool.editor.views.tree.actions.PasteAction;
import com.archimatetool.editor.views.tree.actions.PropertiesAction;
import com.archimatetool.editor.views.tree.actions.RenameAction;
import com.archimatetool.editor.views.tree.actions.SaveModelAction;
import com.archimatetool.editor.views.tree.commands.DuplicateCommandHandler;
import com.archimatetool.editor.views.tree.search.SearchWidget;
import com.archimatetool.model.FolderType;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IFolder;
import com.archimatetool.model.IFolderContainer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.DrillDownAdapter;

public class TreeModelView
extends AbstractModelView
implements ITreeModelView,
IUIRequestListener {
    private TreeModelViewer fTreeViewer;
    private SearchWidget fSearchWidget;
    private IAction fActionToggleSearchField;
    private IAction fActionNewModel;
    private IAction fActionOpenModel;
    private IAction fActionLinkToEditor;
    private IAction fActionFindReplace;
    private IAction fActionCollapseSelected;
    private IAction fActionExpandSelected;
    private IViewerAction fActionProperties;
    private IViewerAction fActionSaveModel;
    private IViewerAction fActionCloseModel;
    private IViewerAction fActionDelete;
    private IViewerAction fActionRename;
    private IViewerAction fActionOpenDiagram;
    private IViewerAction fActionDuplicate;
    private IViewerAction fActionCut;
    private IViewerAction fActionPaste;
    private IViewerAction fActionGenerateView;
    private TreeModelViewerFindReplaceProvider fFindReplaceProvider;
    private TreeSelectionSynchroniser fSynchroniser;
    private DrillDownAdapter fDrillDownAdapter;

    @Override
    public void doCreatePartControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.archimatetool.help.treeModelViewHelp");
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.fTreeViewer = new TreeModelViewer(this.getSite().getWorkbenchWindow(), parent, 0);
        this.fTreeViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.fDrillDownAdapter = new DrillDownAdapter((TreeViewer)this.fTreeViewer);
        this.fTreeViewer.addDoubleClickListener(event -> this.handleOpenAction());
        this.fTreeViewer.addSelectionChangedListener(event -> this.updateActions());
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        this.fSynchroniser = new TreeSelectionSynchroniser(this);
        UIRequestManager.INSTANCE.addListener(this);
        this.makeActions();
        this.hookContextMenu();
        this.registerGlobalActions();
        this.makeLocalToolBar();
        this.makeLocalMenuActions();
        new TreeModelViewerDragDropHandler((StructuredViewer)this.fTreeViewer);
        this.fTreeViewer.setInput(IEditorModelManager.INSTANCE);
        TreeStateHelper.INSTANCE.restoreExpandedTreeElements(this.fTreeViewer);
        this.updateActions();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        TreeStateHelper.INSTANCE.setMemento(memento);
    }

    public void saveState(IMemento memento) {
        TreeStateHelper.INSTANCE.saveStateToMemento(this.fTreeViewer, memento);
    }

    private void handleOpenAction() {
        Object[] objectArray = ((IStructuredSelection)this.getViewer().getSelection()).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selected = objectArray[n2];
            if (selected instanceof IArchimateConcept) {
                ViewManager.showViewPart(ViewManager.PROPERTIES_VIEW, false);
            }
            if (selected instanceof IFolder) {
                ViewManager.showViewPart(ViewManager.PROPERTIES_VIEW, false);
            } else if (selected instanceof IArchimateModel) {
                ViewManager.showViewPart(ViewManager.PROPERTIES_VIEW, false);
            } else if (selected instanceof IDiagramModel) {
                EditorManager.openDiagramEditor((IDiagramModel)selected);
            }
            ++n2;
        }
    }

    private void showSearchWidget() {
        this.fSearchWidget = new SearchWidget(this.fTreeViewer);
        this.fSearchWidget.moveAbove(this.fTreeViewer.getControl());
        this.fTreeViewer.getControl().getParent().layout();
        this.fSearchWidget.setFocus();
    }

    private void removeSearchWidget() {
        if (this.fSearchWidget != null && !this.fSearchWidget.isDisposed()) {
            this.fSearchWidget.dispose();
            this.fSearchWidget = null;
            this.fTreeViewer.getControl().getParent().layout();
        }
    }

    public void setFocus() {
        this.fTreeViewer.getControl().setFocus();
    }

    @Override
    protected void selectAll() {
        if (this.fTreeViewer != null) {
            this.fTreeViewer.getTree().selectAll();
        }
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.fTreeViewer;
    }

    public TreeModelViewer getViewer() {
        return this.fTreeViewer;
    }

    private void makeActions() {
        IWorkbenchWindow window = this.getViewSite().getWorkbenchWindow();
        this.fActionNewModel = new NewArchimateModelAction();
        this.fActionOpenModel = new OpenModelAction(window);
        this.fActionOpenDiagram = new OpenDiagramAction(this.getSelectionProvider());
        this.fActionCloseModel = new CloseModelAction(this.getSelectionProvider());
        this.fActionSaveModel = new SaveModelAction(this);
        this.fActionDelete = new DeleteAction(this.getViewer());
        this.fActionRename = new RenameAction(this.getViewer());
        this.fActionFindReplace = new FindReplaceAction(this);
        this.fActionProperties = new PropertiesAction(this.getSelectionProvider());
        this.fActionLinkToEditor = new LinkToEditorAction();
        this.fActionDuplicate = new DuplicateAction((ISelectionProvider)this.getViewer());
        this.fActionCut = new CutAction((ISelectionProvider)this.getViewer());
        this.fActionPaste = new PasteAction((ISelectionProvider)this.getViewer());
        this.fActionGenerateView = new GenerateViewAction(this.getSelectionProvider());
        this.fActionToggleSearchField = new Action("", 2){

            public void run() {
                if (this.isChecked()) {
                    TreeModelView.this.showSearchWidget();
                } else {
                    TreeModelView.this.removeSearchWidget();
                }
            }

            public String getToolTipText() {
                return Messages.TreeModelView_0;
            }

            public ImageDescriptor getImageDescriptor() {
                return ThemeUtils.isDarkTheme() ? IArchiImages.ImageFactory.getImageDescriptor("img/search_light.png") : IArchiImages.ImageFactory.getImageDescriptor("img/search.png");
            }
        };
        this.fActionCollapseSelected = new Action(Messages.TreeModelView_3){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)TreeModelView.this.getViewer().getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (TreeModelView.this.fTreeViewer.isExpandable(o) && TreeModelView.this.fTreeViewer.getExpandedState(o)) {
                        TreeModelView.this.fTreeViewer.collapseToLevel(o, -1);
                    }
                    ++n2;
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return IArchiImages.ImageFactory.getImageDescriptor("img/collapseall.png");
            }

            public String getActionDefinitionId() {
                return "org.eclipse.ui.navigate.collapseAll";
            }
        };
        this.fActionExpandSelected = new Action(Messages.TreeModelView_4){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)TreeModelView.this.getViewer().getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (TreeModelView.this.hasExpandableNodes(o)) {
                        TreeModelView.this.fTreeViewer.expandToLevel(o, -1);
                    }
                    ++n2;
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return IArchiImages.ImageFactory.getImageDescriptor("img/expandall.png");
            }

            public String getActionDefinitionId() {
                return "org.eclipse.ui.navigate.expandAll";
            }
        };
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        handlerService.activateHandler("org.eclipse.ui.navigate.collapseAll", (IHandler)new ActionHandler(this.fActionCollapseSelected));
        handlerService.activateHandler("org.eclipse.ui.navigate.expandAll", (IHandler)new ActionHandler(this.fActionExpandSelected));
    }

    private void registerGlobalActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ArchiActionFactory.CLOSE_MODEL.getId(), (IAction)this.fActionCloseModel);
        actionBars.setGlobalActionHandler(ArchiActionFactory.OPEN_DIAGRAM.getId(), (IAction)this.fActionOpenDiagram);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.fActionDelete);
        actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.fActionProperties);
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.fActionRename);
        actionBars.setGlobalActionHandler(ArchiActionFactory.DUPLICATE.getId(), (IAction)this.fActionDuplicate);
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.fActionCut);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.fActionPaste);
        actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.fActionFindReplace);
        actionBars.setGlobalActionHandler(ArchiActionFactory.GENERATE_VIEW.getId(), (IAction)this.fActionGenerateView);
    }

    private void disableGlobalActions() {
        this.fActionFindReplace.setEnabled(false);
        this.fActionSelectAll.setEnabled(false);
        this.updateActions();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#TreeModelViewPopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TreeModelView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.getViewer().getControl());
        this.getViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.getViewer());
    }

    private void fillContextMenu(IMenuManager manager) {
        boolean isEmpty;
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        Object selected = selection.getFirstElement();
        boolean bl = isEmpty = selected == null;
        if (isEmpty && this.fTreeViewer.getInput() instanceof IEditorModelManager) {
            manager.add(this.fActionNewModel);
            manager.add(this.fActionOpenModel);
            return;
        }
        manager.add((IContributionItem)new Separator("new"));
        manager.add((IContributionItem)new Separator());
        if (selected instanceof IArchimateModel) {
            manager.add((IAction)this.fActionCloseModel);
            manager.add((IAction)this.fActionSaveModel);
            manager.add((IContributionItem)new Separator());
        }
        if (selected instanceof IDiagramModel) {
            manager.add((IAction)this.fActionOpenDiagram);
            manager.add((IContributionItem)new Separator("open"));
        }
        if (!isEmpty) {
            Object o;
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.fActionCut);
            manager.add((IAction)this.fActionPaste);
            manager.add((IAction)this.fActionDelete);
            manager.add((IContributionItem)new Separator("start_collapse"));
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                o = objectArray[n2];
                if (this.hasExpandableNodes(o)) {
                    manager.add(this.fActionExpandSelected);
                    break;
                }
                ++n2;
            }
            objectArray = selection.toArray();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                o = objectArray[n2];
                if (this.fTreeViewer.isExpandable(o) && this.fTreeViewer.getExpandedState(o)) {
                    manager.add(this.fActionCollapseSelected);
                    break;
                }
                ++n2;
            }
            manager.add((IContributionItem)new Separator("end_collapse"));
        }
        if (this.fDrillDownAdapter.canGoInto() || this.fDrillDownAdapter.canGoBack() || this.fDrillDownAdapter.canGoHome()) {
            this.fDrillDownAdapter.addNavigationActions(manager);
            manager.add((IContributionItem)new Separator("drill"));
        }
        if (!isEmpty) {
            if (DuplicateCommandHandler.canDuplicate(selection)) {
                manager.add((IAction)this.fActionDuplicate);
            }
            manager.add((IAction)this.fActionRename);
            manager.add((IContributionItem)new Separator("start_extensions"));
            manager.add((IAction)this.fActionGenerateView);
            manager.add((IContributionItem)new GroupMarker("append_extensions"));
            manager.add((IContributionItem)new Separator("end_extensions"));
            manager.add((IContributionItem)new Separator("start_properties"));
            manager.add((IAction)this.fActionProperties);
            manager.add((IContributionItem)new GroupMarker("append_properties"));
            manager.add((IContributionItem)new Separator("end_properties"));
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void updateActions() {
        this.fActionSaveModel.update();
        this.fActionOpenDiagram.update();
        this.fActionCloseModel.update();
        this.fActionDelete.update();
        this.fActionDuplicate.update();
        this.fActionCut.update();
        this.fActionPaste.update();
        this.fActionRename.update();
        this.fActionProperties.update();
        this.fActionGenerateView.update();
        this.updateUndoActions();
    }

    private void makeLocalToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        this.fDrillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator());
        manager.add(this.fActionToggleSearchField);
        manager.add(this.fActionLinkToEditor);
    }

    private void makeLocalMenuActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager manager = actionBars.getMenuManager();
        MenuManager filterMenu = new MenuManager(Messages.TreeModelView_5);
        manager.add((IContributionItem)filterMenu);
        final ArrayList<FolderFilterAction> filterActions = new ArrayList<FolderFilterAction>();
        class FolderFilterAction
        extends Action {
            FolderType folderType;
            String prefsKey;
            ViewerFilter filter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    IFolder folder;
                    return element instanceof IFolder ? (folder = (IFolder)element).getType() != folderType : true;
                }
            };

            FolderFilterAction(FolderType folderType) {
                this.folderType = folderType;
                this.prefsKey = "modelTreeFolderHidden_" + folderType.getName();
                this.setText(StringUtils.escapeAmpersandsInText(folderType.getLabel()));
                boolean hidden = ArchiPlugin.getInstance().getPreferenceStore().getBoolean(this.prefsKey);
                this.setChecked(!hidden);
                if (hidden) {
                    TreeModelView.this.getViewer().addFilter(this.filter);
                }
            }

            public void run() {
                if (this.isChecked()) {
                    TreeModelView.this.getViewer().removeFilter(this.filter);
                } else {
                    TreeModelView.this.getViewer().addFilter(this.filter);
                }
                ArchiPlugin.getInstance().getPreferenceStore().setValue(this.prefsKey, !this.isChecked());
            }
        }
        filterActions.add(new FolderFilterAction(FolderType.STRATEGY));
        filterActions.add(new FolderFilterAction(FolderType.BUSINESS));
        filterActions.add(new FolderFilterAction(FolderType.APPLICATION));
        filterActions.add(new FolderFilterAction(FolderType.TECHNOLOGY));
        filterActions.add(new FolderFilterAction(FolderType.MOTIVATION));
        filterActions.add(new FolderFilterAction(FolderType.IMPLEMENTATION_MIGRATION));
        filterActions.add(new FolderFilterAction(FolderType.OTHER));
        filterActions.add(new FolderFilterAction(FolderType.RELATIONS));
        filterActions.add(new FolderFilterAction(FolderType.DIAGRAMS));
        for (Action action : filterActions) {
            filterMenu.add((IAction)action);
        }
        filterMenu.add((IContributionItem)new Separator());
        filterMenu.add((IAction)new Action(Messages.TreeModelView_6){

            public void run() {
                ArrayList<ViewerFilter> filtersToRemove = new ArrayList<ViewerFilter>();
                for (FolderFilterAction action : filterActions) {
                    if (action.isChecked()) continue;
                    action.setChecked(true);
                    ArchiPlugin.getInstance().getPreferenceStore().setValue(action.prefsKey, false);
                    filtersToRemove.add(action.filter);
                }
                if (filtersToRemove.isEmpty()) {
                    return;
                }
                ViewerFilter[] filters = (ViewerFilter[])Arrays.stream(TreeModelView.this.getViewer().getFilters()).filter(e -> !filtersToRemove.contains(e)).toArray(ViewerFilter[]::new);
                TreeModelView.this.getViewer().setFilters(filters);
            }
        });
    }

    private boolean hasExpandableNodes(Object object) {
        if (this.fTreeViewer.isExpandable(object) && !this.fTreeViewer.getExpandedState(object)) {
            return true;
        }
        if (object instanceof IFolderContainer) {
            for (IFolder folder : ((IFolderContainer)object).getFolders()) {
                if (!this.hasExpandableNodes(folder)) continue;
                return true;
            }
        }
        return false;
    }

    private void checkDrillDownHasValidInput() {
        IArchimateModelObject modelObject;
        Object object = this.fTreeViewer.getInput();
        if (object instanceof IArchimateModelObject && (modelObject = (IArchimateModelObject)object).getArchimateModel() == null) {
            this.setDrillDownHome();
        }
    }

    private void setDrillDownHome() {
        if (this.fDrillDownAdapter.canGoHome()) {
            try {
                this.getViewer().getControl().setRedraw(false);
                this.fDrillDownAdapter.goHome();
            }
            finally {
                this.getViewer().getControl().setRedraw(true);
            }
        }
    }

    @Override
    protected void applicationPreferencesChanged(PropertyChangeEvent event) {
        switch (event.getProperty()) {
            case "viewpointsFilterModelTree": 
            case "highlightUnusedElementsInModelTree": {
                this.getViewer().update();
                break;
            }
            case "treeDisplayNodeIncrement": {
                int limit = ArchiPlugin.getInstance().getPreferenceStore().getInt("treeDisplayNodeIncrement");
                this.getViewer().setDisplayIncrementally(limit);
                if (this.fDrillDownAdapter.canGoHome()) {
                    this.setDrillDownHome();
                    break;
                }
                this.getViewer().setInputPreservingExpandedNodes(IEditorModelManager.INSTANCE);
            }
        }
        if (event.getProperty().startsWith("folderColour_")) {
            this.getViewer().update();
        }
    }

    @Override
    protected IArchimateModel getActiveArchimateModel() {
        if (this.getViewer() != null) {
            Object selected = this.getViewer().getStructuredSelection().getFirstElement();
            if (selected instanceof IArchimateModelObject) {
                return ((IArchimateModelObject)selected).getArchimateModel();
            }
            if (this.getViewer().getInput() instanceof IArchimateModelObject) {
                return ((IArchimateModelObject)this.getViewer().getInput()).getArchimateModel();
            }
        }
        return null;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IFindReplaceProvider.class) {
            if (this.fFindReplaceProvider == null) {
                this.fFindReplaceProvider = new TreeModelViewerFindReplaceProvider(this.getViewer());
            }
            return adapter.cast(this.fFindReplaceProvider);
        }
        return super.getAdapter(adapter);
    }

    @Override
    public void dispose() {
        super.dispose();
        UIRequestManager.INSTANCE.removeListener(this);
        try {
            IEditorModelManager.INSTANCE.saveState();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.disableGlobalActions();
        this.fTreeViewer = null;
        this.fFindReplaceProvider = null;
        this.fSynchroniser = null;
        this.fDrillDownAdapter = null;
        this.fSearchWidget = null;
        this.fActionFindReplace = null;
        this.fActionProperties = null;
        this.fActionDuplicate = null;
        this.fActionCut = null;
        this.fActionPaste = null;
        this.fActionGenerateView = null;
        this.fActionToggleSearchField = null;
        this.fActionCollapseSelected = null;
        this.fActionExpandSelected = null;
        this.fActionLinkToEditor = null;
        this.fActionOpenDiagram = null;
        this.fActionCloseModel = null;
        this.fActionSaveModel = null;
        this.fActionDelete = null;
        TreeModelCutAndPaste.INSTANCE.clear();
    }

    @Override
    public void propertyChange(java.beans.PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        Object source = evt.getSource();
        if (propertyName == "IEditorModelManager.model.created" || propertyName == "IEditorModelManager.model.opened") {
            this.setDrillDownHome();
            this.getViewer().refreshTreePreservingExpandedNodes();
            IArchimateModel model = (IArchimateModel)evt.getNewValue();
            this.getViewer().expandToLevel(model.getFolder(FolderType.DIAGRAMS), 1);
            this.getViewer().setSelection((ISelection)new StructuredSelection((Object)model), true);
            if (propertyName == "IEditorModelManager.model.opened" && this.fSearchWidget != null && !this.fSearchWidget.isDisposed()) {
                this.fSearchWidget.softReset();
            }
        } else if (propertyName == "IEditorModelManager.model.removed") {
            TreeModelCutAndPaste.INSTANCE.clear();
            this.checkDrillDownHasValidInput();
            if (this.fSearchWidget != null && !this.fSearchWidget.isDisposed()) {
                this.fSearchWidget.softReset();
            }
            this.getViewer().refreshTreePreservingExpandedNodes();
        } else if (propertyName == "IEditorModelManager.model.dirty") {
            this.updateActions();
            this.getViewer().update(source, null);
        } else if (propertyName == "IEditorModelManager.ecore.events.start") {
            super.propertyChange(evt);
            this.fSynchroniser.setSynchronise(false);
        } else if (propertyName == "IEditorModelManager.ecore.events.end") {
            super.propertyChange(evt);
            this.fSynchroniser.setSynchronise(true);
        } else {
            super.propertyChange(evt);
        }
    }

    @Override
    public void requestAction(UIRequest request) {
        if (request instanceof TreeSelectionRequest) {
            TreeSelectionRequest req = (TreeSelectionRequest)request;
            if (req.shouldSelect((Viewer)this.getViewer())) {
                this.getViewer().setSelection((ISelection)req.getSelection(), req.doReveal());
            }
        } else if (request instanceof TreeEditElementRequest) {
            this.getViewer().editElement(request.getTarget());
        }
    }

    @Override
    protected void eCoreChanged(Notification msg) {
        int type = msg.getEventType();
        Object notifier = msg.getNotifier();
        Object feature = msg.getFeature();
        if (type == 1) {
            if (feature == IArchimatePackage.Literals.ARCHIMATE_DIAGRAM_MODEL__VIEWPOINT && ArchiPlugin.getInstance().getPreferenceStore().getBoolean("viewpointsFilterModelTree") && notifier instanceof IDiagramModel) {
                IDiagramModel dm = (IDiagramModel)notifier;
                this.getViewer().updateInBackground(dm.getArchimateModel());
            } else {
                super.eCoreChanged(msg);
            }
        } else {
            super.eCoreChanged(msg);
            this.checkDrillDownHasValidInput();
        }
    }

    @Override
    protected void doRefreshFromNotifications(final List<Notification> notifications) {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!TreeModelView.this.getViewer().getControl().isDisposed() && notifications != null) {
                    TreeModelView.this.refreshFromNotifications(notifications);
                }
            }
        });
    }

    private void refreshFromNotifications(List<Notification> notifications) {
        EObject parent;
        HashSet<EObject> refreshElements = new HashSet<EObject>();
        HashSet<EObject> updateElements = new HashSet<EObject>();
        for (Notification msg : notifications) {
            parent = this.getParentToRefreshFromNotification(msg);
            if (parent != null) {
                refreshElements.add(parent);
            }
            updateElements.addAll(this.getElementsToUpdateFromNotification(msg));
        }
        for (EObject object : new HashSet(refreshElements)) {
            parent = object.eContainer();
            while (parent != null) {
                if (refreshElements.contains(parent)) {
                    refreshElements.remove(object);
                }
                parent = parent.eContainer();
            }
        }
        try {
            this.getViewer().getControl().setRedraw(false);
            for (EObject object : refreshElements) {
                this.getViewer().refresh(object);
            }
            for (EObject object : updateElements) {
                this.getViewer().update(object, null);
            }
        }
        finally {
            this.getViewer().getControl().setRedraw(true);
        }
        this.checkDrillDownHasValidInput();
    }

    public int getContextChangeMask() {
        return 0;
    }

    public IContext getContext(Object target) {
        return HelpSystem.getContext((String)"com.archimatetool.help.treeModelViewHelp");
    }

    public String getSearchExpression(Object target) {
        return Messages.TreeModelView_2;
    }
}

