/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.tree;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.model.DiagramModelUtils;
import com.archimatetool.editor.model.IEditorModelManager;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.ui.FontFactory;
import com.archimatetool.editor.ui.ThemeUtils;
import com.archimatetool.editor.ui.components.TreeTextCellEditor;
import com.archimatetool.editor.ui.textrender.TextRenderer;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.editor.views.tree.TreeViewpointFilterProvider;
import com.archimatetool.editor.views.tree.commands.RenameCommandHandler;
import com.archimatetool.editor.views.tree.search.SearchFilter;
import com.archimatetool.model.FolderType;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IFolder;
import com.archimatetool.model.INameable;
import java.text.Collator;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;

public class TreeModelViewer
extends TreeViewer {
    private TreeViewpointFilterProvider viewpointFilterProvider;
    private SearchFilter searchFilter;
    private Object[] rootVisibleExpandedElements;
    private IPropertyChangeListener propertyChangeListener = event -> {
        if ("com.archimatetool.editor.MODEL_TREE_FONT".equals(event.getProperty())) {
            ((ModelTreeViewerLabelProvider)this.getLabelProvider()).resetFonts();
        }
    };

    public TreeModelViewer(Composite parent, int style) {
        this(null, parent, style);
    }

    public TreeModelViewer(IWorkbenchWindow window, Composite parent, int style) {
        super(parent, style | 2);
        ThemeUtils.registerCssId((Control)this.getTree(), "ModelTree");
        ThemeUtils.applyStyles((Control)this.getTree(), false);
        ThemeUtils.setFontIfCssThemingDisabled((Control)this.getTree(), "com.archimatetool.editor.MODEL_TREE_FONT");
        this.setContentProvider((IContentProvider)new ModelTreeViewerContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new ModelTreeViewerLabelProvider());
        this.setUseHashlookup(true);
        int limit = ArchiPlugin.getInstance().getPreferenceStore().getInt("treeDisplayNodeIncrement");
        this.setDisplayIncrementally(limit);
        this.setComparator(new ViewerComparator(Collator.getInstance()){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String label2;
                String label1;
                int cat2;
                int cat1 = this.category(e1);
                if (cat1 != (cat2 = this.category(e2))) {
                    return cat1 - cat2;
                }
                if (e1 instanceof IFolder) {
                    IFolder folder1 = (IFolder)e1;
                    if (e2 instanceof IFolder) {
                        IFolder folder2 = (IFolder)e2;
                        if (folder1.getType() != FolderType.USER || folder2.getType() != FolderType.USER) {
                            return 0;
                        }
                    }
                }
                if ((label1 = TreeModelViewer.this.getAncestorFolderRenderText((IArchimateModelObject)e1)) == null) {
                    label1 = StringUtils.safeString(ArchiLabelProvider.INSTANCE.getLabelNormalised(e1));
                }
                if ((label2 = TreeModelViewer.this.getAncestorFolderRenderText((IArchimateModelObject)e2)) == null) {
                    label2 = StringUtils.safeString(ArchiLabelProvider.INSTANCE.getLabelNormalised(e2));
                }
                return this.getComparator().compare(label1, label2);
            }

            public int category(Object element) {
                if (element instanceof IFolder) {
                    return 0;
                }
                if (element instanceof EObject) {
                    return 1;
                }
                return 0;
            }
        });
        TreeTextCellEditor cellEditor = new TreeTextCellEditor(this.getTree());
        this.setColumnProperties(new String[]{"col1"});
        this.setCellEditors(new CellEditor[]{cellEditor});
        TreeViewerEditor.create((TreeViewer)this, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 4;
            }
        }, (int)1);
        this.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                TreeItem treeItem;
                Object object;
                if (element instanceof TreeItem && (object = (treeItem = (TreeItem)element).getData()) instanceof INameable) {
                    INameable nameable = (INameable)object;
                    RenameCommandHandler.doRenameCommand(nameable, value.toString());
                }
            }

            public Object getValue(Object element, String property) {
                if (element instanceof INameable) {
                    INameable nameable = (INameable)element;
                    return nameable.getName();
                }
                return null;
            }

            public boolean canModify(Object element, String property) {
                return RenameCommandHandler.canRename(element);
            }
        });
        if (window != null) {
            this.viewpointFilterProvider = new TreeViewpointFilterProvider(window, this);
        }
        if (ThemeUtils.getThemeManager() != null) {
            ThemeUtils.getThemeManager().addPropertyChangeListener(this.propertyChangeListener);
        }
        this.getTree().addDisposeListener(e -> {
            if (ThemeUtils.getThemeManager() != null) {
                ThemeUtils.getThemeManager().removePropertyChangeListener(this.propertyChangeListener);
            }
            this.viewpointFilterProvider = null;
            this.searchFilter = null;
            this.rootVisibleExpandedElements = null;
        });
    }

    public void editElement(Object element) {
        this.editElement(element, 0);
    }

    public void editElement(Object element, int column) {
        this.getControl().setFocus();
        super.editElement(element, column);
    }

    void refreshInBackground() {
        this.refreshInBackground(null);
    }

    void refreshInBackground(Object element) {
        this.getControl().getDisplay().asyncExec(() -> {
            if (!this.getControl().isDisposed()) {
                try {
                    this.getControl().setRedraw(false);
                    this.refresh(element != null ? (this.findItem(element) != null ? element : null) : null);
                }
                finally {
                    this.getControl().setRedraw(true);
                }
            }
        });
    }

    void updateInBackground() {
        this.updateInBackground(null);
    }

    void updateInBackground(Object element) {
        this.getControl().getDisplay().asyncExec(() -> {
            if (!this.getControl().isDisposed()) {
                this.update(element);
            }
        });
    }

    void update() {
        this.update(null);
    }

    void update(Object element) {
        try {
            this.getControl().setRedraw(false);
            element = element == null ? this.getRoot() : element;
            this.updateElement(element);
        }
        finally {
            this.getControl().setRedraw(true);
        }
    }

    private void updateElement(Object element) {
        if (element != null) {
            this.update(element, null);
            Object[] objectArray = ((ITreeContentProvider)this.getContentProvider()).getChildren(element);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.updateElement(child);
                ++n2;
            }
        }
    }

    void refreshTreePreservingExpandedNodes() {
        try {
            Object[] expanded = this.getExpandedElements();
            this.getControl().setRedraw(false);
            this.refresh();
            this.setExpandedElements(expanded);
        }
        finally {
            this.getControl().setRedraw(true);
        }
    }

    void setInputPreservingExpandedNodes(Object input) {
        try {
            Object[] expanded = this.getExpandedElements();
            this.getControl().setRedraw(false);
            this.setInput(input);
            this.setExpandedElements(expanded);
        }
        finally {
            this.getControl().setRedraw(true);
        }
    }

    public TreeItem findTreeItem(Object element) {
        Widget item = this.findItem(element);
        return (TreeItem)(item instanceof TreeItem ? item : null);
    }

    public void addFilter(ViewerFilter filter) {
        if (filter instanceof SearchFilter) {
            SearchFilter searchFilter;
            this.searchFilter = searchFilter = (SearchFilter)filter;
        }
        super.addFilter(filter);
    }

    public void removeFilter(ViewerFilter filter) {
        if (filter instanceof SearchFilter) {
            this.searchFilter = null;
        }
        super.removeFilter(filter);
    }

    protected Object[] getSortedChildren(Object parentElementOrTreePath) {
        return super.getSortedChildren(parentElementOrTreePath);
    }

    private String getAncestorFolderRenderText(IArchimateModelObject object) {
        String text;
        String expression;
        if ((object instanceof IArchimateConcept || object instanceof IDiagramModel) && (expression = TextRenderer.getDefault().getFormatExpressionFromAncestorFolder(object)) != null && StringUtils.isSet(text = StringUtils.normaliseNewLineCharacters(TextRenderer.getDefault().renderWithExpression(object, expression)))) {
            return text.length() > 256 ? text.substring(0, 256) : text;
        }
        return null;
    }

    Object[] getRootVisibleExpandedElements() {
        return this.rootVisibleExpandedElements != null ? this.rootVisibleExpandedElements : this.getVisibleExpandedElements();
    }

    private class ModelTreeViewerContentProvider
    implements ITreeContentProvider {
        private ModelTreeViewerContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (oldInput == IEditorModelManager.INSTANCE && newInput != null) {
                TreeModelViewer.this.rootVisibleExpandedElements = TreeModelViewer.this.getVisibleExpandedElements();
            } else if (newInput == IEditorModelManager.INSTANCE) {
                TreeModelViewer.this.rootVisibleExpandedElements = null;
            }
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IEditorModelManager) {
                IEditorModelManager editorModelManager = (IEditorModelManager)parentElement;
                return editorModelManager.getModels().toArray();
            }
            if (parentElement instanceof IArchimateModel) {
                IArchimateModel model = (IArchimateModel)parentElement;
                return model.getFolders().toArray();
            }
            if (parentElement instanceof IFolder) {
                IFolder folder = (IFolder)parentElement;
                ArrayList list = new ArrayList();
                list.addAll(folder.getFolders());
                list.addAll(folder.getElements());
                return list.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof EObject) {
                EObject eObject = (EObject)element;
                return eObject.eContainer();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return TreeModelViewer.this.getFilteredChildren(element).length > 0;
        }
    }

    private class ModelTreeViewerLabelProvider
    extends CellLabelProvider {
        private Font fontItalic;
        private Font fontBold;
        private Font fontBoldItalic;

        private ModelTreeViewerLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            cell.setText(this.getText(element));
            cell.setImage(this.getImage(element));
            cell.setForeground(this.getForeground(element));
            cell.setFont(this.getFont(element));
        }

        private void resetFonts() {
            this.fontItalic = null;
            this.fontBold = null;
            this.fontBoldItalic = null;
            TreeModelViewer.this.updateInBackground();
        }

        private String getText(Object element) {
            IArchimateModel model;
            String text = TreeModelViewer.this.getAncestorFolderRenderText((IArchimateModelObject)element);
            if (text != null) {
                return text;
            }
            Object name = ArchiLabelProvider.INSTANCE.getLabelNormalised(element);
            if (element instanceof IArchimateModel && IEditorModelManager.INSTANCE.isModelDirty(model = (IArchimateModel)element)) {
                name = "*" + (String)name;
            } else if (element instanceof IArchimateRelationship) {
                IArchimateRelationship relationship = (IArchimateRelationship)element;
                name = (String)name + " (";
                name = (String)name + ArchiLabelProvider.INSTANCE.getLabelNormalised(relationship.getSource());
                name = (String)name + " - ";
                name = (String)name + ArchiLabelProvider.INSTANCE.getLabelNormalised(relationship.getTarget());
                name = (String)name + ")";
            }
            return name;
        }

        private Image getImage(Object element) {
            return ArchiLabelProvider.INSTANCE.getImage(element);
        }

        /*
         * Unable to fully structure code
         */
        private Font getFont(Object element) {
            v0 = isSearching = TreeModelViewer.this.searchFilter != null && TreeModelViewer.this.searchFilter.isFiltering() != false && TreeModelViewer.this.searchFilter.matchesFilter(element) != false;
            if (!(element instanceof IArchimateConcept)) ** GOTO lbl-1000
            concept = (IArchimateConcept)element;
            if (ArchiPlugin.getInstance().getPreferenceStore().getBoolean("highlightUnusedElementsInModelTree") && !DiagramModelUtils.isArchimateConceptReferencedInDiagrams(concept)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = isUnusedConcept = false;
            }
            if (isSearching) {
                return isUnusedConcept != false ? this.getBoldItalicFont() : this.getBoldFont();
            }
            return isUnusedConcept != false ? this.getItalicFont() : null;
        }

        private Font getBoldFont() {
            if (this.fontBold == null) {
                this.fontBold = FontFactory.getBold(TreeModelViewer.this.getTree().getFont());
            }
            return this.fontBold;
        }

        private Font getBoldItalicFont() {
            if (this.fontBoldItalic == null) {
                this.fontBoldItalic = FontFactory.getBold(this.getItalicFont());
            }
            return this.fontBoldItalic;
        }

        private Font getItalicFont() {
            if (this.fontItalic == null) {
                this.fontItalic = FontFactory.getItalic(TreeModelViewer.this.getTree().getFont());
            }
            return this.fontItalic;
        }

        private Color getForeground(Object element) {
            return TreeModelViewer.this.viewpointFilterProvider != null ? TreeModelViewer.this.viewpointFilterProvider.getTextColor(element) : null;
        }
    }
}

