/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.tree;

import com.archimatetool.editor.ui.findreplace.AbstractFindReplaceProvider;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.editor.views.tree.TreeModelViewer;
import com.archimatetool.editor.views.tree.commands.RenameCommandHandler;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IFolder;
import com.archimatetool.model.INameable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class TreeModelViewerFindReplaceProvider
extends AbstractFindReplaceProvider {
    private TreeModelViewer fTreeModelViewer;
    boolean replaceSelection = false;

    public TreeModelViewerFindReplaceProvider(TreeModelViewer viewer) {
        this.fTreeModelViewer = viewer;
    }

    @Override
    public boolean find(String toFind) {
        if (this.isAll()) {
            List<INameable> elements = this.getAllMatchingElements(toFind);
            this.fTreeModelViewer.setSelection((ISelection)new StructuredSelection(elements), true);
            return !elements.isEmpty();
        }
        INameable element = this.findNextElement(this.getFirstSelectedObject(), toFind);
        if (element != null) {
            this.fTreeModelViewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
        }
        return element != null;
    }

    @Override
    public boolean replace(String toFind, String toReplaceWith) {
        if (this.isAll()) {
            List<INameable> elements = this.getAllMatchingElements(toFind);
            if (!elements.isEmpty()) {
                ArrayList<String> newNames = new ArrayList<String>();
                for (INameable nameable : elements) {
                    String newName = this.getReplacedString(nameable.getName(), toFind, toReplaceWith);
                    newNames.add(newName);
                }
                RenameCommandHandler.doRenameCommands(elements, newNames);
                this.fTreeModelViewer.setSelection((ISelection)new StructuredSelection(elements), true);
            }
            return !elements.isEmpty();
        }
        if (this.replaceSelection) {
            List<Object> selected = this.getSelectedObjects();
            if (!selected.isEmpty()) {
                ArrayList<INameable> elements = new ArrayList<INameable>();
                ArrayList<String> newNames = new ArrayList<String>();
                for (Object object : selected) {
                    if (!this.matches(object, toFind)) continue;
                    INameable nameable = (INameable)object;
                    elements.add(nameable);
                    String newName = this.getReplacedString(nameable.getName(), toFind, toReplaceWith);
                    newNames.add(newName);
                }
                if (!elements.isEmpty()) {
                    RenameCommandHandler.doRenameCommands(elements, newNames);
                    return true;
                }
            }
        } else {
            Object object = this.getFirstSelectedObject();
            if (this.matches(object, toFind)) {
                RenameCommandHandler.doRenameCommand((INameable)object, this.getReplacedString(((INameable)object).getName(), toFind, toReplaceWith));
                return true;
            }
        }
        return this.find(toFind);
    }

    INameable findNextElement(Object startElement, String toFind) {
        int startIndex;
        List<INameable> elements = this.getAllNameableElements();
        if (elements.isEmpty()) {
            return null;
        }
        int increment = this.isForward() ? 1 : -1;
        int n = startIndex = this.isForward() ? 0 : elements.size() - 1;
        if (startElement != null) {
            startIndex = elements.indexOf(startElement) + increment;
        }
        int i = startIndex;
        while (!(this.isForward() ? i >= elements.size() : i < 0)) {
            INameable element = elements.get(i);
            if (this.matches(element, toFind)) {
                return element;
            }
            i += increment;
        }
        return null;
    }

    List<INameable> getAllMatchingElements(String toFind) {
        if (this.isAllModels()) {
            return this.getMatchingElements(this.fTreeModelViewer.getInput(), toFind);
        }
        return this.getMatchingElements(this.getModelInScope(), toFind);
    }

    private List<INameable> getMatchingElements(Object element, String toFind) {
        ArrayList<INameable> list = new ArrayList<INameable>();
        if (element != null) {
            if (toFind == null && element instanceof INameable) {
                list.add((INameable)element);
            } else if (this.matches(element, toFind)) {
                list.add((INameable)element);
            }
            Object[] objectArray = this.fTreeModelViewer.getSortedChildren(element);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                list.addAll(this.getMatchingElements(object, toFind));
                ++n2;
            }
        }
        return list;
    }

    private List<INameable> getAllNameableElements() {
        return this.getAllMatchingElements(null);
    }

    private boolean matches(Object object, String toFind) {
        if (object instanceof IFolder && !this.isIncludeFolders()) {
            return false;
        }
        if (object instanceof IArchimateRelationship && !this.isIncludeRelations()) {
            return false;
        }
        return object instanceof INameable && RenameCommandHandler.canRename(object) && StringUtils.isSet(toFind) && ((INameable)object).getName() != null && ((INameable)object).getName().matches(this.getSearchStringPattern(toFind));
    }

    private Object getFirstSelectedObject() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeModelViewer.getSelection();
        return selection.getFirstElement();
    }

    private List<Object> getSelectedObjects() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeModelViewer.getSelection();
        return selection.toList();
    }

    private IArchimateModel getModelInScope() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeModelViewer.getSelection();
        Object o = selection.getFirstElement();
        if (o instanceof IArchimateModelObject) {
            return ((IArchimateModelObject)o).getArchimateModel();
        }
        return null;
    }
}

