/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.tree;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.IDiagramModelEditor;
import com.archimatetool.editor.ui.components.PartListenerAdapter;
import com.archimatetool.editor.views.tree.TreeModelView;
import com.archimatetool.editor.views.tree.TreeModelViewer;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import com.archimatetool.model.IDiagramModelReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class TreeSelectionSynchroniser
implements ISelectionChangedListener {
    private IWorkbenchPage fPage;
    private TreeModelViewer fTreeViewer;
    private boolean isSelecting = false;
    private boolean doSync = true;
    private SelectionChangedEvent lastSelectionEvent;
    private IDiagramModelEditor lastActiveEditor;
    private PartListenerAdapter partListenerAdapter = new PartListenerAdapter(){

        @Override
        public void partOpened(IWorkbenchPart part) {
            if (part instanceof IDiagramModelEditor) {
                IDiagramModelEditor editor = (IDiagramModelEditor)part;
                TreeSelectionSynchroniser.this.registerEditor(editor);
            }
        }

        @Override
        public void partClosed(IWorkbenchPart part) {
            if (part instanceof IDiagramModelEditor) {
                IDiagramModelEditor editor = (IDiagramModelEditor)part;
                TreeSelectionSynchroniser.this.unregisterEditor(editor);
            }
            if (part == TreeSelectionSynchroniser.this.lastActiveEditor) {
                TreeSelectionSynchroniser.this.lastActiveEditor = null;
            }
        }

        @Override
        public void partActivated(IWorkbenchPart part) {
            if (part == TreeSelectionSynchroniser.this.lastActiveEditor) {
                return;
            }
            if (part instanceof IDiagramModelEditor) {
                IDiagramModelEditor editor = (IDiagramModelEditor)part;
                if (editor.getModel() != null && TreeSelectionSynchroniser.this.doSync()) {
                    TreeSelectionSynchroniser.this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)editor.getModel()), true);
                }
                TreeSelectionSynchroniser.this.lastActiveEditor = editor;
            }
        }
    };
    private IPropertyChangeListener prefsListener = event -> {
        if (event.getProperty().equals("linkView") && event.getNewValue() == Boolean.TRUE) {
            this.updateSelection();
        }
    };

    TreeSelectionSynchroniser(TreeModelView treeModelView) {
        this.fTreeViewer = treeModelView.getViewer();
        this.fPage = treeModelView.getSite().getPage();
        this.registerListeners();
        this.fTreeViewer.getTree().addDisposeListener(e -> {
            this.unregisterListeners();
            this.fTreeViewer = null;
            this.fPage = null;
            this.lastActiveEditor = null;
            this.lastSelectionEvent = null;
            this.partListenerAdapter = null;
            this.prefsListener = null;
        });
    }

    public void setSynchronise(boolean set) {
        this.doSync = set;
    }

    private boolean doSync() {
        return this.doSync && ArchiPlugin.getInstance().getPreferenceStore().getBoolean("linkView");
    }

    private void updateSelection() {
        if (this.lastSelectionEvent == null) {
            IDiagramModelEditor editor;
            IEditorPart activeEditor = this.fPage.getActiveEditor();
            if (activeEditor instanceof IDiagramModelEditor && (editor = (IDiagramModelEditor)activeEditor).getGraphicalViewer() != null) {
                this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)editor.getGraphicalViewer(), editor.getGraphicalViewer().getSelection()));
            }
        } else {
            this.selectionChanged(this.lastSelectionEvent);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.isSelecting) {
            return;
        }
        this.lastSelectionEvent = event;
        if (!this.doSync()) {
            return;
        }
        this.isSelecting = true;
        Object source = event.getSource();
        Object[] selectedObjects = event.getStructuredSelection().toArray();
        if (source instanceof GraphicalViewer) {
            ArrayList<Object> selected = new ArrayList<Object>();
            Object[] objectArray = selectedObjects;
            int n = selectedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof EditPart) {
                    EditPart editPart = (EditPart)o;
                    Object model = editPart.getModel();
                    if (model instanceof IDiagramModelArchimateComponent) {
                        IDiagramModelArchimateComponent dmc = (IDiagramModelArchimateComponent)model;
                        selected.add(dmc.getArchimateConcept());
                    } else if (model instanceof IDiagramModelReference) {
                        IDiagramModelReference dmr = (IDiagramModelReference)model;
                        selected.add(dmr.getReferencedModel());
                    } else if (model instanceof IDiagramModel) {
                        selected.add(model);
                    }
                }
                ++n2;
            }
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(selected), true);
        } else if (source instanceof TreeViewer) {
            for (IDiagramModelEditor editor : this.getOpenEditors()) {
                editor.selectObjects(selectedObjects);
            }
        }
        this.isSelecting = false;
    }

    private void registerListeners() {
        this.fPage.addPartListener((IPartListener)this.partListenerAdapter);
        this.fTreeViewer.addSelectionChangedListener(this);
        for (IDiagramModelEditor editor : this.getOpenEditors()) {
            this.registerEditor(editor);
        }
        ArchiPlugin.getInstance().getPreferenceStore().addPropertyChangeListener(this.prefsListener);
    }

    private void unregisterListeners() {
        this.fPage.removePartListener((IPartListener)this.partListenerAdapter);
        this.fTreeViewer.removeSelectionChangedListener(this);
        for (IDiagramModelEditor editor : this.getOpenEditors()) {
            this.unregisterEditor(editor);
        }
        ArchiPlugin.getInstance().getPreferenceStore().removePropertyChangeListener(this.prefsListener);
    }

    private void registerEditor(IDiagramModelEditor editor) {
        GraphicalViewer viewer = editor.getGraphicalViewer();
        if (viewer != null) {
            viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    private void unregisterEditor(IDiagramModelEditor editor) {
        GraphicalViewer viewer = editor.getGraphicalViewer();
        if (viewer != null) {
            viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    private List<IDiagramModelEditor> getOpenEditors() {
        ArrayList<IDiagramModelEditor> list = new ArrayList<IDiagramModelEditor>();
        IEditorReference[] iEditorReferenceArray = this.fPage.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDiagramModelEditor editor;
            IEditorReference ref = iEditorReferenceArray[n2];
            IEditorPart iEditorPart = ref.getEditor(false);
            if (iEditorPart instanceof IDiagramModelEditor && (editor = (IDiagramModelEditor)iEditorPart).getModel() != null) {
                list.add(editor);
            }
            ++n2;
        }
        return list;
    }
}

