/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.tree;

import com.archimatetool.editor.model.IEditorModelManager;
import com.archimatetool.editor.views.tree.TreeModelViewer;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.util.ArchimateModelUtils;
import com.archimatetool.model.util.Logger;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.IMemento;

public class TreeStateHelper {
    public static TreeStateHelper INSTANCE = new TreeStateHelper();
    private static final String ELEMENT_SEP_CHAR = " ";
    private static final String MEMENTO_EXPANDED = "expanded";
    private static final String MEMENTO_MODEL = "model";
    private static final String MEMENTO_FILE = "file";
    private static final String MEMENTO_ELEMENTS = "elements";
    private IMemento memento;

    private TreeStateHelper() {
    }

    void setMemento(IMemento memento) {
        this.memento = memento;
    }

    void restoreExpandedTreeElements(TreeModelViewer viewer) {
        if (this.memento == null) {
            return;
        }
        IMemento expandedMem = this.memento.getChild(MEMENTO_EXPANDED);
        if (expandedMem != null) {
            try {
                IMemento[] iMementoArray = expandedMem.getChildren(MEMENTO_MODEL);
                int n = iMementoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento elementMem = iMementoArray[n2];
                    String filePath = elementMem.getString(MEMENTO_FILE);
                    String elements = elementMem.getString(MEMENTO_ELEMENTS);
                    if (filePath != null && elements != null) {
                        File file = new File(filePath);
                        for (IArchimateModel model : IEditorModelManager.INSTANCE.getModels()) {
                            if (!file.equals(model.getFile())) continue;
                            Map objectMap = ArchimateModelUtils.getObjectIDMap((IArchimateModel)model);
                            String[] stringArray = elements.split(ELEMENT_SEP_CHAR);
                            int n3 = stringArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String id = stringArray[n4];
                                EObject object = (EObject)objectMap.get(id);
                                if (object != null) {
                                    viewer.expandToLevel(object, 1);
                                }
                                ++n4;
                            }
                            break block3;
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception ex) {
                Logger.logError((String)"Error restoring tree state", (Throwable)ex);
            }
        }
        this.memento = null;
    }

    void saveStateToMemento(TreeModelViewer viewer, IMemento memento) {
        HashMap<File, String> map = new HashMap<File, String>();
        Object[] objectArray = viewer.getRootVisibleExpandedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file;
            IArchimateModelObject modelObject;
            Object object = objectArray[n2];
            if (object instanceof IArchimateModelObject && (modelObject = (IArchimateModelObject)object).getArchimateModel() != null && (file = modelObject.getArchimateModel().getFile()) != null) {
                String id = modelObject.getId();
                String string = (String)map.get(file);
                string = string == null ? id : string + ELEMENT_SEP_CHAR + id;
                map.put(file, string);
            }
            ++n2;
        }
        if (map.isEmpty()) {
            return;
        }
        IMemento expandedMem = memento.createChild(MEMENTO_EXPANDED);
        for (Map.Entry entry : map.entrySet()) {
            IMemento elementMem = expandedMem.createChild(MEMENTO_MODEL);
            elementMem.putString(MEMENTO_FILE, ((File)entry.getKey()).getAbsolutePath());
            elementMem.putString(MEMENTO_ELEMENTS, (String)entry.getValue());
        }
    }
}

